package com.bokesoft.erp.design.config;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import com.bokesoft.yes.mid.meta.MidMetaFactory;
import com.bokesoft.yigo.meta.dataelement.MetaDataElementDef;
import com.bokesoft.yigo.meta.domain.MetaDomainDef;
import com.bokesoft.yigo.meta.factory.DefaultMetaFactory;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;

/**
 * 设计器扩展的配置对象工厂
 */
public class ERPWebDesignerMetaFactory extends MidMetaFactory {
	private Map<String, MetaDataElementDef> cachedMetaDataElementDefs = new ConcurrentHashMap<>();
	private Map<String, MetaDomainDef> cachedMetaDomainDefs = new ConcurrentHashMap<>();

	private DefaultMetaFactory designerMetaFactory;
	public ERPWebDesignerMetaFactory(IMetaResolverFactory resolverFactory) {
		super(resolverFactory);
	}

	public void setDesignerMetaFactory(DefaultMetaFactory designerMetaFactory) {
		this.designerMetaFactory = designerMetaFactory;
	}

	@Override
	public MetaDataElementDef getDataElementDef(String solutionKey) {
		MetaDataElementDef def = cachedMetaDataElementDefs.computeIfAbsent(solutionKey, key -> {
			MetaDataElementDef dataElementDef = super.getDataElementDef("");
			if (dataElementDef == null){
				dataElementDef = designerMetaFactory.getDataElementDef("");
			}else{
				MetaDataElementDef clone = (MetaDataElementDef) dataElementDef.clone();
				clone.toMerge( designerMetaFactory.getDataElementDef(""));
				dataElementDef = clone;
			}
			return dataElementDef;
		});
		return def;
	}

	@Override
	public MetaDomainDef getDomainDef(String solutionKey) {
		MetaDomainDef def = cachedMetaDomainDefs.computeIfAbsent(solutionKey, key -> {
			MetaDomainDef domainDef = super.getDomainDef("");
			if (domainDef == null) {
				domainDef = designerMetaFactory.getDomainDef("");
				return domainDef;
			}else{
				MetaDomainDef clone = (MetaDomainDef) domainDef.clone();
				clone.toMerge(designerMetaFactory.getDomainDef(""));
				return clone;
			}
		});
		return def;
	}
}