package com.bokesoft.erp.desigerfunction;

import com.bokesoft.erp.para.ParaDefine;
import com.bokesoft.yes.common.struct.HashMapIgnoreCase;

import java.util.Map;

public interface IBusinessDesignerSetting extends IRegisterDesigerFunction {
	// 初始化表单
	public String[] initializeFormKeys() throws ClassNotFoundException;

	// 定义需要进行全局缓存处理的表单，如果已经在初始化数据表单里进行过定义，不需要重复定义
	public String[] globalCacheFormKeys() throws ClassNotFoundException;

	// 定义主数据表单
	public default String[] masterFormKeys() { return null; };

	public default Map<String, ParaDefine> getParaDefine() {
		return null;
	}

	/**
	 * 针对OID的预加载源 <br>
	 * 参考oidSource.put("表名", new String[][] {{"对应的数据表", "对应于SOID的字段"}});
	 *
	 * @return
	 */
	public default HashMapIgnoreCase<String[][]> preLoadSetting_oidSource() {
		return null;
	}

	/**
	 * 针对SOID和第二主键组成的唯一索引的预加载源<br>
	 * soidUniqueIndexSecondFieldSource.put("表名", new String[][] {{"对应的数据表",
	 * "对应于SOID的字段", "对应于第二主键的字段"}}); <br>
	 * 注意：对应的数据表可以有多个
	 *
	 * @return
	 */
	public default HashMapIgnoreCase<String[][]> preLoadSetting_soidUniqueIndexSecondFieldSource() {
		return null;
	}

	/**
	 * 针对POID的预加载<br>
	 * poidRelationShip.put("子明细表名", new String[][] {{"明细表名", "对应于明细表主键的字段"}});
	 *
	 * @return
	 */
	public default HashMapIgnoreCase<String[][]> preLoadSetting_poidRelationShip() {
		return null;
	}
}

