package com.bokesoft.erp.all.controller;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.erp.all.initiator.InitializingDesigner;
import com.bokesoft.yes.design.function.DesignActionUtil;
import com.bokesoft.yes.design.vo.ResponseResult;
import org.springframework.core.env.Environment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;

/**
 *
 */
@RestController
public class GetPropertiesController {
	@Autowired
	private Environment environment;

	@PostMapping("/getProperties")
	public ResponseResult<JSONObject> getProperties() throws Throwable {
		ResponseResult<JSONObject> response = new ResponseResult<>();
		//获取项目端口号server.port=8088
		//MetaFactory.getGlobalInstance().getSetting().getSession().setTimeout(10);
		String port = environment.getProperty("server.port");
		String property = environment.getProperty("server.servlet.context-path");
		boolean showError = Boolean.parseBoolean(DesignActionUtil.getPreferencesInfo("ShowError"));
		boolean enable = environment.getProperty("application-erp.webdesigner.enable", boolean.class);
		boolean xmlwordwrap = Boolean.parseBoolean(DesignActionUtil.getPreferencesInfo("XmlWordWrap"));
		boolean delayedProcessScope = Boolean.parseBoolean(DesignActionUtil.getPreferencesInfo("DelayedProcessScope"));
		boolean reloadOnlyComment = Boolean.parseBoolean(DesignActionUtil.getPreferencesInfo("ReloadOnlyComment"));
		boolean fileTreeRowClick = Boolean.parseBoolean(DesignActionUtil.getPreferencesInfo("FileTreeRowClick"));
		boolean renderType = Boolean.parseBoolean(DesignActionUtil.getPreferencesInfo("RenderType"));
		String xmlEditorFont = DesignActionUtil.getPreferencesInfo("Font");
		String xmlEditorFontSize = DesignActionUtil.getPreferencesInfo("FontSize");
		JSONObject jsonObject = new JSONObject();
		if (enable) {
			jsonObject.put("port", port);
			jsonObject.put("name", property);
			jsonObject.put("webdesignerShowError", showError);
			jsonObject.put("webdesignerEnable", enable);
			jsonObject.put("xmlWordWrap", xmlwordwrap);
			jsonObject.put("delayedProcessScope", delayedProcessScope);
			jsonObject.put("xmlEditorFont", xmlEditorFont);
			jsonObject.put("xmlEditorFontSize", xmlEditorFontSize);
			jsonObject.put("reloadOnlyComment", reloadOnlyComment);
			jsonObject.put("fileTreeRowClick", fileTreeRowClick);
			jsonObject.put("renderType", renderType);
			jsonObject.put("initCacheID", InitializingDesigner.isInitCacheID());
			response.setCode(0);
			response.setMsg("返回成功");
			response.setData(jsonObject);
		} else {
			throw new RuntimeException("设计器当前环境下不可用!");
		}

		return response;

	}
	@PostMapping("/getFormulaKeys")
	public ResponseResult<JSONObject> getFormulaKeys() throws Throwable {
		ResponseResult<JSONObject> response = new ResponseResult<>();
		JSONObject jsonObject = new JSONObject();
		ArrayList<String> objects = new ArrayList<>();
		objects.add("DesignerFormulaCache");
		objects.add("DesignerSourceCache");
		objects.addAll(InitializingDesigner.getFormulaKeys());
		jsonObject.put("FormulaKeys",objects);
			response.setCode(0);
			response.setMsg("返回成功");
			response.setData(jsonObject);

		return response;

	}
}
