/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.xml.parse;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.xml.ex.TextSyntaxException;
import com.bokesoft.yes.xml.parse.CharUtil;
import com.bokesoft.yes.xml.parse.Entry;

public class TextAnalyzer {
    private static TextAnalyzer sington = new TextAnalyzer();

    public static TextAnalyzer New() {
        return sington;
    }

    public Entry getBlank(String string, int n) {
        int n2 = string.length();
        int n3 = n;
        while (n3 < string.length()) {
            char c = string.charAt(n3);
            if (!CharUtil.isBlank(c)) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 <= n) {
            return null;
        }
        Entry entry = new Entry();
        entry.setType(2);
        entry.setBg(n);
        entry.setEd(n2 - 1);
        return entry;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Entry getString(String string, int n, char[] cArray, char[] cArray2, boolean bl) {
        boolean bl2 = false;
        Entry entry = null;
        char c = '\"';
        int n2 = n;
        while (n2 < string.length()) {
            block15: {
                char c2 = string.charAt(n2);
                if (!bl2) {
                    if (!CharUtil.isBlank(c2)) {
                        if (!CharUtil.isInIt(c2, cArray)) {
                            return null;
                        }
                        bl2 = true;
                        c = c2;
                        entry = new Entry();
                        entry.setType(1);
                        entry.setBg(n2);
                    }
                } else {
                    if (c2 == c) {
                        if (n2 == string.length() - 1) {
                            entry.setEd(n2);
                            break;
                        }
                        if (CharUtil.isInIt(c2, cArray2)) {
                            if (string.charAt(n2 + 1) == c2) {
                                ++n2;
                                break block15;
                            } else {
                                entry.setEd(n2);
                                break;
                            }
                        }
                        entry.setEd(n2);
                        break;
                    }
                    if (CharUtil.isInIt(c2, cArray2)) {
                        ++n2;
                    } else if (!(c2 != '\r' && c2 != '\n' || bl)) {
                        throw new TextSyntaxException("\u5b57\u7b26\u4e32\u4e0d\u80fd\u6362\u884c[\\r\\n]\r\n[" + string.substring(n, n2) + "\r\n^^^^^^^^^^^^^^^^^^^^^^^^^^\r\n" + string.substring(n2) + "]");
                    }
                }
            }
            ++n2;
        }
        if (entry == null) {
            return null;
        }
        if (entry.getEd() == -1) {
            throw new TextSyntaxException("\u5b57\u7b26\u4e32\u6ca1\u6709\u6b63\u5e38\u7684\u7ed3\u675f[\\r\\n]\r\n[" + string.substring(entry.getBg()) + "]");
        }
        return entry;
    }

    public Entry getCommonString(String string, int n) {
        return this.getString(string, n, new char[]{'\"'}, new char[]{'\\'}, false);
    }

    public Entry getXmlString(String string, int n) {
        return this.getString(string, n, new char[]{'\"', '\''}, null, true);
    }

    public Entry getSqlString(String string, int n) {
        return this.getString(string, n, new char[]{'\''}, new char[]{'\\', '\''}, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Entry getName(String string, int n, char[] cArray, char[] cArray2) {
        boolean bl = false;
        Entry entry = new Entry();
        entry.setType(3);
        int n2 = n;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (!bl) {
                if (!CharUtil.isBlank(c)) {
                    if (!CharUtil.isNameStartChar(c)) return null;
                    bl = true;
                    entry.setBg(n2);
                }
            } else if (!CharUtil.isNameChar(c) && !CharUtil.isInIt(c, cArray)) {
                if (!CharUtil.isBlank(c) && !CharUtil.isInIt(c, cArray2)) throw new TextSyntaxException("\u5143\u7d20\u540d\u79f0\uff0c\u4e0d\u80fd\u542b\u6709\u5b57\u7b26[" + c + "]\r\n[" + string.substring(n, n2) + "\r\n^^^^^^^^^^^^^^^^^^^^^^^^^^\r\n" + string.substring(n2) + "]");
                entry.setEd(n2 - 1);
                break;
            }
            ++n2;
        }
        if (entry.getBg() == -1) {
            return null;
        }
        if (entry.getEd() != -1) return entry;
        entry.setEd(string.length() - 1);
        return entry;
    }

    public Entry getComment(String string, int n, String string2, String string3) {
        boolean bl = false;
        Entry entry = new Entry();
        entry.setType(4);
        int n2 = n;
        while (n2 < string.length()) {
            if (!bl) {
                if (StringUtil.isString((String)string, (String)string2, (int)n2)) {
                    bl = true;
                    entry.setBg(n2);
                    n2 += string2.length() - 1;
                }
            } else if (StringUtil.isString((String)string, (String)string3, (int)n2)) {
                entry.setEd(n2 + (string3.length() - 1));
                break;
            }
            ++n2;
        }
        if (entry.getBg() == -1) {
            return null;
        }
        if (entry.getEd() == -1) {
            throw new TextSyntaxException("Comment\u5143\u7d20\u6ca1\u6709\u7ed3\u5c3e\r\n[" + string.substring(entry.getBg()) + "]");
        }
        return entry;
    }
}

