/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.cmd.attachmentPreview;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.mid.cmd.attachmentPreview.IAttachmentPreview;
import com.bokesoft.yigo.common.util.TypeConvertor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.poi.ooxml.POIXMLException;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XlsxAttachmentPreview
implements IAttachmentPreview {
    private static /* synthetic */ int[] $SWITCH_TABLE$org$apache$poi$ss$usermodel$HorizontalAlignment;

    @Override
    public boolean isSupport(String string) throws Throwable {
        return string.equalsIgnoreCase("xlsx");
    }

    @Override
    public boolean isBlob() {
        return false;
    }

    @Override
    public boolean isShowInPDF() {
        return false;
    }

    @Override
    public String preview(byte[] byArray) throws Throwable {
        ByteArrayInputStream byteArrayInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        String string = "";
        IOUtils.setByteArrayMaxOverride((int)Integer.MAX_VALUE);
        try {
            try {
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                byteArrayOutputStream = new ByteArrayOutputStream();
                StringBuilder stringBuilder = new StringBuilder();
                XSSFWorkbook xSSFWorkbook = new XSSFWorkbook((InputStream)byteArrayInputStream);
                XSSFFormulaEvaluator xSSFFormulaEvaluator = xSSFWorkbook.getCreationHelper().createFormulaEvaluator();
                int n = 0;
                while (n < xSSFWorkbook.getNumberOfSheets()) {
                    this.a(xSSFWorkbook.getSheetAt(n), stringBuilder, (FormulaEvaluator)xSSFFormulaEvaluator);
                    ++n;
                }
                byteArrayOutputStream.write(stringBuilder.toString().getBytes(StandardCharsets.UTF_8));
                if (byteArrayOutputStream.size() > 0) {
                    string = byteArrayOutputStream.toString("UTF-8");
                }
            }
            catch (POIXMLException pOIXMLException) {
                throw new Exception("\u5f53\u524d\u9884\u89c8\u9644\u4ef6\u4e0d\u662f2007+\u683c\u5f0fExcel\u6587\u6863\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u683c\u5f0f", pOIXMLException);
            }
            catch (Throwable throwable) {
                throw new Exception("\u9884\u89c8\u6570\u636e\u51fa\u73b0\u9519\u8bef", throwable);
            }
        }
        finally {
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
            }
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
        }
        return string;
    }

    private void a(XSSFSheet xSSFSheet, StringBuilder stringBuilder, FormulaEvaluator formulaEvaluator) {
        if (xSSFSheet == null) {
            return;
        }
        stringBuilder.append("<table cellspacing='0' style='border-spacing:0; border-collapse:collapse;'>\n");
        int n = 0;
        while (n < xSSFSheet.getPhysicalNumberOfRows()) {
            this.a(xSSFSheet.getRow(n), stringBuilder, n, formulaEvaluator);
            ++n;
        }
        stringBuilder.append("</table>\n");
    }

    private void a(XSSFRow xSSFRow, StringBuilder stringBuilder, int n, FormulaEvaluator formulaEvaluator) {
        if (xSSFRow == null) {
            return;
        }
        stringBuilder.append("<tr ");
        int n2 = 0;
        while (n2 < xSSFRow.getSheet().getNumMergedRegions()) {
            CellRangeAddress cellRangeAddress = xSSFRow.getSheet().getMergedRegion(n2);
            if (n >= cellRangeAddress.getFirstRow() && n <= cellRangeAddress.getLastRow()) break;
            ++n2;
        }
        stringBuilder.append("style='");
        if (xSSFRow.getHeight() != -1) {
            stringBuilder.append("height: ").append(Math.round((double)xSSFRow.getHeight() / 20.0 * 1.33333)).append("px; ");
        }
        stringBuilder.append("'>\n");
        n2 = 0;
        while (n2 < xSSFRow.getLastCellNum()) {
            this.a(xSSFRow.getCell(n2), stringBuilder, formulaEvaluator);
            ++n2;
        }
        stringBuilder.append("</tr>\n");
    }

    private void a(XSSFCell xSSFCell, StringBuilder stringBuilder, FormulaEvaluator formulaEvaluator) {
        stringBuilder.append("<td ");
        if (xSSFCell == null) {
            stringBuilder.append("/>\n");
            return;
        }
        stringBuilder.append("style='");
        XSSFCellStyle xSSFCellStyle = xSSFCell.getCellStyle();
        switch (XlsxAttachmentPreview.a()[xSSFCellStyle.getAlignment().ordinal()]) {
            case 2: {
                stringBuilder.append("text-align: left; ");
                break;
            }
            case 4: {
                stringBuilder.append("text-align: right; ");
                break;
            }
            case 3: {
                stringBuilder.append("text-align: center; ");
                break;
            }
        }
        XSSFFont xSSFFont = xSSFCellStyle.getFont();
        if (xSSFFont.getBold()) {
            stringBuilder.append("font-weight: bold; ");
        }
        if (xSSFFont.getItalic()) {
            stringBuilder.append("font-style: italic; ");
        }
        if (xSSFFont.getUnderline() != 0) {
            stringBuilder.append("text-decoration: underline; ");
        }
        stringBuilder.append("font-size: ").append(Math.floor((double)xSSFFont.getFontHeightInPoints() * 0.8)).append("pt; ");
        if (xSSFCellStyle.getBorderTop() != BorderStyle.NONE) {
            stringBuilder.append("border-top-style: solid; ");
        }
        if (xSSFCellStyle.getBorderRight() != BorderStyle.NONE) {
            stringBuilder.append("border-right-style: solid; ");
        }
        if (xSSFCellStyle.getBorderBottom() != BorderStyle.NONE) {
            stringBuilder.append("border-bottom-style: solid; ");
        }
        if (xSSFCellStyle.getBorderLeft() != BorderStyle.NONE) {
            stringBuilder.append("border-left-style: solid; ");
        }
        stringBuilder.append("'>");
        String string = "";
        try {
            block8 : switch (xSSFCell.getCellType()) {
                case NUMERIC: {
                    short s = xSSFCell.getCellStyle().getDataFormat();
                    if (DateUtil.isCellDateFormatted((Cell)xSSFCell)) {
                        SimpleDateFormat simpleDateFormat;
                        if (s == 20 || s == 32) {
                            simpleDateFormat = new SimpleDateFormat("HH:mm");
                        } else if (s == 14 || s == 31 || s == 57 || s == 58) {
                            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                            double d = xSSFCell.getNumericCellValue();
                            Date date = DateUtil.getJavaDate((double)d);
                            string = simpleDateFormat.format(date);
                        } else {
                            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        }
                        try {
                            string = simpleDateFormat.format(xSSFCell.getDateCellValue());
                        }
                        catch (Exception exception) {
                            try {
                                throw new Exception("exception on get date data !".concat(exception.toString()));
                            }
                            catch (Exception exception2) {
                                LogSvr.getInstance().error(exception2.getMessage(), (Throwable)exception2);
                            }
                        }
                        break;
                    }
                    BigDecimal bigDecimal = TypeConvertor.toBigDecimal((Object)xSSFCell.getNumericCellValue());
                    string = bigDecimal.toPlainString();
                    break;
                }
                case STRING: {
                    if (xSSFCell.getHyperlink() != null) {
                        string = "<a href=" + xSSFCell.getHyperlink().getAddress() + " target=\"_blank\">" + xSSFCell.getStringCellValue() + "</a>";
                        break;
                    }
                    string = "<pre>" + xSSFCell.getStringCellValue() + "</pre>";
                    break;
                }
                case BOOLEAN: {
                    string = TypeConvertor.toString((Object)xSSFCell.getBooleanCellValue());
                    break;
                }
                case FORMULA: {
                    CellValue cellValue = formulaEvaluator.evaluate((Cell)xSSFCell);
                    switch (cellValue.getCellType()) {
                        case BOOLEAN: {
                            string = TypeConvertor.toString((Object)cellValue.getBooleanValue());
                            break block8;
                        }
                        case NUMERIC: {
                            BigDecimal bigDecimal = TypeConvertor.toBigDecimal((Object)cellValue.getNumberValue());
                            string = bigDecimal.toPlainString();
                            break block8;
                        }
                        case STRING: {
                            string = cellValue.getStringValue();
                            break block8;
                        }
                    }
                    break;
                }
                case BLANK: {
                    string = "";
                    break;
                }
                case ERROR: {
                    string = "ERROR VALUE";
                    break;
                }
                default: {
                    string = "UNKNOW VALUE";
                    break;
                }
            }
        }
        catch (Exception exception) {
            string = exception.getMessage();
        }
        stringBuilder.append(string);
        stringBuilder.append("</td>\n");
    }

    static /* synthetic */ int[] a() {
        if ($SWITCH_TABLE$org$apache$poi$ss$usermodel$HorizontalAlignment != null) {
            return $SWITCH_TABLE$org$apache$poi$ss$usermodel$HorizontalAlignment;
        }
        int[] nArray = new int[HorizontalAlignment.values().length];
        try {
            nArray[HorizontalAlignment.CENTER.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HorizontalAlignment.CENTER_SELECTION.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HorizontalAlignment.DISTRIBUTED.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HorizontalAlignment.FILL.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HorizontalAlignment.GENERAL.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HorizontalAlignment.JUSTIFY.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HorizontalAlignment.LEFT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HorizontalAlignment.RIGHT.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$apache$poi$ss$usermodel$HorizontalAlignment = nArray;
        return nArray;
    }
}

