/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.erp.lock;

import com.bokesoft.erp.redis.RedisUtils;
import com.bokesoft.yes.erp.lock.ILockDelegate;
import com.bokesoft.yes.erp.lock.LockRedisClusterDelegate;
import com.bokesoft.yes.erp.lock.LockRedisDelegate;
import com.bokesoft.yes.mid.util.PropertyUtil;
import com.bokesoft.yigo.cache.CacheFactory;
import com.bokesoft.yigo.cache.ICache;
import com.bokesoft.yigo.common.util.TypeConvertor;
import java.io.InputStream;
import java.util.PropertyResourceBundle;

public class LockRedisDelegateFactory {
    private static volatile ILockDelegate lockDelegate = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ILockDelegate getLockDelegate() throws Throwable {
        if (lockDelegate != null) return lockDelegate;
        Class<LockRedisDelegateFactory> clazz = LockRedisDelegateFactory.class;
        synchronized (LockRedisDelegateFactory.class) {
            if (lockDelegate != null) return lockDelegate;
            if (RedisUtils.isRedisCluster()) {
                lockDelegate = new LockRedisClusterDelegate();
            } else {
                InputStream inputStream = PropertyUtil.readProperties((String)"redis.properties");
                PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(inputStream);
                int n = 0;
                if (propertyResourceBundle.containsKey("LockDBIndex")) {
                    n = TypeConvertor.toInteger((Object)propertyResourceBundle.getObject("LockDBIndex"));
                } else {
                    ICache iCache = CacheFactory.getInstance().createCache("{BusinessLock}");
                    long l = iCache.size();
                    n = (int)(l + 1L);
                }
                lockDelegate = new LockRedisDelegate(n);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return lockDelegate;
        }
    }
}

