/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.datarepoter;

import com.bokesoft.yes.mid.cmd.richdocument.delay.FormulaItem;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocument;
import com.bokesoft.yigo.common.dependency.IDependencySortable;
import com.bokesoft.yigo.common.trace.intf.IDataReporter;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.mid.trace.reporter.DefaultDocumentReporter;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RichDocumentDataReporter
implements IDependencySortable,
IDataReporter<RichDocument> {
    private static final Logger logger = LoggerFactory.getLogger(RichDocumentDataReporter.class);

    public String getAbstract(RichDocument richDocument) {
        String string = richDocument.getMetaForm().getKey();
        return String.valueOf(string) + "-" + richDocument.getOID();
    }

    public String getData(RichDocument richDocument) {
        StringBuffer stringBuffer = new StringBuffer("###### RichDocument: ");
        stringBuffer.append(this.getAbstract(richDocument));
        stringBuffer.append("'s Data ######");
        stringBuffer.append("\n");
        MetaDataObject metaDataObject = richDocument.getMetaDataObject();
        if (metaDataObject == null) {
            stringBuffer.append("### \u65e0\u6570\u636e\u5bf9\u8c61 ###");
            return stringBuffer.toString();
        }
        MetaTableCollection metaTableCollection = metaDataObject.getTableCollection();
        if (metaTableCollection == null) {
            stringBuffer.append("### \u65e0\u6570\u636e\u8868 ###");
            return stringBuffer.toString();
        }
        try {
            List<FormulaItem> list = richDocument.collectDelayFormula();
            if (list == null || list.isEmpty()) {
                stringBuffer.append("###### \u6ca1\u6709\u8fd8\u672a\u8ba1\u7b97\u5ef6\u540e\u8ba1\u7b97\u516c\u5f0f");
            } else {
                stringBuffer.append("###### \u8fd8\u672a\u8ba1\u7b97\u5ef6\u540e\u8ba1\u7b97\u516c\u5f0f: " + list);
            }
            for (MetaTable metaTable : metaTableCollection) {
                DataTable dataTable = richDocument.get_impl(metaTable.getKey());
                if (dataTable == null) continue;
                stringBuffer.append("###### Datatable: ");
                stringBuffer.append(metaTable.getKey());
                stringBuffer.append("'s Data ######");
                stringBuffer.append("\n");
                stringBuffer.append(dataTable.toJSON().toString());
            }
        }
        catch (Throwable throwable) {
            logger.error(throwable.getMessage(), throwable);
            stringBuffer.append("deserialize error");
        }
        return stringBuffer.toString();
    }

    public boolean isSupport(Object object) {
        return object instanceof RichDocument;
    }

    public String[] getDependencyClasses() {
        return new String[0];
    }

    public String[] getDependentClasses() {
        return new String[]{DefaultDocumentReporter.class.getName()};
    }
}

