/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.util.deparser;

import java.util.Iterator;
import java.util.List;
import net.boke.jsqlparser.expression.AllComparisonExpression;
import net.boke.jsqlparser.expression.AnalyticExpression;
import net.boke.jsqlparser.expression.AnyComparisonExpression;
import net.boke.jsqlparser.expression.BinaryExpression;
import net.boke.jsqlparser.expression.CaseExpression;
import net.boke.jsqlparser.expression.CastExpression;
import net.boke.jsqlparser.expression.DateValue;
import net.boke.jsqlparser.expression.DoubleValue;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.ExpressionVisitor;
import net.boke.jsqlparser.expression.Function;
import net.boke.jsqlparser.expression.InverseExpression;
import net.boke.jsqlparser.expression.JdbcParameter;
import net.boke.jsqlparser.expression.LongValue;
import net.boke.jsqlparser.expression.NullValue;
import net.boke.jsqlparser.expression.OracleHierarchicalExpression;
import net.boke.jsqlparser.expression.OracleHint;
import net.boke.jsqlparser.expression.Parenthesis;
import net.boke.jsqlparser.expression.StringValue;
import net.boke.jsqlparser.expression.TimeValue;
import net.boke.jsqlparser.expression.TimestampValue;
import net.boke.jsqlparser.expression.WhenClause;
import net.boke.jsqlparser.expression.WithinGroupExpression;
import net.boke.jsqlparser.expression.operators.arithmetic.Addition;
import net.boke.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import net.boke.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import net.boke.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import net.boke.jsqlparser.expression.operators.arithmetic.Concat;
import net.boke.jsqlparser.expression.operators.arithmetic.Division;
import net.boke.jsqlparser.expression.operators.arithmetic.Modulo;
import net.boke.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.boke.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.boke.jsqlparser.expression.operators.conditional.AndExpression;
import net.boke.jsqlparser.expression.operators.conditional.OrExpression;
import net.boke.jsqlparser.expression.operators.relational.Between;
import net.boke.jsqlparser.expression.operators.relational.EqualsTo;
import net.boke.jsqlparser.expression.operators.relational.ExistsExpression;
import net.boke.jsqlparser.expression.operators.relational.ExpressionList;
import net.boke.jsqlparser.expression.operators.relational.GreaterThan;
import net.boke.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.boke.jsqlparser.expression.operators.relational.InExpression;
import net.boke.jsqlparser.expression.operators.relational.IsNullExpression;
import net.boke.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.boke.jsqlparser.expression.operators.relational.LikeExpression;
import net.boke.jsqlparser.expression.operators.relational.Matches;
import net.boke.jsqlparser.expression.operators.relational.MinorThan;
import net.boke.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.boke.jsqlparser.expression.operators.relational.MultiInExpression;
import net.boke.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.SelectVisitor;
import net.boke.jsqlparser.statement.select.SubSelect;
import net.boke.jsqlparser.util.deparser.SelectDeParser;

public class ExpressionDeParser
implements ExpressionVisitor,
ItemsListVisitor {
    protected StringBuffer buffer;
    protected SelectVisitor selectVisitor;
    protected boolean useBracketsInExprList = true;

    public ExpressionDeParser() {
    }

    public ExpressionDeParser(SelectVisitor selectVisitor, StringBuffer buffer) {
        this.selectVisitor = selectVisitor;
        this.buffer = buffer;
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void visit(Addition addition) {
        this.visitBinaryExpression(addition, " + ");
    }

    @Override
    public void visit(AndExpression andExpression) {
        this.visitBinaryExpression(andExpression, " AND ");
    }

    @Override
    public void visit(Between between) {
        between.getLeftExpression().accept(this);
        if (between.isNot()) {
            this.buffer.append(" NOT");
        }
        this.buffer.append(" BETWEEN ");
        between.getBetweenExpressionStart().accept(this);
        this.buffer.append(" AND ");
        between.getBetweenExpressionEnd().accept(this);
    }

    @Override
    public void visit(Division division) {
        this.visitBinaryExpression(division, " / ");
    }

    @Override
    public void visit(DoubleValue doubleValue) {
        this.buffer.append(doubleValue.getValue());
    }

    @Override
    public void visit(EqualsTo equalsTo) {
        this.visitBinaryExpression(equalsTo, " = ");
    }

    @Override
    public void visit(GreaterThan greaterThan) {
        this.visitBinaryExpression(greaterThan, " > ");
    }

    @Override
    public void visit(GreaterThanEquals greaterThanEquals) {
        this.visitBinaryExpression(greaterThanEquals, " >= ");
    }

    @Override
    public void visit(InExpression inExpression) {
        inExpression.getLeftExpression().accept(this);
        if (inExpression.isNot()) {
            this.buffer.append(" NOT");
        }
        this.buffer.append(" IN ");
        boolean oldUseBracketsInExprList = this.useBracketsInExprList;
        this.useBracketsInExprList = true;
        inExpression.getItemsList().accept(this);
        this.useBracketsInExprList = oldUseBracketsInExprList;
    }

    @Override
    public void visit(MultiInExpression multiInExpression) {
        this.buffer.append("(");
        List<Column> columnList = multiInExpression.getColumnList();
        columnList.get(0).accept(this);
        int i = 1;
        int size = columnList.size();
        while (i < size) {
            this.buffer.append(",");
            Column column = columnList.get(i);
            column.accept(this);
            ++i;
        }
        this.buffer.append(") IN (");
        List<List<Expression>> valuesList = multiInExpression.getValuesList();
        this.visit(valuesList.get(0));
        int i2 = 1;
        int size2 = valuesList.size();
        while (i2 < size2) {
            this.buffer.append(",");
            this.visit(valuesList.get(i2));
            ++i2;
        }
        this.buffer.append(")");
    }

    private void visit(List<Expression> values) {
        this.buffer.append("(");
        Expression value = values.get(0);
        value.accept(this);
        int i = 1;
        int size = values.size();
        while (i < size) {
            this.buffer.append(",");
            value = values.get(i);
            value.accept(this);
            ++i;
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(InverseExpression inverseExpression) {
        this.buffer.append("-");
        inverseExpression.getExpression().accept(this);
    }

    @Override
    public void visit(IsNullExpression isNullExpression) {
        isNullExpression.getLeftExpression().accept(this);
        if (isNullExpression.isNot()) {
            this.buffer.append(" IS NOT NULL");
        } else {
            this.buffer.append(" IS NULL");
        }
    }

    @Override
    public void visit(JdbcParameter jdbcParameter) {
        this.buffer.append("?");
    }

    @Override
    public void visit(LikeExpression likeExpression) {
        this.visitBinaryExpression(likeExpression, " LIKE ");
        String escape = likeExpression.getEscape();
        if (escape != null) {
            this.buffer.append(" ESCAPE '").append(escape).append("'");
        }
    }

    @Override
    public void visit(ExistsExpression existsExpression) {
        if (existsExpression.isNot()) {
            this.buffer.append(" NOT EXISTS ");
        } else {
            this.buffer.append(" EXISTS ");
        }
        existsExpression.getRightExpression().accept(this);
    }

    @Override
    public void visit(LongValue longValue) {
        this.buffer.append(longValue.getStringValue());
    }

    @Override
    public void visit(MinorThan minorThan) {
        this.visitBinaryExpression(minorThan, " < ");
    }

    @Override
    public void visit(MinorThanEquals minorThanEquals) {
        this.visitBinaryExpression(minorThanEquals, " <= ");
    }

    @Override
    public void visit(Multiplication multiplication) {
        this.visitBinaryExpression(multiplication, " * ");
    }

    @Override
    public void visit(NotEqualsTo notEqualsTo) {
        this.visitBinaryExpression(notEqualsTo, " <> ");
    }

    @Override
    public void visit(NullValue nullValue) {
        this.buffer.append("NULL");
    }

    @Override
    public void visit(OrExpression orExpression) {
        this.visitBinaryExpression(orExpression, " OR ");
    }

    @Override
    public void visit(Parenthesis parenthesis) {
        if (parenthesis.isNot()) {
            this.buffer.append(" NOT ");
        }
        this.buffer.append("(");
        parenthesis.getExpression().accept(this);
        this.buffer.append(")");
    }

    @Override
    public void visit(StringValue stringValue) {
        this.buffer.append("'" + stringValue.getValue() + "'");
    }

    @Override
    public void visit(Subtraction subtraction) {
        this.visitBinaryExpression(subtraction, "-");
    }

    protected void visitBinaryExpression(BinaryExpression binaryExpression, String operator) {
        if (binaryExpression.isNot() && !(binaryExpression instanceof LikeExpression)) {
            this.buffer.append(" NOT ");
        }
        binaryExpression.getLeftExpression().accept(this);
        if (binaryExpression.isNot() && binaryExpression instanceof LikeExpression) {
            this.buffer.append(" NOT ");
        }
        this.buffer.append(operator);
        binaryExpression.getRightExpression().accept(this);
    }

    @Override
    public void visit(SubSelect subSelect) {
        if (this.selectVisitor == null) {
            this.selectVisitor = new SelectDeParser();
            ((SelectDeParser)this.selectVisitor).setBuffer(this.buffer);
            ExpressionDeParser expressionDeParser = new ExpressionDeParser(this.selectVisitor, this.buffer);
            ((SelectDeParser)this.selectVisitor).setExpressionVisitor(expressionDeParser);
        }
        this.buffer.append("(");
        subSelect.getSelectBody().accept(this.selectVisitor);
        this.buffer.append(")");
    }

    @Override
    public void visit(Column tableColumn) {
        this.buffer.append(tableColumn.getWholeColumnName());
    }

    @Override
    public void visit(Function function) {
        if (function.isEscaped()) {
            this.buffer.append("{fn ");
        }
        ExpressionList orderByList = function.getOrderByList();
        this.buffer.append(function.getName());
        if (function.isAllColumns()) {
            this.buffer.append("(*)");
        } else if (function.getParameters() == null) {
            this.buffer.append("()");
        } else {
            String separator;
            boolean oldUseBracketsInExprList = this.useBracketsInExprList;
            this.useBracketsInExprList = false;
            this.buffer.append("(");
            if (function.isDistinct()) {
                this.buffer.append("DISTINCT ");
            }
            this.visit(function.getParameters());
            if (orderByList != null) {
                this.buffer.append(" ORDER BY ");
                this.buffer.append(PlainSelect.getStringList(orderByList.getExpressions(), true, false));
            }
            if ((separator = function.getSeparator()) != null) {
                this.buffer.append(" SEPARATOR ").append(separator);
            }
            this.buffer.append(")");
            this.useBracketsInExprList = oldUseBracketsInExprList;
        }
        if (function.isEscaped()) {
            this.buffer.append("}");
        }
    }

    @Override
    public void visit(ExpressionList expressionList) {
        if (this.useBracketsInExprList) {
            this.buffer.append("(");
        }
        Iterator iter = expressionList.getExpressions().iterator();
        while (iter.hasNext()) {
            Expression expression = (Expression)iter.next();
            expression.accept(this);
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
        if (this.useBracketsInExprList) {
            this.buffer.append(")");
        }
    }

    public SelectVisitor getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setSelectVisitor(SelectVisitor visitor) {
        this.selectVisitor = visitor;
    }

    @Override
    public void visit(DateValue dateValue) {
        this.buffer.append("{d '" + dateValue.getValue().toString() + "'}");
    }

    @Override
    public void visit(TimestampValue timestampValue) {
        this.buffer.append("{ts '" + timestampValue.getValue().toString() + "'}");
    }

    @Override
    public void visit(TimeValue timeValue) {
        this.buffer.append("{t '" + timeValue.getValue().toString() + "'}");
    }

    @Override
    public void visit(CaseExpression caseExpression) {
        this.buffer.append("CASE ");
        Expression switchExp = caseExpression.getSwitchExpression();
        if (switchExp != null) {
            switchExp.accept(this);
        }
        List clauses = caseExpression.getWhenClauses();
        for (Expression exp : clauses) {
            exp.accept(this);
        }
        Expression elseExp = caseExpression.getElseExpression();
        if (elseExp != null) {
            this.buffer.append(" ELSE ");
            elseExp.accept(this);
        }
        this.buffer.append(" END");
    }

    @Override
    public void visit(WhenClause whenClause) {
        this.buffer.append(" WHEN ");
        whenClause.getWhenExpression().accept(this);
        this.buffer.append(" THEN ");
        whenClause.getThenExpression().accept(this);
    }

    @Override
    public void visit(AllComparisonExpression allComparisonExpression) {
        this.buffer.append(" ALL ");
        allComparisonExpression.GetSubSelect().accept(this);
    }

    @Override
    public void visit(AnyComparisonExpression anyComparisonExpression) {
        this.buffer.append(" ANY ");
        anyComparisonExpression.GetSubSelect().accept(this);
    }

    @Override
    public void visit(Concat concat) {
        this.visitBinaryExpression(concat, " || ");
    }

    @Override
    public void visit(Matches matches) {
        this.visitBinaryExpression(matches, " @@ ");
    }

    @Override
    public void visit(BitwiseAnd bitwiseAnd) {
        this.visitBinaryExpression(bitwiseAnd, " & ");
    }

    @Override
    public void visit(BitwiseOr bitwiseOr) {
        this.visitBinaryExpression(bitwiseOr, " | ");
    }

    @Override
    public void visit(BitwiseXor bitwiseXor) {
        this.visitBinaryExpression(bitwiseXor, " ^ ");
    }

    @Override
    public void visit(Modulo modulo) {
        this.visitBinaryExpression(modulo, " % ");
    }

    @Override
    public void visit(OracleHierarchicalExpression oexpr) {
        if (oexpr.isConnectFirst()) {
            this.buffer.append(" CONNECT BY ");
            if (oexpr.isNoCycle()) {
                this.buffer.append("NOCYCLE ");
            }
            if (oexpr.isPrior()) {
                this.buffer.append("PRIOR ");
            }
            Expression connectExpression = oexpr.getConnectExpression();
            connectExpression.accept(this);
            Expression startExpression = oexpr.getStartExpression();
            if (startExpression != null) {
                this.buffer.append(" START WITH ");
                startExpression.accept(this);
            }
        } else {
            Expression startExpression = oexpr.getStartExpression();
            if (startExpression != null) {
                this.buffer.append(" START WITH ");
                startExpression.accept(this);
            }
            this.buffer.append(" CONNECT BY ");
            if (oexpr.isNoCycle()) {
                this.buffer.append("NOCYCLE ");
            }
            if (oexpr.isPrior()) {
                this.buffer.append("PRIOR ");
            }
            Expression connectExpression = oexpr.getConnectExpression();
            connectExpression.accept(this);
        }
    }

    @Override
    public void visit(AnalyticExpression analyticExpression) {
        this.buffer.append(analyticExpression.toString());
    }

    @Override
    public void visit(WithinGroupExpression withinGroupExpression) {
        this.buffer.append(withinGroupExpression.toString());
    }

    @Override
    public void visit(CastExpression castExpression) {
        this.buffer.append(castExpression.toString());
    }

    @Override
    public void visit(OracleHint hint) {
        this.buffer.append(hint.toString());
    }
}

