/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.statement.select;

import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.common.struct.RefObject;
import com.bokesoft.yes.common.util.StringUtil;
import java.util.Iterator;
import java.util.List;
import net.boke.jsqlparser.base.AbstractSqlElement;
import net.boke.jsqlparser.base.IElementVisitor;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.Statement;
import net.boke.jsqlparser.statement.StatementVisitor;
import net.boke.jsqlparser.statement.select.FromItem;
import net.boke.jsqlparser.statement.select.SelectBody;
import net.boke.jsqlparser.statement.select.WithItem;

public class Select
extends AbstractSqlElement
implements Statement {
    private SelectBody selectBody;
    private List withItemsList;
    private HashMapIgnoreCase<FromItem> tableAliasToName;
    private boolean mExtendIsAssignColumn = false;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public SelectBody getSelectBody() {
        return this.selectBody;
    }

    public void setSelectBody(SelectBody body) {
        this.selectBody = body;
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        if (this.withItemsList != null && !this.withItemsList.isEmpty()) {
            retval.append("WITH ");
            Iterator iter = this.withItemsList.iterator();
            while (iter.hasNext()) {
                WithItem withItem = (WithItem)iter.next();
                retval.append(withItem);
                if (iter.hasNext()) {
                    retval.append(",");
                }
                retval.append(" ");
            }
        }
        retval.append(this.selectBody);
        return retval.toString();
    }

    public List getWithItemsList() {
        return this.withItemsList;
    }

    public void setWithItemsList(List withItemsList) {
        this.withItemsList = withItemsList;
    }

    public void setTableAliasToName(HashMapIgnoreCase<FromItem> tableAliasToName) {
        this.tableAliasToName = tableAliasToName;
    }

    public HashMapIgnoreCase<FromItem> getTableAliasToName() {
        return this.tableAliasToName;
    }

    public String getTableNameByAlias(String tableAlias) {
        RefObject refTableName = new RefObject(null);
        this.selectBody.traversal(elem -> {
            if (elem instanceof Table) {
                Table table = (Table)elem;
                String alias = table.getAlias();
                if (StringUtil.isBlankOrNull((String)alias) && tableAlias.equalsIgnoreCase(table.getName())) {
                    refTableName.setValue((Object)table.getName());
                    return false;
                }
                if (tableAlias.equalsIgnoreCase(alias)) {
                    refTableName.setValue((Object)table.getName());
                    return false;
                }
            }
            return true;
        });
        return (String)refTableName.getValue();
    }

    @Override
    public void traversalChildren(IElementVisitor sqlElementVisitor) {
        this.selectBody.traversal(sqlElementVisitor);
    }

    public void setExtendAssignColumn() {
        this.mExtendIsAssignColumn = true;
    }

    public void clearExtendAssignColumn() {
        this.mExtendIsAssignColumn = false;
    }

    public boolean isExtendAssignColumn() {
        return this.mExtendIsAssignColumn;
    }
}

