/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.statement.replace;

import java.util.List;
import net.boke.jsqlparser.expression.operators.relational.ItemsList;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.Statement;
import net.boke.jsqlparser.statement.StatementVisitor;
import net.boke.jsqlparser.statement.select.PlainSelect;

public class Replace
implements Statement {
    private Table table;
    private List columns;
    private ItemsList itemsList;
    private List expressions;
    private boolean useValues = true;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table name) {
        this.table = name;
    }

    public List getColumns() {
        return this.columns;
    }

    public ItemsList getItemsList() {
        return this.itemsList;
    }

    public void setColumns(List list) {
        this.columns = list;
    }

    public void setItemsList(ItemsList list) {
        this.itemsList = list;
    }

    public List getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List list) {
        this.expressions = list;
    }

    public boolean isUseValues() {
        return this.useValues;
    }

    public void setUseValues(boolean useValues) {
        this.useValues = useValues;
    }

    public String toString() {
        String sql = "REPLACE " + this.table;
        if (this.expressions != null && this.columns != null) {
            sql = String.valueOf(sql) + " SET ";
            int i = 0;
            int s = this.columns.size();
            while (i < s) {
                sql = String.valueOf(sql) + this.columns.get(i) + "=" + this.expressions.get(i);
                sql = String.valueOf(sql) + (i < s - 1 ? ", " : "");
                ++i;
            }
        } else if (this.columns != null) {
            sql = String.valueOf(sql) + " " + PlainSelect.getStringList(this.columns, true, true);
        }
        if (this.itemsList != null) {
            if (this.useValues) {
                sql = String.valueOf(sql) + " VALUES";
            }
            sql = String.valueOf(sql) + " " + this.itemsList;
        }
        return sql;
    }
}

