/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.statement.insert;

import java.util.List;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.operators.relational.ItemsList;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.Statement;
import net.boke.jsqlparser.statement.StatementVisitor;
import net.boke.jsqlparser.statement.select.PlainSelect;

public class Insert
implements Statement {
    private Table table;
    private List columns;
    private ItemsList itemsList;
    private boolean useValues = true;
    private List updateColumns;
    private List updateExpList;
    private boolean useOnDuplicateKeyUpdate = false;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table name) {
        this.table = name;
    }

    public List getColumns() {
        return this.columns;
    }

    public void setColumns(List list) {
        this.columns = list;
    }

    public ItemsList getItemsList() {
        return this.itemsList;
    }

    public void setItemsList(ItemsList list) {
        this.itemsList = list;
    }

    public boolean isUseValues() {
        return this.useValues;
    }

    public void setUseValues(boolean useValues) {
        this.useValues = useValues;
    }

    public List getUpdateColumns() {
        return this.updateColumns;
    }

    public void setUpdateColumns(List updateColumns) {
        this.updateColumns = updateColumns;
    }

    public List getUpdateExpList() {
        return this.updateExpList;
    }

    public void setUpdateExpList(List updateExpList) {
        this.updateExpList = updateExpList;
    }

    public boolean isUseOnDuplicateKeyUpdate() {
        return this.useOnDuplicateKeyUpdate;
    }

    public void setUseOnDuplicateKeyUpdate(boolean useOnDuplicateKeyUpdate) {
        this.useOnDuplicateKeyUpdate = useOnDuplicateKeyUpdate;
    }

    public String toString() {
        String sql = "";
        sql = "INSERT INTO ";
        sql = String.valueOf(sql) + this.table + " ";
        sql = String.valueOf(sql) + (this.columns != null ? String.valueOf(PlainSelect.getStringList(this.columns, true, true)) + " " : "");
        sql = this.useValues ? String.valueOf(sql) + "VALUES " + this.itemsList : String.valueOf(sql) + this.itemsList;
        if (this.useOnDuplicateKeyUpdate) {
            sql = String.valueOf(sql) + " on duplicate key update ";
            int i = 0;
            while (i < this.getUpdateColumns().size()) {
                Column column = (Column)this.getUpdateColumns().get(i);
                sql = String.valueOf(sql) + column.getWholeColumnName() + "=";
                Expression expression = (Expression)this.getUpdateExpList().get(i);
                sql = String.valueOf(sql) + expression.toString();
                if (i < this.getUpdateColumns().size() - 1) {
                    sql = String.valueOf(sql) + ", ";
                }
                ++i;
            }
        }
        return sql;
    }
}

