/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.schema;

import net.boke.jsqlparser.base.AbstractSqlElement;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.ExpressionVisitor;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.select.FromItem;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;
import net.boke.jsqlparser.statement.select.SubSelect;

public class Column
extends AbstractSqlElement
implements Expression {
    private String columnName = null;
    private Table table;
    private char keyWordEscapeStart = '\u0000';
    private char keyWordEscapeEnd = '\u0000';
    private int indexInCache = -1;
    private FromItem mExtendFromItem;
    private String mExtendTableColumn;
    private SelectExpressionItem mExtendSubSelectSelectItem;
    private SelectExpressionItem mExtendSelectItemInGroupByOrderByHaving;

    public Column() {
    }

    public Column(Table table, String columnName) {
        this.table = table;
        this.setNameWithKeyWordEscape(columnName);
    }

    private void setNameWithKeyWordEscape(String name) {
        char end;
        char first;
        int length;
        int n = length = name == null ? 0 : name.length();
        if (!(length <= 2 || (first = name.charAt(0)) != '`' && first != '[' && first != '\"' || (end = name.charAt(length - 1)) != '`' && end != ']' && end != '\"')) {
            this.keyWordEscapeStart = first;
            this.keyWordEscapeEnd = end;
            name = name.substring(1, length - 1);
        }
        this.columnName = name.intern();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Table getTable() {
        return this.table;
    }

    public void setColumnName(String string) {
        this.setNameWithKeyWordEscape(string);
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public char getKeyWordEscapeStart() {
        return this.keyWordEscapeStart;
    }

    public void setKeyWordEscapeStart(char keyWordEscapeStart) {
        this.keyWordEscapeStart = keyWordEscapeStart;
    }

    public char getKeyWordEscapeEnd() {
        return this.keyWordEscapeEnd;
    }

    public void setKeyWordEscapeEnd(char keyWordEscapeEnd) {
        this.keyWordEscapeEnd = keyWordEscapeEnd;
    }

    public String getWholeColumnName() {
        if (this.table == null) {
            return this.columnName;
        }
        String columnWholeName = null;
        String tableWholeName = this.table.getAliasName();
        if (tableWholeName != null && tableWholeName.length() != 0 || this.keyWordEscapeStart > '\u0000') {
            StringBuilder sb = new StringBuilder(50);
            if (tableWholeName != null && tableWholeName.length() != 0) {
                sb.append(tableWholeName).append(".");
            }
            if (this.keyWordEscapeStart != '\u0000') {
                sb.append(this.keyWordEscapeStart);
            }
            sb.append(this.columnName);
            if (this.keyWordEscapeEnd != '\u0000') {
                sb.append(this.keyWordEscapeEnd);
            }
            columnWholeName = sb.toString();
        } else {
            columnWholeName = this.columnName;
        }
        return columnWholeName;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return this.toString().equalsIgnoreCase(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.getWholeColumnName();
    }

    public int getIndexInCache() {
        return this.indexInCache;
    }

    public void setIndexInCache(int indexInCache) {
        this.indexInCache = indexInCache;
    }

    public Column setExtendTable(Table table, String tableColumn) {
        assert (this.mExtendSelectItemInGroupByOrderByHaving == null);
        assert (this.mExtendFromItem == null || this.mExtendFromItem == table && this.mExtendTableColumn.equals(tableColumn));
        this.mExtendFromItem = table;
        this.mExtendTableColumn = tableColumn;
        this.mExtendSubSelectSelectItem = null;
        return this;
    }

    public Column setExtendSubSelect(SubSelect subSelect, SelectExpressionItem selectItem) {
        assert (this.mExtendSelectItemInGroupByOrderByHaving == null);
        assert (this.mExtendFromItem == null || this.mExtendFromItem == subSelect && this.mExtendSubSelectSelectItem == selectItem);
        this.mExtendFromItem = subSelect;
        this.mExtendTableColumn = null;
        this.mExtendSubSelectSelectItem = selectItem;
        return this;
    }

    public FromItem getExtendFromItem() {
        return this.mExtendFromItem;
    }

    public String getExtendTableColumn() {
        return this.mExtendTableColumn;
    }

    public SelectExpressionItem getExtendSelectItem() {
        return this.mExtendSubSelectSelectItem;
    }

    public Column setExtendSelectItemInGroupByOrderByHaving(SelectExpressionItem selectItem) {
        assert (this.mExtendSelectItemInGroupByOrderByHaving == null);
        if (this.mExtendFromItem == null) {
            assert (this.mExtendTableColumn == null && this.mExtendSubSelectSelectItem == null);
        } else if (selectItem.getExpression() instanceof Column) {
            this.mExtendFromItem = null;
            this.mExtendTableColumn = null;
            this.mExtendSubSelectSelectItem = null;
        }
        this.mExtendSelectItemInGroupByOrderByHaving = selectItem;
        return this;
    }

    public SelectExpressionItem getExtendSelectItemInGroupByOrderByHaving() {
        return this.mExtendSelectItemInGroupByOrderByHaving;
    }

    public Column clearAssignFromItem() {
        this.mExtendFromItem = null;
        this.mExtendTableColumn = null;
        this.mExtendSubSelectSelectItem = null;
        this.mExtendSelectItemInGroupByOrderByHaving = null;
        return this;
    }

    public Column setExtendSameFromItem(Column column) {
        assert (this.mExtendSelectItemInGroupByOrderByHaving == null);
        assert (this.mExtendFromItem == null && this.mExtendTableColumn == null && this.mExtendSubSelectSelectItem == null);
        this.mExtendFromItem = column.mExtendFromItem;
        this.mExtendTableColumn = column.mExtendTableColumn;
        this.mExtendSubSelectSelectItem = column.mExtendSubSelectSelectItem;
        return this;
    }

    public boolean isSameColumn(Column column) {
        return column != null && this.mExtendFromItem == column.mExtendFromItem && this.mExtendTableColumn == column.mExtendTableColumn && this.mExtendSubSelectSelectItem == column.mExtendSubSelectSelectItem && this.mExtendSelectItemInGroupByOrderByHaving == column.mExtendSelectItemInGroupByOrderByHaving;
    }

    public FromItem getFormItemAsTable() {
        if (this.mExtendFromItem != null) {
            return this.mExtendFromItem;
        }
        if (this.mExtendSelectItemInGroupByOrderByHaving != null && this.mExtendSelectItemInGroupByOrderByHaving.getExpression() instanceof Column) {
            return ((Column)this.mExtendSelectItemInGroupByOrderByHaving.getExpression()).getExtendFromItem();
        }
        return null;
    }

    public Column getUnderlyingTableColumn() {
        if (this.mExtendSubSelectSelectItem != null) {
            if (this.mExtendSubSelectSelectItem.getExpression() instanceof Column) {
                return ((Column)this.mExtendSubSelectSelectItem.getExpression()).getUnderlyingTableColumn();
            }
            return null;
        }
        return this;
    }
}

