/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.query.source.part;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.mysqls.sql.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.boke.jsqlparser.base.AbstractSqlElement;
import net.boke.jsqlparser.query.source.AbstractQuerySource;
import net.boke.jsqlparser.query.source.part.AbstractQuerySourcePart;
import net.boke.jsqlparser.query.util.SourceHelperUtil;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.statement.select.AllColumns;
import net.boke.jsqlparser.statement.select.AllTableColumns;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;

public class QueryItems
extends AbstractQuerySourcePart<List> {
    public static final String QUERY_ITEM_ALL = "*";
    public static final String QUERY_ITEM_TABLE_ALL = ".*";

    public QueryItems(List selectItems, AbstractQuerySource<?> source) {
        super(selectItems, source);
    }

    public List<Column> getLinkedColumns() {
        if (this.getContent() == null) {
            return Collections.emptyList();
        }
        return SourceHelperUtil.getLinkedColumns((List)this.getContent());
    }

    public AbstractSqlElement getItemByColumnName(String columnName) throws SQLException {
        return this.getItemByColumnName(columnName, null);
    }

    public AbstractSqlElement getItemByColumnName(String columnName, String tableAlias) {
        if (this.getContent() == null) {
            return null;
        }
        AbstractSqlElement elem = null;
        for (Object item : (List)this.getContent()) {
            if (item instanceof AllColumns) {
                if (!StringUtil.isBlankOrNull((String)tableAlias) && this.getSource().getSourceByTableAlias(tableAlias) == null) {
                    return null;
                }
                elem = this.getSource().getResultItemInSubSources(columnName);
            } else if (item instanceof AllTableColumns) {
                AbstractQuerySource<?> tmpSource;
                String name = ((AllTableColumns)item).getTable().getAliasName();
                if ((StringUtil.isBlankOrNull((String)tableAlias) || tableAlias.equalsIgnoreCase(name)) && (elem = (tmpSource = this.getSource().getSourceByTableAlias(name)).getResultItem(columnName, null)) != null) {
                    return (AllTableColumns)item;
                }
            } else {
                SelectExpressionItem selectItem = (SelectExpressionItem)item;
                if (!StringUtil.isBlankOrNull((String)tableAlias) && selectItem.getExpression() instanceof Column) {
                    String colTableAlias;
                    Column column = (Column)selectItem.getExpression();
                    String string = colTableAlias = column.getTable() == null ? "" : column.getTable().getAliasName();
                    if ((StringUtil.isBlankOrNull((String)colTableAlias) || tableAlias.equalsIgnoreCase(colTableAlias)) && columnName.equalsIgnoreCase(column.getColumnName())) {
                        return selectItem;
                    }
                } else if (StringUtil.isBlankOrNull((String)tableAlias) && SourceHelperUtil.matchSelectItemByColumnName(columnName, selectItem)) {
                    Column linkedColumn;
                    List<Column> linkedColumns = SourceHelperUtil.getLinkedColumns(selectItem);
                    if (linkedColumns.size() == 1 && (linkedColumn = linkedColumns.get(0)) != null && linkedColumn.getTable() == null) {
                        for (Object tmpItem : (List)this.getContent()) {
                            if (!(tmpItem instanceof SelectExpressionItem)) continue;
                            SelectExpressionItem selectItem2 = (SelectExpressionItem)tmpItem;
                            if (!linkedColumn.getColumnName().equalsIgnoreCase(selectItem2.getAlias())) continue;
                            return selectItem2;
                        }
                    }
                    return selectItem;
                }
            }
            if (elem != null) break;
        }
        return elem;
    }

    public boolean containResultColumn(String columnName) {
        boolean result = false;
        if (this.getContent() == null) {
            return false;
        }
        for (Object item : (List)this.getContent()) {
            if (item instanceof AllColumns) {
                result = this.getSource().isResultItemInSubSources(columnName);
            } else if (item instanceof AllTableColumns) {
                String name = ((AllTableColumns)item).getTable().getAliasName();
                AbstractQuerySource<?> tmpSource = this.getSource().getSourceByTableAlias(name);
                result = tmpSource.isResultColumn(columnName);
            } else {
                SelectExpressionItem selectItem = (SelectExpressionItem)item;
                if (SourceHelperUtil.matchSelectItemByColumnName(columnName, selectItem)) {
                    return true;
                }
            }
            if (result) break;
        }
        return result;
    }

    public List<Field> getResultFields() throws Throwable {
        ArrayList<Field> list = new ArrayList<Field>();
        for (Object item : (List)this.getContent()) {
            if (item instanceof AllColumns) {
                List<Field> allFields = this.getSource().getAllFields();
                list.addAll(allFields);
                continue;
            }
            if (item instanceof AllTableColumns) {
                String name = ((AllTableColumns)item).getTable().getAliasName();
                AbstractQuerySource<?> tmpSource = this.getSource().getSourceByTableAlias(name);
                list.addAll(tmpSource.getResultFields());
                continue;
            }
            Field field = this.getSource().parseSelectItem2Field((SelectExpressionItem)item);
            list.add(field);
        }
        return list;
    }

    public boolean isAllColumns() {
        return ((List)this.getContent()).size() == 1 && ((List)this.getContent()).get(0) instanceof AllColumns;
    }
}

