/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.schema;

import com.bokesoft.yes.i18n.StringTable;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yes.mid.schema.ISchemaProvider;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.total.BPMDataObjectCreater;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationList;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationProfile;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.MetaDict;
import com.bokesoft.yigo.meta.form.component.control.MetaDynamicDict;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class ArchiveSchemaProvider
implements ISchemaProvider {
    private final String dataObjectKey;
    private DefaultContext context = null;
    private final List<String> additionTableKeys;

    public ArchiveSchemaProvider(DefaultContext context, String dataObjectKey, List<String> additionTableKeys) {
        this.context = context;
        this.dataObjectKey = dataObjectKey;
        this.additionTableKeys = additionTableKeys;
    }

    public List<MetaSchemaTable> getAllTable() throws Throwable {
        LinkedList<MetaSchemaTable> tableList = new LinkedList<MetaSchemaTable>();
        IMetaFactory metaFactory = this.context.getVE().getMetaFactory();
        MetaDataObject dataObject = metaFactory.getDataObject(this.dataObjectKey);
        if (dataObject == null) {
            throw new MetaException(25, SimpleStringFormat.format((String)StringTable.getString(null, (String)"", (String)"NoDataObjectDefined"), (Object[])new Object[0]));
        }
        tableList.addAll(dataObject.getSchemeTableList());
        List<MetaDataObject> keysMigrationDataObjects = this.getAllKeysMigrationDataObject();
        if (!CollectionUtils.isEmpty(keysMigrationDataObjects)) {
            for (MetaDataObject migrationDataObject : keysMigrationDataObjects) {
                tableList.addAll(migrationDataObject.getSchemeTableList());
                if (!migrationDataObject.getKey().equals("VoucherBalance")) continue;
                tableList.addAll(metaFactory.getDataObject("FI_AnalysisRepository").getSchemeTableList());
            }
        }
        MetaDataObject bpmDataObject = BPMDataObjectCreater.getBPMDataObject((IMetaFactory)metaFactory);
        if (dataObject.getMainTable().containsKey("InstanceID")) {
            tableList.addAll(bpmDataObject.getSchemeTableList());
        }
        MetaDataObject workitemDataObject = BPMDataObjectCreater.getWorkitemDataObject();
        tableList.addAll(workitemDataObject.getSchemeTableList());
        ArrayList<MetaForm> metaFormList = new ArrayList<MetaForm>();
        MetaFormList metaFormlist = metaFactory.getMetaFormList();
        int index = 0;
        while (index < metaFormlist.size()) {
            String metaFormKey = ((MetaFormProfile)metaFormlist.get(index)).getKey();
            MetaForm metaForm = metaFactory.getMetaForm(metaFormKey);
            MetaDataSource metaDataSource = metaForm.getDataSource();
            if (metaDataSource != null && metaDataSource.getDataObject().getKey().equalsIgnoreCase(this.dataObjectKey)) {
                metaFormList.add(metaForm);
            }
            ++index;
        }
        for (MetaForm metaForm : metaFormList) {
            List allComponents = metaForm.getAllComponents();
            for (MetaComponent component : allComponents) {
                if (component instanceof MetaDynamicDict || !(component instanceof MetaDict)) continue;
                MetaDict metaDict = (MetaDict)component;
                String itemKey = metaDict.getItemKey();
                MetaDataObject dict = metaFactory.getDataObject(itemKey);
                if (dict == null) {
                    throw new MetaException(25, SimpleStringFormat.format((String)StringTable.getString(null, (String)"", (String)"NoDataObjectDefined"), (Object[])new Object[0]));
                }
                tableList.addAll(dict.getSchemeTableList());
            }
            List allGridCells = metaForm.getAllGridCells();
            for (MetaGridCell gridCell : allGridCells) {
                if (gridCell.getCellType() == 241 || gridCell.getCellType() != 206) continue;
                MetaDictProperties metaDictProperties = (MetaDictProperties)gridCell.getProperties();
                String itemKey = metaDictProperties.getItemKey();
                MetaDataObject dict = metaFactory.getDataObject(itemKey);
                if (dataObject == null) {
                    throw new MetaException(25, SimpleStringFormat.format((String)StringTable.getString(null, (String)"", (String)"NoDataObjectDefined"), (Object[])new Object[0]));
                }
                tableList.addAll(dict.getSchemeTableList());
            }
        }
        SqlString sqlString = new SqlString().append("SELECT SOID FROM EDA_ArchiveObject WHERE DataObjectKey =").appendPara(this.dataObjectKey);
        DataTable table = this.context.getDBManager().execPrepareQuery(sqlString.getSql(), sqlString.getParameterList());
        if (table.size() > 0) {
            Long archiveObjectID = table.getLong(0);
            SqlString tableListSqL = new SqlString().append("SELECT DataObjectKey, TableKey , RelationFieldKey FROM EDA_ArchiveObjectTableDtl WHERE OrignalType = ").appendPara(2).append(" and SOID = ").appendPara(archiveObjectID);
            DataTable relationTableList = this.context.getDBManager().execPrepareQuery(tableListSqL.getSql(), tableListSqL.getParameterList());
            int i = 0;
            while (i < relationTableList.size()) {
                String dataObjectKey = relationTableList.getString(i, "DataObjectKey");
                String tableKey = relationTableList.getString(i, "TableKey");
                MetaDataObject metaDataObject = MetaFactory.getGlobalInstance().getDataObject(dataObjectKey);
                Map schemaTableMap = metaDataObject.getSchemaTableMap(false);
                MetaSchemaTable metaSchemaTable = (MetaSchemaTable)schemaTableMap.get(tableKey);
                tableList.add(metaSchemaTable);
                ++i;
            }
        }
        return tableList;
    }

    public List<MetaDataObject> getAllKeysMigrationDataObject() throws Throwable {
        LinkedList<MetaDataObject> tableList = new LinkedList<MetaDataObject>();
        IMetaFactory metaFactory = this.context.getVE().getMetaFactory();
        MetaDataMigrationList metaDataMigrationList = metaFactory.getDataMigrationList();
        for (MetaDataMigrationProfile profile : metaDataMigrationList) {
            MetaDataMigration metaDataMigration = metaFactory.getDataMigration(profile.getKey());
            String srcDataObjectKey = metaDataMigration.getSrcDataObjectKey();
            String tgtDataObjectKey = metaDataMigration.getTgtDataObjectKey();
            if (!srcDataObjectKey.equals(this.dataObjectKey)) continue;
            MetaDataObject tgtDataObject = metaFactory.getDataObject(tgtDataObjectKey);
            if (tgtDataObject == null) {
                throw new MetaException(25, SimpleStringFormat.format((String)StringTable.getString(null, (String)"", (String)"NoDataObjectDefined"), (Object[])new Object[0]));
            }
            tableList.add(tgtDataObject.getKeysMigrationDataObject());
            tableList.removeAll(Collections.singleton(null));
        }
        return tableList;
    }

    public List<String> getKeysMigrationMainTableNameList() throws Throwable {
        LinkedList<String> tableList = new LinkedList<String>();
        IMetaFactory metaFactory = this.context.getVE().getMetaFactory();
        MetaDataMigrationList metaDataMigrationList = metaFactory.getDataMigrationList();
        for (MetaDataMigrationProfile profile : metaDataMigrationList) {
            MetaDataMigration metaDataMigration = metaFactory.getDataMigration(profile.getKey());
            String srcDataObjectKey = metaDataMigration.getSrcDataObjectKey();
            String tgtDataObjectKey = metaDataMigration.getTgtDataObjectKey();
            if (!srcDataObjectKey.equals(this.dataObjectKey)) continue;
            MetaDataObject tgtDataObject = metaFactory.getDataObject(tgtDataObjectKey);
            if (tgtDataObject == null) {
                throw new MetaException(25, SimpleStringFormat.format((String)StringTable.getString(null, (String)"", (String)"NoDataObjectDefined"), (Object[])new Object[0]));
            }
            tableList.add(tgtDataObject.getKeysMigrationMainTableName());
            tableList.removeAll(Collections.singleton(null));
        }
        return tableList;
    }
}

