/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.resultset;

import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.mysqls.sql.FindJdbcParameter;
import com.bokesoft.yes.mid.mysqls.sql.SelectSqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfos;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.sql.SQLException;
import java.util.List;
import net.boke.jsqlparser.expression.JdbcParameter;
import net.boke.jsqlparser.statement.select.Limit;

public class LimitProcess {
    public static void process(String sql, DataTable dt, QueryArguments arguments) throws SQLException {
        int index;
        if (dt.size() <= 0) {
            return;
        }
        SelectSqlInfo sqlInfo = (SelectSqlInfo)SqlInfos.instance.getSqlInfo(sql);
        Limit limit = sqlInfo.getLimit();
        if (limit == null) {
            return;
        }
        long rowCount = limit.getRowCount();
        long offset = limit.getOffset();
        List<JdbcParameter> jdbcParameter = FindJdbcParameter.getAllJdbcParameters(sqlInfo.getStatement());
        if (limit.isRowCountJdbcParameter()) {
            index = jdbcParameter.indexOf(limit.getRowCountJdbcParameterValue());
            rowCount = TypeConvertor.toLong((Object)arguments.get(index));
        }
        if (limit.isOffsetJdbcParameter()) {
            index = jdbcParameter.indexOf(limit.getOffsetJdbcParameterValue());
            offset = TypeConvertor.toLong((Object)arguments.get(index));
        }
        if ((long)dt.size() <= rowCount - offset) {
            return;
        }
        int i = (int)offset - 1;
        while (i >= 0 && dt.size() > i) {
            dt.delete(i);
            --i;
        }
        i = dt.size() - 1;
        while (i >= 0 && (long)dt.size() > rowCount) {
            dt.delete(i);
            --i;
        }
    }
}

