/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.resultset;

import com.bokesoft.erp.mid.util.NotImplemented;
import com.bokesoft.yes.mid.mysqls.resultset.SimpleDocumentDBUtil;
import com.bokesoft.yes.mid.mysqls.sql.SelectSqlInfo;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class EmptyResultSetMetaData
implements ResultSetMetaData {
    private final SelectSqlInfo select;
    private final DataTable dataTable;
    public static final int INT_UnknownScale = -1;

    public EmptyResultSetMetaData(SelectSqlInfo select) {
        this.dataTable = null;
        this.select = select;
    }

    public EmptyResultSetMetaData(DataTable dataTable) {
        this.select = null;
        this.dataTable = dataTable;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public int getColumnCount() throws SQLException {
        try {
            if (this.select != null) {
                return this.select.getColumnCount();
            }
            return this.dataTable.getMetaData().getColumnCount();
        }
        catch (Throwable e) {
            throw new RuntimeException("\u89e3\u6790SQL\u51fa\u9519\uff0c" + this.select, e);
        }
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        if (this.dataTable != null) {
            return this.dataTable.getMetaData().getColumnInfo(column - 1).getLength();
        }
        return 255;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        try {
            if (this.select != null) {
                return this.select.getColumnNameInResultSet(column - 1);
            }
            return this.dataTable.getMetaData().getColumnInfo(column - 1).getColumnKey();
        }
        catch (Throwable e) {
            throw new RuntimeException("\u89e3\u6790SQL\u51fa\u9519\uff0c" + this.select, e);
        }
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumnLabel(column);
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        int dataType;
        try {
            dataType = this.select != null ? this.select.getColumnDataType(column - 1) : this.dataTable.getMetaData().getColumnInfo(column - 1).getDataType();
        }
        catch (Throwable e) {
            throw new RuntimeException("\u89e3\u6790SQL\u51fa\u9519\uff0c" + this.select, e);
        }
        int jdbcDataType = SimpleDocumentDBUtil.convertJDBCDataType(dataType);
        if (dataType == 1004) {
            jdbcDataType = 93;
        }
        return jdbcDataType;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        ColumnInfo columnInfo = this.dataTable.getMetaData().getColumnInfo(column - 1);
        int dataType = columnInfo.getDataType();
        int result = 0;
        switch (dataType) {
            case 1010: {
                result = 18;
                break;
            }
            case 1001: {
                result = 9;
            }
        }
        return result;
    }

    @Override
    public int getScale(int column) throws SQLException {
        if (this.dataTable == null) {
            return -1;
        }
        ColumnInfo columnInfo = this.dataTable.getMetaData().getColumnInfo(column - 1);
        return columnInfo.getScale();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public int isNullable(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new NotImplemented();
    }
}

