/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.result.util;

import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yes.mid.mysqls.processselect.ParsedSqlUtil;
import com.bokesoft.yes.parser.ParserException;
import com.bokesoft.yes.parser.i18n.StringTable;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.boke.jsqlparser.expression.BinaryExpression;
import net.boke.jsqlparser.expression.CaseExpression;
import net.boke.jsqlparser.expression.DateValue;
import net.boke.jsqlparser.expression.DoubleValue;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.Function;
import net.boke.jsqlparser.expression.InverseExpression;
import net.boke.jsqlparser.expression.LongValue;
import net.boke.jsqlparser.expression.Parenthesis;
import net.boke.jsqlparser.expression.StringValue;
import net.boke.jsqlparser.expression.WhenClause;
import net.boke.jsqlparser.expression.operators.arithmetic.Addition;
import net.boke.jsqlparser.expression.operators.arithmetic.Division;
import net.boke.jsqlparser.expression.operators.arithmetic.Modulo;
import net.boke.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.boke.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.boke.jsqlparser.expression.operators.relational.EqualsTo;
import net.boke.jsqlparser.expression.operators.relational.GreaterThan;
import net.boke.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.boke.jsqlparser.expression.operators.relational.MinorThan;
import net.boke.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.boke.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;
import net.boke.jsqlparser.statement.select.SubSelect;

public class TypeUtils {
    public static boolean isNumeric(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof BigDecimal || obj instanceof Integer || obj instanceof Double || obj instanceof Long;
    }

    public static final int getCompatibleType(Object value1, Object value2) throws ParserException {
        int dataType = -1;
        if (value1 == null) {
            Object tmp = value2;
            value2 = value1;
            value1 = tmp;
        }
        if (value1 == null) {
            dataType = 1;
        } else if (value1 instanceof Integer) {
            if (value2 == null) {
                dataType = 1;
            } else if (value2 instanceof Integer) {
                dataType = 1;
            } else if (value2 instanceof Long) {
                dataType = 1;
            } else if (value2 instanceof String) {
                dataType = 2;
            } else if (value2 instanceof BigDecimal) {
                dataType = 4;
            } else if (value2 instanceof Boolean) {
                dataType = 6;
            } else if (value2 instanceof Date) {
                throw new ParserException(3, StringTable.getString(null, (String)"", (String)"IncompatibleType"));
            }
        } else if (value1 instanceof Long) {
            if (value2 == null) {
                dataType = 1;
            } else if (value2 instanceof Integer) {
                dataType = 1;
            } else if (value2 instanceof Long) {
                dataType = 1;
            } else if (value2 instanceof String) {
                dataType = 2;
            } else if (value2 instanceof BigDecimal) {
                dataType = 4;
            } else if (value2 instanceof Boolean) {
                dataType = 6;
            } else if (value2 instanceof Date) {
                throw new ParserException(3, "Incompatible type");
            }
        } else if (value1 instanceof String) {
            if (value2 == null) {
                dataType = 2;
            } else if (value2 instanceof Integer) {
                dataType = 2;
            } else if (value2 instanceof Long) {
                dataType = 2;
            } else if (value2 instanceof String) {
                dataType = 2;
            } else if (value2 instanceof BigDecimal) {
                dataType = 2;
            } else if (value2 instanceof Boolean) {
                dataType = 2;
            } else if (value2 instanceof Date) {
                dataType = 2;
            }
        } else if (value1 instanceof BigDecimal || value1 instanceof Double) {
            if (value2 == null) {
                dataType = 4;
            } else if (value2 instanceof Integer) {
                dataType = 4;
            } else if (value2 instanceof Long) {
                dataType = 4;
            } else if (value2 instanceof String) {
                dataType = 2;
            } else if (value2 instanceof BigDecimal) {
                dataType = 4;
            } else if (value2 instanceof Boolean) {
                dataType = 4;
            } else if (value2 instanceof Double) {
                dataType = 4;
            } else if (value2 instanceof Date) {
                throw new ParserException(3, "Incompatible type");
            }
        } else if (value1 instanceof Boolean) {
            if (value2 == null) {
                dataType = 1;
            } else if (value2 instanceof Integer) {
                dataType = 1;
            } else if (value2 instanceof Long) {
                dataType = 1;
            } else if (value2 instanceof String) {
                dataType = 2;
            } else if (value2 instanceof BigDecimal) {
                dataType = 4;
            } else if (value2 instanceof Boolean) {
                dataType = 6;
            } else if (value2 instanceof Date) {
                throw new ParserException(3, "Incompatible type");
            }
        } else if (value1 instanceof Date) {
            if (value2 == null) {
                dataType = 3;
            } else {
                if (value2 instanceof Integer) {
                    throw new ParserException(3, "Incompatible type");
                }
                if (value2 instanceof Long) {
                    throw new ParserException(3, "Incompatible type");
                }
                if (value2 instanceof String) {
                    dataType = 2;
                } else {
                    if (value2 instanceof BigDecimal) {
                        throw new ParserException(3, "Incompatible type");
                    }
                    if (value2 instanceof Boolean) {
                        throw new ParserException(3, "Incompatible type");
                    }
                    if (value2 instanceof Date) {
                        throw new ParserException(3, "Incompatible type");
                    }
                }
            }
        }
        return dataType;
    }

    public static final int getCompatibleType4Logic(Object value1, Object value2) throws ParserException {
        int dataType = -1;
        if (value1 == null) {
            Object tmp = value2;
            value2 = value1;
            value1 = tmp;
        }
        if (value1 instanceof Integer) {
            if (value2 == null) {
                dataType = 1;
            } else if (value2 instanceof Integer) {
                dataType = 1;
            } else if (value2 instanceof Long) {
                dataType = 1;
            } else if (value2 instanceof String) {
                dataType = 2;
            } else if (value2 instanceof BigDecimal) {
                dataType = 4;
            } else if (value2 instanceof Boolean) {
                dataType = 6;
            } else if (value2 instanceof Date) {
                throw new ParserException(3, StringTable.getString(null, (String)"", (String)"IncompatibleType"));
            }
        } else if (value1 instanceof Long) {
            if (value2 == null) {
                dataType = 1;
            } else if (value2 instanceof Integer) {
                dataType = 1;
            } else if (value2 instanceof Long) {
                dataType = 1;
            } else if (value2 instanceof String) {
                dataType = 2;
            } else if (value2 instanceof BigDecimal) {
                dataType = 4;
            } else if (value2 instanceof Boolean) {
                dataType = 6;
            } else if (value2 instanceof Date) {
                throw new ParserException(3, "Incompatible type");
            }
        } else if (value1 instanceof String) {
            if (value2 == null) {
                dataType = 2;
            } else if (value2 instanceof Integer) {
                dataType = 2;
            } else if (value2 instanceof Long) {
                dataType = 2;
            } else if (value2 instanceof String) {
                dataType = 2;
            } else if (value2 instanceof BigDecimal) {
                dataType = 2;
            } else if (value2 instanceof Boolean) {
                dataType = 2;
            } else if (value2 instanceof Date) {
                dataType = 2;
            }
        } else if (value1 instanceof BigDecimal) {
            if (value2 == null) {
                dataType = 4;
            } else if (value2 instanceof Integer) {
                dataType = 4;
            } else if (value2 instanceof Long) {
                dataType = 4;
            } else if (value2 instanceof String) {
                dataType = 2;
            } else if (value2 instanceof BigDecimal) {
                dataType = 4;
            } else if (value2 instanceof Boolean) {
                dataType = 4;
            } else if (value2 instanceof Date) {
                throw new ParserException(3, "Incompatible type");
            }
        } else if (value1 instanceof Boolean) {
            if (value2 == null) {
                dataType = 1;
            } else if (value2 instanceof Integer) {
                dataType = 1;
            } else if (value2 instanceof Long) {
                dataType = 1;
            } else if (value2 instanceof String) {
                dataType = 2;
            } else if (value2 instanceof BigDecimal) {
                dataType = 4;
            } else if (value2 instanceof Boolean) {
                dataType = 6;
            } else if (value2 instanceof Date) {
                throw new ParserException(3, "Incompatible type");
            }
        } else if (value1 instanceof Date) {
            if (value2 == null) {
                dataType = 3;
            } else {
                if (value2 instanceof Integer) {
                    throw new ParserException(3, "Incompatible type");
                }
                if (value2 instanceof Long) {
                    throw new ParserException(3, "Incompatible type");
                }
                if (value2 instanceof String) {
                    throw new ParserException(3, "Incompatible type");
                }
                if (value2 instanceof BigDecimal) {
                    throw new ParserException(3, "Incompatible type");
                }
                if (value2 instanceof Boolean) {
                    throw new ParserException(3, "Incompatible type");
                }
                if (value2 instanceof Date) {
                    dataType = 3;
                }
            }
        }
        return dataType;
    }

    public static Expression getEmptyExpressionByType(int dataType) {
        switch (dataType) {
            case 1001: 
            case 1003: 
            case 1004: 
            case 1009: 
            case 1010: {
                return new LongValue("0");
            }
            case 1002: 
            case 1011: 
            case 1012: {
                return new StringValue("");
            }
            case 1005: 
            case 1006: 
            case 1007: {
                return new DoubleValue(BigDecimal.valueOf(0L, 10).toString());
            }
        }
        throw new RuntimeException("\u5206\u5e93,\u65e0\u6cd5\u8bc6\u522b\u7684\u6570\u636e\u7c7b\u578b:" + DataType.toString((Integer)dataType) + "\u3002");
    }

    public static int getColumnDataType(Column column) throws Throwable {
        int dataType;
        SelectExpressionItem selectItem = column.getExtendSelectItemInGroupByOrderByHaving();
        if (selectItem != null) {
            int dataType2 = TypeUtils.getCalcItemDataType(selectItem.getExpression());
            return dataType2;
        }
        if (column.getExtendSelectItem() != null) {
            dataType = TypeUtils.getCalcItemDataType(column.getExtendSelectItem().getExpression());
        } else {
            if (column.getExtendTableColumn() == null || !(column.getExtendFromItem() instanceof Table)) {
                return 0;
            }
            dataType = ((MetaColumn)DataObjects.getInstance().getColumnsByTableName(((Table)column.getExtendFromItem()).getName()).get(column.getExtendTableColumn())).getDataType();
        }
        return dataType;
    }

    public static int getCalcItemDataType(Expression exp) {
        if (exp == null) {
            return 0;
        }
        if (exp instanceof LongValue) {
            return 1010;
        }
        if (exp instanceof DoubleValue) {
            return 1005;
        }
        if (exp instanceof StringValue) {
            return 1002;
        }
        if (exp instanceof DateValue) {
            return 1003;
        }
        if (exp instanceof Column) {
            Column column = (Column)exp;
            try {
                return TypeUtils.getColumnDataType(column);
            }
            catch (Throwable e) {
                throw new RuntimeException("\u5206\u5e93\u51fa\u9519\uff0c\u8ba1\u7b97\u8868\u8fbe\u5f0f" + exp + "\u7684\u7c7b\u578b\u51fa\u9519\u3002", e);
            }
        }
        if (exp instanceof Parenthesis) {
            return TypeUtils.getCalcItemDataType(((Parenthesis)exp).getExpression());
        }
        if (exp instanceof Addition || exp instanceof Subtraction || exp instanceof Multiplication || exp instanceof Modulo) {
            int leftDataType = TypeUtils.getCalcItemDataType(((BinaryExpression)exp).getLeftExpression());
            int rightDataType = TypeUtils.getCalcItemDataType(((BinaryExpression)exp).getRightExpression());
            if (leftDataType == 1002 || rightDataType == 1002) {
                return 1002;
            }
            if (leftDataType == 1005 || rightDataType == 1005) {
                return 1005;
            }
            if (leftDataType == 1003 || rightDataType == 1003) {
                return 1003;
            }
            if (leftDataType != rightDataType) {
                return Math.max(leftDataType, rightDataType);
            }
            return leftDataType;
        }
        if (exp instanceof Division) {
            return 1005;
        }
        if (exp instanceof EqualsTo || exp instanceof NotEqualsTo || exp instanceof GreaterThan || exp instanceof GreaterThanEquals || exp instanceof MinorThan || exp instanceof MinorThanEquals) {
            return 1009;
        }
        if (exp instanceof CaseExpression) {
            CaseExpression caseExpression = (CaseExpression)exp;
            Expression elseExpression = caseExpression.getElseExpression();
            int elseType = TypeUtils.getCalcItemDataType(elseExpression);
            List whenClauses = ((CaseExpression)exp).getWhenClauses();
            ArrayList<Integer> list = new ArrayList<Integer>(whenClauses.size());
            for (WhenClause when : whenClauses) {
                list.add(TypeUtils.getCalcItemDataType(when));
            }
            list.add(elseType);
            int ret = 0;
            boolean hasString = false;
            boolean hasNum = false;
            boolean hasDate = false;
            boolean hasBool = false;
            boolean hasLong = false;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                ret = i != 0 ? i : ret;
                switch (i) {
                    case 1002: {
                        hasString = true;
                        break;
                    }
                    case 1005: {
                        hasNum = true;
                        break;
                    }
                    case 1003: {
                        hasDate = true;
                        break;
                    }
                    case 1009: {
                        hasBool = true;
                        break;
                    }
                    case 1010: {
                        hasLong = true;
                        break;
                    }
                }
            }
            if (hasLong && hasNum) {
                ret = 1005;
            }
            return ret;
        }
        if (exp instanceof WhenClause) {
            return TypeUtils.getCalcItemDataType(((WhenClause)exp).getThenExpression());
        }
        if (exp instanceof Function) {
            String functionName = ((Function)exp).getName();
            if (functionName.equalsIgnoreCase("count")) {
                return 1001;
            }
            if (((Function)exp).getParameters() == null) {
                return 0;
            }
            if (functionName.equalsIgnoreCase("datediff")) {
                return 1010;
            }
            if (functionName.equalsIgnoreCase("CONCAT") || functionName.equalsIgnoreCase("DATE_FORMAT")) {
                return 1002;
            }
            int i = 0;
            int size = ((Function)exp).getParameters().getExpressions().size();
            while (i < size) {
                int calcItemDataType = TypeUtils.getCalcItemDataType((Expression)((Function)exp).getParameters().getExpressions().get(i));
                if (calcItemDataType > 0) {
                    return calcItemDataType;
                }
                ++i;
            }
            if (functionName.equalsIgnoreCase("sum")) {
                return 1005;
            }
            return 0;
        }
        if (exp instanceof InverseExpression) {
            return TypeUtils.getCalcItemDataType(((InverseExpression)exp).getExpression());
        }
        if (exp instanceof SubSelect) {
            PlainSelect subPlainSelect = ParsedSqlUtil.getPlainSelect(((SubSelect)exp).getSelectBody());
            return TypeUtils.getCalcItemDataType(((SelectExpressionItem)subPlainSelect.getSelectItems().get(0)).getExpression());
        }
        throw new RuntimeException("\u5206\u5e93\u5206\u8868\uff0c\u672a\u652f\u6301\u7684\u8ba1\u7b97\u8868\u8fbe\u5f0f\uff0c" + exp + "\u3002");
    }
}

