/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.result.process;

import com.bokesoft.yes.mid.connection.dbmanager.mysqls.Parameters;
import com.bokesoft.yes.mid.mysqls.result.eval.JSqlExpressionExecutor;
import com.bokesoft.yes.mid.mysqls.result.eval.context.GroupEvalContext;
import com.bokesoft.yes.mid.mysqls.result.function.ExpressionLocation;
import com.bokesoft.yes.mid.mysqls.result.group.ResultGroupRow;
import com.bokesoft.yes.mid.mysqls.result.process.IResultProcessor;
import com.bokesoft.yes.mid.mysqls.result.process.ResultUnion;
import com.bokesoft.yes.mid.mysqls.resultset.DataTableResultSet;
import com.bokesoft.yes.mid.mysqls.resultset.GroupValue;
import com.bokesoft.yes.mid.mysqls.resultset.ResultSetAndPos;
import com.bokesoft.yes.mid.mysqls.resultset.ResultSetGetObjectByPos;
import com.bokesoft.yes.mid.mysqls.resultset.SimpleDocumentDBUtil;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;

public class ResultGroupBy
implements IResultProcessor<ResultSetGetObjectByPos> {
    private List<String> groupColumns;
    private List<ResultSetGetObjectByPos> rsList;
    private Parameters parameters;
    private ResultSetGetObjectByPos resultIfEmpty;
    private List<ExpressionLocation> groupFunctions;

    public ResultGroupBy(List<ResultSetGetObjectByPos> rsList, List<String> groupColumns, List<ExpressionLocation> groupFunctions, Parameters parameters, ResultSetGetObjectByPos resultIfEmpty) {
        this.rsList = rsList;
        this.parameters = parameters;
        this.groupColumns = groupColumns;
        this.resultIfEmpty = resultIfEmpty;
        this.groupFunctions = groupFunctions;
    }

    @Override
    public ResultSetGetObjectByPos process() throws SQLException {
        if (this.groupFunctions == null || this.groupFunctions.isEmpty()) {
            return new ResultUnion(this.rsList, this.resultIfEmpty).process();
        }
        LinkedHashMap<GroupValue, ResultGroupRow> mapGroupRows = new LinkedHashMap<GroupValue, ResultGroupRow>();
        DataTable newDataTable = SimpleDocumentDBUtil.populate(this.rsList.get(0).getMetaData());
        DataTableResultSet result = DataTableResultSet.newInstance(newDataTable);
        int rsIndex = 0;
        int count = this.rsList.size();
        while (rsIndex < count) {
            ResultSetGetObjectByPos rs = this.rsList.get(rsIndex);
            ResultGroupBy.groupDetails(rs, result, this.groupColumns, mapGroupRows);
            ++rsIndex;
        }
        Object tmpValue = null;
        GroupEvalContext context = new GroupEvalContext(result, this.parameters);
        JSqlExpressionExecutor executor = new JSqlExpressionExecutor(context);
        for (ResultGroupRow row : mapGroupRows.values()) {
            for (ExpressionLocation expLoc : this.groupFunctions) {
                context.setCurGroupRow(row);
                tmpValue = executor.eval(expLoc.getExp());
                result.absolute(row.getResultSetAndPos().pos);
                result.updateObject(expLoc.getColumnIndex() + 1, tmpValue);
            }
        }
        return result;
    }

    public static void groupDetails(ResultSetGetObjectByPos detailRS, DataTableResultSet groupRS, List<String> groupColumns, LinkedHashMap<GroupValue, ResultGroupRow> mapGroupRows) throws SQLException {
        int columnCount = detailRS.getMetaData().getColumnCount();
        int groupColumnCount = groupColumns == null ? 0 : groupColumns.size();
        detailRS.beforeFirst();
        while (detailRS.next()) {
            GroupValue groupValue = new GroupValue(groupColumnCount);
            int i = 0;
            while (i < groupColumnCount) {
                groupValue.setValue(i, detailRS.getObject(groupColumns.get(i)));
                ++i;
            }
            ResultGroupRow groupViewRow = mapGroupRows.get(groupValue);
            if (groupViewRow == null) {
                groupRS.insertRow();
                int i2 = 0;
                int size = columnCount;
                while (i2 < size) {
                    Object tmpValue = detailRS.getObject(i2 + 1);
                    if (tmpValue != null) {
                        groupRS.updateObject(i2 + 1, tmpValue);
                    }
                    ++i2;
                }
                groupViewRow = new ResultGroupRow(new ResultSetAndPos(groupRS, groupRS.getRow()));
                mapGroupRows.put(groupValue, groupViewRow);
            }
            groupViewRow.addSourceRow(detailRS, detailRS.getRow());
        }
    }
}

