/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.processselect.regular.util;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.mysqls.processselect.ParsedSqlUtil;
import com.bokesoft.yes.mid.mysqls.processselect.regular.change.ChangedFromItem;
import com.bokesoft.yes.mid.mysqls.processselect.regular.change.ChangedFromItems;
import com.bokesoft.yes.mid.mysqls.processselect.regular.change.DeletedSubSelect;
import com.bokesoft.yes.mid.mysqls.processselect.regular.change.DeletedTable;
import com.bokesoft.yes.mid.mysqls.processselect.regular.change.InsertJoin;
import com.bokesoft.yes.mid.mysqls.processselect.regular.visitor.SelectChangeColumnVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.boke.jsqlparser.expression.BinaryExpression;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.select.AllColumns;
import net.boke.jsqlparser.statement.select.AllTableColumns;
import net.boke.jsqlparser.statement.select.FromItem;
import net.boke.jsqlparser.statement.select.Join;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.SelectItem;
import net.boke.jsqlparser.statement.select.SubSelect;

public class SqlRegularUtil {
    public static boolean isNullTable(Table table) {
        return table == null || StringUtil.isBlankOrNull((String)table.getName()) && StringUtil.isBlankOrNull((String)table.getAlias());
    }

    public static boolean isColumnTableChanged(Column column, String newAlias) {
        if (StringUtil.isBlankOrNull((String)newAlias)) {
            return false;
        }
        FromItem fromItem = column.getFormItemAsTable();
        if (fromItem == null) {
            return false;
        }
        return !newAlias.equalsIgnoreCase(fromItem.getAlias());
    }

    public static boolean isNeedFlatSubSelect4AllColumns(PlainSelect plainSelect) {
        return plainSelect.getSelectItems().size() == 1 && plainSelect.getSelectItems().get(0) instanceof AllColumns && plainSelect.getJoins() == null;
    }

    public static void doChangeColumn(PlainSelect plainSelect, ChangedFromItems changedFromItems) {
        SelectChangeColumnVisitor selectChangeColumnVisitor = new SelectChangeColumnVisitor(changedFromItems);
        plainSelect.accept(selectChangeColumnVisitor);
    }

    public static void doInsertJoin(PlainSelect plainSelect, InsertJoin insertJoin) {
        ArrayList<Join> joins = plainSelect.getJoins();
        FromItem rightItem = insertJoin.join.getRightItem();
        boolean exsitJoinTable = false;
        if (rightItem instanceof SubSelect) {
            BinaryExpression binaryExpression = (BinaryExpression)insertJoin.join.getOnExpression();
            Expression leftExpression = binaryExpression.getLeftExpression();
            while (leftExpression instanceof BinaryExpression) {
                leftExpression = ((BinaryExpression)leftExpression).getLeftExpression();
            }
            if (!(leftExpression instanceof Column)) {
                throw new RuntimeException("\u5206\u5e93\u5206\u8868,\u8f6c\u6362in\u8868\u8fbe\u5f0f\u5230join\u9519\u8bef,\u627e\u4e0d\u5230OnExpression\u4e2d\u7684Column");
            }
            Column column = (Column)leftExpression;
            FromItem columnTable = column.getExtendFromItem();
            if (columnTable != null) {
                exsitJoinTable = true;
            }
        }
        if (exsitJoinTable || rightItem instanceof Table) {
            int pos;
            if (joins == null) {
                joins = new ArrayList<Join>();
                plainSelect.setJoins(joins);
                List selectItems = plainSelect.getSelectItems();
                int i = 0;
                int size = selectItems != null ? selectItems.size() : 0;
                while (i < size) {
                    SelectItem selectItem = (SelectItem)selectItems.get(i);
                    if (selectItem instanceof AllColumns) {
                        selectItems.set(i, new AllTableColumns(new Table(null, ParsedSqlUtil.getFromItemShortName(plainSelect.getFromItem()))));
                    }
                    ++i;
                }
            }
            if ((pos = joins.indexOf(insertJoin.nextJoin)) == -1) {
                joins.add(insertJoin.join);
            } else {
                joins.add(pos, insertJoin.join);
            }
            if (insertJoin.whereExpression != null) {
                plainSelect.setWhere(ParsedSqlUtil.newAndExpression(plainSelect.getWhere(), insertJoin.whereExpression));
            }
        } else {
            throw new RuntimeException("\u5206\u5e93\u51fa\u9519\uff0cIn\u8bed\u53e5\u4e22\u5931\u3002");
        }
    }

    public static void doDeleteSubSelect(PlainSelect plainSelect, DeletedSubSelect deletedSubSelect) {
        PlainSelect subPlainSelect;
        SubSelect delSubselect;
        ArrayList joins = plainSelect.getJoins();
        if (joins == null) {
            joins = new ArrayList();
            plainSelect.setJoins(joins);
        }
        if ((delSubselect = deletedSubSelect.subSelect).getSelectBody() instanceof PlainSelect && (subPlainSelect = (PlainSelect)delSubselect.getSelectBody()).getGroupByColumnReferences() != null) {
            List groupList = plainSelect.getGroupByColumnReferences();
            if (groupList == null) {
                groupList = subPlainSelect.getGroupByColumnReferences();
            }
            plainSelect.setGroupByColumnReferences(groupList);
        }
        Iterator it = joins.iterator();
        while (it.hasNext()) {
            Join join = (Join)it.next();
            if (join.getRightItem() != deletedSubSelect.subSelect) continue;
            it.remove();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void doChangeFormItem(PlainSelect plainSelect, ChangedFromItems changedFromItems) {
        ArrayList<Join> joins = plainSelect.getJoins();
        if (changedFromItems.getSize() <= 0) return;
        for (ChangedFromItem changeFormItem : changedFromItems) {
            if (changeFormItem.isAppend() || changeFormItem.getOrgPlainSelect() != plainSelect) continue;
            if (changeFormItem instanceof InsertJoin) {
                int pos;
                InsertJoin insertJoin = (InsertJoin)changeFormItem;
                FromItem rightItem = insertJoin.join.getRightItem();
                boolean exsitJoinTable = false;
                if (rightItem instanceof SubSelect) {
                    BinaryExpression binaryExpression = (BinaryExpression)insertJoin.join.getOnExpression();
                    Expression leftExpression = binaryExpression.getLeftExpression();
                    while (leftExpression instanceof BinaryExpression) {
                        leftExpression = ((BinaryExpression)leftExpression).getLeftExpression();
                    }
                    if (!(leftExpression instanceof Column)) {
                        throw new RuntimeException("\u5206\u5e93\u5206\u8868,\u8f6c\u6362in\u8868\u8fbe\u5f0f\u5230join\u9519\u8bef,\u627e\u4e0d\u5230OnExpression\u4e2d\u7684Column");
                    }
                    Column column = (Column)leftExpression;
                    FromItem columnTable = column.getExtendFromItem();
                    if (columnTable != null) {
                        exsitJoinTable = true;
                    }
                }
                if (!exsitJoinTable && !(rightItem instanceof Table)) throw new RuntimeException("\u5206\u5e93\u51fa\u9519\uff0cIn\u8bed\u53e5\u4e22\u5931\u3002");
                if (joins == null) {
                    joins = new ArrayList();
                    plainSelect.setJoins(joins);
                    List selectItems = plainSelect.getSelectItems();
                    int i = 0;
                    int size = selectItems != null ? selectItems.size() : 0;
                    while (i < size) {
                        SelectItem selectItem = (SelectItem)selectItems.get(i);
                        if (selectItem instanceof AllColumns) {
                            selectItems.set(i, new AllTableColumns(new Table(null, ParsedSqlUtil.getFromItemShortName(plainSelect.getFromItem()))));
                        }
                        ++i;
                    }
                }
                if ((pos = joins.indexOf(insertJoin.nextJoin)) == -1) {
                    joins.add(insertJoin.join);
                } else {
                    joins.add(pos, insertJoin.join);
                }
                if (insertJoin.whereExpression != null) {
                    plainSelect.setWhere(ParsedSqlUtil.newAndExpression(plainSelect.getWhere(), insertJoin.whereExpression));
                }
            } else if (changeFormItem instanceof DeletedSubSelect) {
                PlainSelect subPlainSelect;
                if (joins == null) {
                    joins = new ArrayList<Join>();
                    plainSelect.setJoins(joins);
                }
                DeletedSubSelect deletedSubSelect = (DeletedSubSelect)changeFormItem;
                SubSelect delSubselect = deletedSubSelect.subSelect;
                if (delSubselect.getSelectBody() instanceof PlainSelect && (subPlainSelect = (PlainSelect)delSubselect.getSelectBody()).getGroupByColumnReferences() != null) {
                    List groupList = plainSelect.getGroupByColumnReferences();
                    if (groupList == null) {
                        groupList = subPlainSelect.getGroupByColumnReferences();
                    }
                    plainSelect.setGroupByColumnReferences(groupList);
                }
                Iterator it = joins.iterator();
                while (it.hasNext()) {
                    Join join = (Join)it.next();
                    if (join.getRightItem() != ((DeletedSubSelect)changeFormItem).subSelect) continue;
                    it.remove();
                }
            } else if (changeFormItem instanceof DeletedTable) {
                DeletedTable deletedTable = (DeletedTable)changeFormItem;
                if (deletedTable.whereExpression != null) {
                    plainSelect.setWhere(ParsedSqlUtil.newAndExpression(plainSelect.getWhere(), deletedTable.whereExpression));
                }
            }
            changeFormItem.setAppend();
        }
    }
}

