/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.processselect.regular.change;

import com.bokesoft.yes.mid.mysqls.dbstruct.DBStruct;
import com.bokesoft.yes.mid.mysqls.processselect.regular.change.ChangedFromItem;
import java.util.List;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.select.FromItem;
import net.boke.jsqlparser.statement.select.Join;
import net.boke.jsqlparser.statement.select.PlainSelect;

public class InsertJoin
extends ChangedFromItem {
    public final Join join;
    public final Expression whereExpression;
    public final Join nextJoin;

    public InsertJoin(Join join, Expression whereExpression, PlainSelect plainSelect, Join nextJoin) {
        super(plainSelect);
        this.join = join;
        this.whereExpression = whereExpression;
        this.nextJoin = nextJoin;
    }

    @Override
    public Expression checkColumn(Column column, PlainSelect plainSelect) {
        Table table = column.getTable();
        if (table == null || table.getWholeTableName() == null) {
            Table findTable;
            String tableName;
            String columnName = column.getColumnName();
            FromItem joinFromItem = this.join.getRightItem();
            if (joinFromItem instanceof Table && DBStruct.isExistColumnInTable(columnName, tableName = ((Table)joinFromItem).getName()) && (findTable = this.findTableByColumnName(plainSelect, columnName)) != null) {
                String tableAlias = findTable.getAlias();
                if (tableAlias == null || tableAlias.length() == 0) {
                    tableAlias = findTable.getName();
                }
                column.setTable(new Table(null, tableAlias));
            }
        }
        return null;
    }

    private Table findTableByColumnName(PlainSelect plainSelect, String columnName) {
        Table result = this.findTableByColumnName(plainSelect.getFromItem(), columnName);
        if (result == null) {
            List joins = plainSelect.getJoins();
            if (joins == null) {
                return result;
            }
            for (Object objJoin : joins) {
                Join join = (Join)objJoin;
                result = this.findTableByColumnName(join.getRightItem(), columnName);
                if (result != null) break;
            }
        }
        return result;
    }

    private Table findTableByColumnName(FromItem fromItem, String columnName) {
        String tableName;
        if (fromItem instanceof Table && DBStruct.isExistColumnInTable(columnName, tableName = ((Table)fromItem).getName())) {
            return (Table)fromItem;
        }
        return null;
    }
}

