/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.processselect;

import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBPreparedStatement;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.Parameters;
import com.bokesoft.yes.mid.mysqls.processselect.ParsedSqlUtil;
import com.bokesoft.yes.mid.mysqls.processselect.SubQuery;
import com.bokesoft.yes.mid.mysqls.sql.FindJdbcParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.JdbcParameter;
import net.boke.jsqlparser.expression.operators.relational.EqualsTo;
import net.boke.jsqlparser.expression.operators.relational.InExpression;
import net.boke.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.statement.select.Join;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.SubSelect;
import net.boke.jsqlparser.util.deparser.ExpressionDeParser;
import net.boke.jsqlparser.util.deparser.SelectDeParser;

public class SubQueryWithRelation {
    final SubQuery subQuery;
    List<Expression> relationExps = null;
    List<Column> columns = null;
    int parameterCount = 0;
    private Map<Join, Expression> addJoinRelationExps;
    private Map<PlainSelect, Expression> addPlainSelectRelationExps;

    public SubQueryWithRelation(SubQuery subQuery) {
        this.subQuery = subQuery;
    }

    public void addRelationExp(Expression relationExp) {
        if (this.relationExps == null) {
            this.relationExps = new ArrayList<Expression>();
        }
        this.relationExps.add(relationExp);
    }

    public void addColumn(Column comlumn) {
        if (this.columns == null) {
            this.columns = new ArrayList<Column>();
        }
        this.columns.add(comlumn);
    }

    public String getSql(MultiDBPreparedStatement preparedStatement, List<Parameters> allSubParamters, SubQuery subSelect, final List<Object> values, final List<Integer> jdbcTypes) {
        this.preProcessRelationExpression();
        List<JdbcParameter> curJdbcParameters = FindJdbcParameter.getAllJdbcParameters(subSelect.getPlainSelect());
        final Parameters allParameters = preparedStatement.getParametersList().size() > 0 ? preparedStatement.getParametersList().get(0) : new Parameters(0);
        final Parameters subParamters = new Parameters(curJdbcParameters.size() + values.size());
        if (curJdbcParameters.size() + values.size() > 0) {
            allSubParamters.add(subParamters);
        }
        PlainSelect plainSelect = this.subQuery.plainSelect;
        StringBuffer buffer = new StringBuffer(1024);
        SelectDeParser selectDeParser = new SelectDeParser(){

            @Override
            protected Expression getJoinOnExpression(Join join) {
                if (SubQueryWithRelation.this.addJoinRelationExps == null) {
                    return join.getOnExpression();
                }
                return ParsedSqlUtil.newAndExpression(join.getOnExpression(), (Expression)SubQueryWithRelation.this.addJoinRelationExps.get(join));
            }

            @Override
            protected Expression getPlainSelectWhere(PlainSelect plainSelect) {
                if (SubQueryWithRelation.this.addPlainSelectRelationExps == null) {
                    return plainSelect.getWhere();
                }
                return ParsedSqlUtil.newAndExpression(plainSelect.getWhere(), (Expression)SubQueryWithRelation.this.addPlainSelectRelationExps.get(plainSelect));
            }
        };
        selectDeParser.setBuffer(buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, buffer){

            @Override
            public void visit(JdbcParameter jdbcParameter) {
                Integer indexInSql = jdbcParameter.getIndexInSql();
                if (indexInSql >= 0) {
                    subParamters.setArg(++SubQueryWithRelation.this.parameterCount, allParameters.getType(indexInSql + 1), allParameters.getValue(indexInSql + 1));
                } else if (jdbcParameter.isUseFixedIndex()) {
                    Integer index = jdbcParameter.getIndex();
                    subParamters.setArg(++SubQueryWithRelation.this.parameterCount, (Integer)jdbcTypes.get(index), values.get(index));
                }
                this.buffer.append("?");
            }
        };
        selectDeParser.setExpressionVisitor(expressionDeParser);
        plainSelect.accept(selectDeParser);
        return buffer.toString();
    }

    private void preProcessRelationExpression() {
        if (this.relationExps == null) {
            return;
        }
        for (Expression exp : this.relationExps) {
            if (this.addJoinOnOrWhereExpressionByTableName(exp)) continue;
            if (this.addPlainSelectRelationExps == null) {
                this.addPlainSelectRelationExps = new HashMap<PlainSelect, Expression>();
            }
            PlainSelect plainSelect = this.subQuery.plainSelect;
            this.addPlainSelectRelationExps.put(plainSelect, ParsedSqlUtil.newAndExpression(this.addPlainSelectRelationExps.get(plainSelect), exp));
        }
    }

    private boolean addJoinOnOrWhereExpressionByTableName(Expression expression) {
        Expression column = null;
        if (expression instanceof InExpression) {
            column = ((InExpression)expression).getLeftExpression();
        } else if (expression instanceof EqualsTo) {
            column = ((EqualsTo)expression).getLeftExpression();
        } else if (expression instanceof NotEqualsTo) {
            column = ((NotEqualsTo)expression).getLeftExpression();
        }
        if (column != null && column instanceof Column) {
            int tableIndex = this.subQuery.getTableIndex(column);
            if (tableIndex < 1) {
                return false;
            }
            PlainSelect plainSelect = this.subQuery.plainSelect;
            List joins = plainSelect.getJoins();
            if (joins.size() >= tableIndex) {
                Join join = (Join)plainSelect.getJoins().get(tableIndex - 1);
                if (join.isInner()) {
                    if (this.addJoinRelationExps == null) {
                        this.addJoinRelationExps = new HashMap<Join, Expression>();
                    }
                    this.addJoinRelationExps.put(join, ParsedSqlUtil.newAndExpression(this.addJoinRelationExps.get(join), expression));
                    return true;
                }
            } else {
                SubSelect subSelect = ParsedSqlUtil.getSubSelectInExpression(plainSelect.getWhere(), (Column)column);
                PlainSelect subPlainSelect = (PlainSelect)subSelect.getSelectBody();
                if (this.addPlainSelectRelationExps == null) {
                    this.addPlainSelectRelationExps = new HashMap<PlainSelect, Expression>();
                }
                this.addPlainSelectRelationExps.put(subPlainSelect, ParsedSqlUtil.newAndExpression(this.addPlainSelectRelationExps.get(subPlainSelect), expression));
                return true;
            }
        }
        return false;
    }
}

