/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.processselect;

import java.util.ArrayList;
import java.util.List;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.select.FromItem;
import net.boke.jsqlparser.statement.select.SubSelect;

public class InTableGroups {
    List<List<FromItem>> groups;

    public void addInTableGroup(List<FromItem> tables) {
        if (this.groups == null) {
            this.groups = new ArrayList<List<FromItem>>();
        }
        this.groups.add(tables);
    }

    public boolean contains(FromItem table) {
        if (this.groups != null) {
            for (List<FromItem> inTableGroup : this.groups) {
                if (!inTableGroup.contains(table)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsObject(FromItem table) {
        if (this.groups != null) {
            for (List<FromItem> inTableGroup : this.groups) {
                for (FromItem fromItem : inTableGroup) {
                    if (fromItem != table) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public InTableGroups getSubGroups(List<FromItem> tables) {
        InTableGroups result = null;
        int i = 0;
        int size = this.groups != null ? this.groups.size() : 0;
        while (i < size) {
            List<FromItem> group = this.groups.get(i);
            ArrayList<FromItem> subGroup = null;
            for (FromItem table : tables) {
                if (!group.contains(table)) continue;
                if (subGroup == null) {
                    subGroup = new ArrayList<FromItem>();
                }
                subGroup.add(table);
            }
            if (subGroup != null) {
                if (result == null) {
                    result = new InTableGroups();
                }
                result.addInTableGroup(subGroup);
            }
            ++i;
        }
        return result;
    }

    public int size() {
        return this.groups != null ? this.groups.size() : 0;
    }

    public List<FromItem> get(int i) {
        return this.groups.get(i);
    }

    public boolean hasNotInOrExist(List<FromItem> tables) {
        int i = 0;
        int size = this.groups != null ? this.groups.size() : 0;
        while (i < size) {
            List<FromItem> group = this.groups.get(i);
            for (FromItem table : tables) {
                Boolean isNotInOrExist;
                if (!group.contains(table) || (isNotInOrExist = InTableGroups.getIsNotInOrExist(table)) == null || !isNotInOrExist.booleanValue()) continue;
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Boolean getIsNotInOrExist(FromItem fromItem) {
        if (fromItem instanceof Table) {
            return ((Table)fromItem).getIsNotInOrExist();
        }
        if (fromItem instanceof SubSelect) {
            return ((SubSelect)fromItem).getIsNotInOrExist();
        }
        return false;
    }
}

