/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.oidpool;

import com.bokesoft.yes.common.util.SerializeUtil;
import com.bokesoft.yes.mid.redis.RedisSimpleConnection;
import java.util.Date;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class ERPRedisHelper
extends RedisSimpleConnection {
    private int expireTime = 0;

    public ERPRedisHelper(JedisPool pool, int dbIndex, String prefix) {
        super(pool, dbIndex, prefix);
    }

    public void setObject(int num, Object key, Object value) {
        if (key instanceof String) {
            this.setObject(num, (String)key, value);
        } else if (key instanceof Number) {
            this.setObject(num, String.valueOf(key), value);
        } else if (key instanceof Date) {
            this.setObject(num, String.valueOf(key), value);
        } else {
            Jedis jedis = this.getJedis();
            jedis.select(num);
            jedis.set(SerializeUtil.serialize((Object)key), SerializeUtil.serialize((Object)value));
            if (this.expireTime > 0) {
                jedis.expire(SerializeUtil.serialize((Object)key), (long)this.expireTime);
            }
            jedis.close();
        }
    }

    private void setObject(int num, String key, Object value) {
        Jedis jedis = this.getJedis();
        jedis.select(num);
        jedis.set(key.getBytes(), SerializeUtil.serialize((Object)value));
        if (this.expireTime > 0) {
            jedis.expire(key, (long)this.expireTime);
        }
        jedis.close();
    }

    public void setExpireTime(int expireTime) {
        this.expireTime = expireTime;
    }
}

