/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.group;

import com.bokesoft.yes.mid.mysqls.group.Group;
import com.bokesoft.yes.mid.mysqls.group.GroupField;
import com.bokesoft.yes.mid.mysqls.group.GroupTable;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProp;
import java.util.ArrayList;
import java.util.List;

public class OneGroupValue {
    List<String> groupFields;
    List<Object> groupValues;

    protected OneGroupValue(GroupField[] groupFields) {
        int groupFieldCount = groupFields.length;
        this.groupFields = new ArrayList<String>(groupFieldCount);
        this.groupValues = new ArrayList<Object>(groupFieldCount);
        int i = 0;
        while (i < groupFieldCount) {
            this.groupFields.add(groupFields[i].key);
            this.groupValues.add(null);
            ++i;
        }
    }

    public OneGroupValue() {
        this.groupFields = new ArrayList<String>();
        this.groupValues = new ArrayList<Object>();
    }

    public Object getGroupValue(String groupField) {
        int i = 0;
        int len = this.groupFields.size();
        while (i < len) {
            if (this.groupFields.get(i).equals(groupField)) {
                return this.groupValues.get(i);
            }
            ++i;
        }
        return null;
    }

    public void setGroupValue(String groupFieldKey, Object value) {
        int i = 0;
        int len = this.groupFields.size();
        while (i < len) {
            if (this.groupFields.get(i).equals(groupFieldKey)) {
                this.groupValues.set(i, value);
                return;
            }
            ++i;
        }
        this.groupFields.add(groupFieldKey);
        this.groupValues.add(value);
    }

    public void expandValueByRelation(TableGroupProp tableGroupProp) throws Throwable {
        Group group = tableGroupProp.getGroup();
        String groupTableName = tableGroupProp.getTableName();
        GroupTable groupTable = group.getDefTableNams().get(groupTableName);
        String[] columnNames = groupTable.getGroupColumnNames();
        List<GroupField> groupFields = group.getGroupFields();
        int i = 0;
        int size = groupFields.size();
        while (i < size) {
            Object value = this.getGroupValue(groupFields.get(i).getKey());
            if (value == null && columnNames[i] == null && (value = group.getGroupFieldValueByRelationTables(groupTableName, groupFields.get(i), this)) != null) {
                this.setGroupValue(groupFields.get(i).getKey(), value);
            }
            ++i;
        }
    }

    public boolean hasUnDefinedGroupValue() {
        for (Object tmp : this.groupValues) {
            if (tmp != GroupField.UndefinedGroupValue) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        int count;
        int n = count = this.groupFields != null ? this.groupFields.size() : 0;
        if (count == 0) {
            return "null";
        }
        StringBuilder sb = new StringBuilder(256);
        int i = 0;
        while (i < count) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.groupFields.get(i)).append(":").append(this.groupValues.get(i));
            ++i;
        }
        return sb.toString();
    }

    public boolean isAllValueEmpty() {
        if (this.groupValues == null || this.groupValues.size() == 0) {
            return true;
        }
        for (Object groupValue : this.groupValues) {
            if (groupValue == null) continue;
            return false;
        }
        return true;
    }
}

