/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.group;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class GroupKeyConfigInfo {
    private HashMap<String, Set<String>> dsnNamesByCompanyCode = new HashMap();
    private HashMap<String, Set<String>> dsnNamesByPeriod = new HashMap();
    private HashMap<String, Set<String>> periodsByCompanyCode = new HashMap();
    private HashMap<String, Set<String>> yearsByCompanyCode = new HashMap();
    private HashMap<String, String> dsnNames = new HashMap();
    private static GroupKeyConfigInfo instance = null;

    private GroupKeyConfigInfo() {
    }

    public static synchronized GroupKeyConfigInfo getInstance() {
        if (instance == null) {
            instance = new GroupKeyConfigInfo();
        }
        return instance;
    }

    public void addDsnNameToRealDsnName(String dsnName, String realDsnName) {
        if (!this.dsnNames.containsValue(dsnName)) {
            this.dsnNames.put(dsnName, realDsnName);
        }
    }

    public Set<String> getDSNNamesByCompanyCode(String companyCode) {
        return this.dsnNamesByCompanyCode.get(companyCode);
    }

    public Set<String> getDSNNamesByPeriod(String period) {
        return this.dsnNamesByPeriod.get(period);
    }

    public Set<String> getPeriodsByCompanyCode(String companyCode) {
        return this.periodsByCompanyCode.get(companyCode);
    }

    public Set<String> getYearsByCompanyCode(String companyCode) {
        return this.yearsByCompanyCode.get(companyCode);
    }

    public Set<String> ensureDsnNamesByCompanyCode(String companyCode) {
        Set<String> dsnNameMap = this.dsnNamesByCompanyCode.get(companyCode);
        if (dsnNameMap == null) {
            dsnNameMap = new HashSet<String>();
            this.dsnNamesByCompanyCode.put(companyCode, dsnNameMap);
        }
        return dsnNameMap;
    }

    public Set<String> ensureDsnNamesByPeriod(String period) {
        Set<String> dsnNameMap = this.dsnNamesByPeriod.get(period);
        if (dsnNameMap == null) {
            dsnNameMap = new HashSet<String>();
            this.dsnNamesByPeriod.put(period, dsnNameMap);
        }
        return dsnNameMap;
    }

    public Set<String> ensurePeriodsByCompanyCode(String companyCode) {
        Set<String> periodSet = this.periodsByCompanyCode.get(companyCode);
        if (periodSet == null) {
            periodSet = new HashSet<String>();
            this.periodsByCompanyCode.put(companyCode, periodSet);
        }
        return periodSet;
    }

    public Set<String> ensureYearsByCompanyCode(String companyCode) {
        Set<String> yearSet = this.yearsByCompanyCode.get(companyCode);
        if (yearSet == null) {
            yearSet = new HashSet<String>();
            this.yearsByCompanyCode.put(companyCode, yearSet);
        }
        return yearSet;
    }

    public String getRealDsnName(String dsnName) {
        String realDsnName = this.dsnNames.get(dsnName);
        return realDsnName;
    }
}

