/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.execute;

import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBManager;
import com.bokesoft.yes.mid.mysqls.execute.UpdateExecute;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProp;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProps;
import com.bokesoft.yes.mid.mysqls.oidpool.DSNTableName;
import com.bokesoft.yes.mid.mysqls.oidpool.OIDPool;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MoveHeadDataAfterGroupDetailChangeDSN {
    HashMapIgnoreCase<Map<Long, DSNTableName>> data;
    HashMapIgnoreCase<Set<Long>> deletedHeadOIDGroupByDetail;

    public DSNTableName calcDSNTableName(String tableName, Long soid) {
        if (this.data == null) {
            return null;
        }
        Map dsnTableNames = (Map)this.data.get(tableName);
        if (dsnTableNames == null) {
            return null;
        }
        DSNTableName result = (DSNTableName)dsnTableNames.get(soid);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private DSNTableName getDSNTableName(String tableName, Long soid) {
        DSNTableName result;
        HashMap<Long, DSNTableName> dsnTableNames;
        if (this.data == null) {
            Class<MoveHeadDataAfterGroupDetailChangeDSN> clazz = MoveHeadDataAfterGroupDetailChangeDSN.class;
            // MONITORENTER : com.bokesoft.yes.mid.mysqls.execute.MoveHeadDataAfterGroupDetailChangeDSN.class
            if (this.data == null) {
                this.data = new HashMapIgnoreCase();
            }
            // MONITOREXIT : clazz
        }
        if ((dsnTableNames = (HashMap<Long, DSNTableName>)this.data.get(tableName)) == null) {
            Class<MoveHeadDataAfterGroupDetailChangeDSN> clazz = MoveHeadDataAfterGroupDetailChangeDSN.class;
            // MONITORENTER : com.bokesoft.yes.mid.mysqls.execute.MoveHeadDataAfterGroupDetailChangeDSN.class
            dsnTableNames = (Map)this.data.get(tableName);
            if (dsnTableNames == null) {
                dsnTableNames = new HashMap<Long, DSNTableName>();
                this.data.put(tableName, dsnTableNames);
            }
            // MONITOREXIT : clazz
        }
        if ((result = (DSNTableName)dsnTableNames.get(soid)) != null) return result;
        Class<MoveHeadDataAfterGroupDetailChangeDSN> clazz = MoveHeadDataAfterGroupDetailChangeDSN.class;
        // MONITORENTER : com.bokesoft.yes.mid.mysqls.execute.MoveHeadDataAfterGroupDetailChangeDSN.class
        result = (DSNTableName)dsnTableNames.get(soid);
        if (result == null) {
            result = new DSNTableName();
            dsnTableNames.put(soid, result);
        }
        // MONITOREXIT : clazz
        return result;
    }

    void addInsertDSNTableName(String tableName, Long soid, String dsnName) {
        DSNTableName result = this.getDSNTableName(tableName, soid);
        result.addNewDSNName(dsnName);
    }

    void addDeleteDSNTableName(String tableName, Long soid, String dsnName) {
        DSNTableName result = this.getDSNTableName(tableName, soid);
        result.addDSNName(dsnName);
    }

    public void removeMoveHead(String tableName, Long soid) {
        HashSet<Long> oids;
        Map dsnTableNames;
        if (this.data != null && (dsnTableNames = (Map)this.data.get(tableName)) != null) {
            dsnTableNames.remove(soid);
        }
        if (this.deletedHeadOIDGroupByDetail == null) {
            this.deletedHeadOIDGroupByDetail = new HashMapIgnoreCase();
        }
        if ((oids = (HashSet<Long>)this.deletedHeadOIDGroupByDetail.get(tableName)) == null) {
            oids = new HashSet<Long>();
            this.deletedHeadOIDGroupByDetail.put(tableName, oids);
        }
        oids.add(soid);
    }

    public void submit(MultiDBManager dbm) throws Throwable {
        if (this.data != null) {
            for (Map.Entry entry : this.data.entrySet()) {
                Set deleteOIDs;
                String tableName = (String)entry.getKey();
                Map dsnTableNames = (Map)entry.getValue();
                if (this.deletedHeadOIDGroupByDetail != null && (deleteOIDs = (Set)this.deletedHeadOIDGroupByDetail.get(tableName)) != null) {
                    for (Long oid : deleteOIDs) {
                        dsnTableNames.remove(oid);
                    }
                }
                this.submit(dbm, tableName, dsnTableNames);
            }
        }
        this.data = null;
    }

    public void submit(MultiDBManager dbm, String tableName) throws Throwable {
        Map dsnTableNames;
        if (this.data != null && (dsnTableNames = (Map)this.data.get(tableName)) != null) {
            Set deleteOIDs;
            if (this.deletedHeadOIDGroupByDetail != null && (deleteOIDs = (Set)this.deletedHeadOIDGroupByDetail.get(tableName)) != null) {
                for (Long oid : deleteOIDs) {
                    dsnTableNames.remove(oid);
                }
            }
            this.submit(dbm, tableName, dsnTableNames);
            this.data.remove(tableName);
        }
    }

    private void submit(MultiDBManager dbm, String tableName, Map<Long, DSNTableName> dsnTableNames) throws Throwable {
        for (Map.Entry<Long, DSNTableName> entry : dsnTableNames.entrySet()) {
            this.submit(dbm, tableName, entry.getKey(), entry.getValue());
        }
    }

    private void submit(MultiDBManager dbm, String tableName, Long soid, DSNTableName dsnTableName) throws Throwable {
        TableGroupProp tableGroupProp = TableGroupProps.getInstance().getTableGroupProp(tableName);
        String detailTableName = tableGroupProp.getGroupDetailTable().getTableName();
        ArrayList<String> validDSNNames = new ArrayList<String>();
        ArrayList<String> checkedDSNNames = new ArrayList<String>();
        if (dsnTableName.getDsnNames() != null) {
            for (String dsnName : dsnTableName.getDsnNames()) {
                if (checkedDSNNames.contains(dsnName)) continue;
                checkedDSNNames.add(dsnName);
                if (!this.isValidDSNName(dbm, dsnName, detailTableName, soid)) continue;
                validDSNNames.add(dsnName);
            }
        }
        if (dsnTableName.getNewDSNNames() != null) {
            for (String dsnName : dsnTableName.getNewDSNNames()) {
                if (checkedDSNNames.contains(dsnName)) continue;
                checkedDSNNames.add(dsnName);
                if (!this.isValidDSNName(dbm, dsnName, detailTableName, soid)) continue;
                validDSNNames.add(dsnName);
            }
        }
        OIDPool oidPool = dbm.getOIDToDSNName();
        DSNTableName oldDSNTableName = oidPool.getDSNTableName(soid, tableGroupProp);
        String queryDSNName = oldDSNTableName.getDsnNames().getValue(0);
        ArrayList<String> deleteDSNNames = new ArrayList<String>();
        if (dsnTableName.getDsnNames() != null) {
            for (String dsnName : dsnTableName.getDsnNames()) {
                if (validDSNNames.contains(dsnName)) continue;
                deleteDSNNames.add(dsnName);
                oldDSNTableName.getDsnNames().removeValue(dsnName);
            }
        }
        ArrayList<String> insertDSNNames = new ArrayList<String>();
        if (dsnTableName.getNewDSNNames() != null) {
            for (String dsnName : dsnTableName.getNewDSNNames()) {
                if (!validDSNNames.contains(dsnName) || oldDSNTableName.getDsnNames().hasValue(dsnName)) continue;
                insertDSNNames.add(dsnName);
                oldDSNTableName.getDsnNames().addValue(dsnName);
            }
        }
        if (deleteDSNNames.size() > 0 || insertDSNNames.size() > 0) {
            oidPool.setOIDDSNName(soid, oldDSNTableName);
            UpdateExecute.moveData(dbm, tableName, soid, queryDSNName, deleteDSNNames, insertDSNNames);
        }
    }

    private boolean isValidDSNName(MultiDBManager dbm, String dsnName, String detailTableName, Long soid) throws Throwable {
        String sql = "SELECT SOID FROM " + detailTableName + " WHERE " + "SOID" + "=? LIMIT 1";
        DataTable dataTable = dbm.execPrepareQuery(dsnName, sql, soid);
        return dataTable.first();
    }

    public void rollback() {
        this.data = null;
    }
}

