/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.migration.process.merge;

import com.bokesoft.yes.mid.base.MidVE;
import com.bokesoft.yes.mid.connection.MdbDSNItems;
import com.bokesoft.yes.mid.connection.MultiDBDSNItem;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBManager;
import com.bokesoft.yes.mid.migration.period.MigrationStruct;
import com.bokesoft.yes.mid.migration.process.merge.DefaultMigrationMerge;
import com.bokesoft.yes.mid.migration.process.merge.ErpMigrationMerge;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProp;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProps;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;

public class MigrationMergeProxy {
    private String dataObjectKey = null;
    private boolean isolatedTransaction = true;

    public MigrationMergeProxy(String dataObjectKey, boolean isolatedTransaction) {
        this.dataObjectKey = dataObjectKey;
        this.isolatedTransaction = isolatedTransaction;
    }

    public void process(DefaultContext context) throws Throwable {
        MidVE ve = context.getVE();
        Object mm = null;
        DefaultContext newContext = null;
        MetaDataObject dataObject = context.getVE().getMetaFactory().getDataObject(this.dataObjectKey);
        if (dataObject == null) {
            return;
        }
        int migrationUpdateStrategy = dataObject.getMigrationUpdateStrategy();
        if (migrationUpdateStrategy != 4 && migrationUpdateStrategy != 5) {
            return;
        }
        try {
            try {
                newContext = this.isolatedTransaction ? new DefaultContext(ve) : context;
                PSArgs args = new PSArgs();
                args.addStringArg("Migration_" + this.dataObjectKey);
                newContext.getDBManager().setRowLock("SYS_Lock", "UniqueKey=?", (QueryArguments)args);
                if (migrationUpdateStrategy == 5) {
                    TableGroupProp tableGroupProp;
                    MigrationStruct struct = MigrationStruct.get(this.dataObjectKey);
                    String groupKey = null;
                    if (newContext.getDBManager() instanceof MultiDBManager && (tableGroupProp = TableGroupProps.getInstance().getTableGroupProp(struct.getNewTableName())) != null) {
                        groupKey = tableGroupProp.getGroup().getKey();
                        this.processMdbMigration(newContext, groupKey);
                    }
                    if (groupKey == null) {
                        mm = new ErpMigrationMerge();
                        mm.merge(newContext, this.dataObjectKey);
                    }
                } else {
                    mm = new DefaultMigrationMerge();
                    mm.merge(newContext, this.dataObjectKey);
                }
                if (this.isolatedTransaction) {
                    newContext.commit();
                }
            }
            catch (Throwable e) {
                if (newContext != null && this.isolatedTransaction) {
                    newContext.rollback();
                }
                throw e;
            }
        }
        finally {
            if (newContext != null && this.isolatedTransaction) {
                newContext.close();
            }
        }
    }

    private void processMdbMigration(DefaultContext newContext, String groupKey) throws Throwable {
        MultiDBManager multiDBManager = (MultiDBManager)newContext.getDBManager();
        ErpMigrationMerge mm = new ErpMigrationMerge();
        for (MultiDBDSNItem dsnItem : MdbDSNItems.instance) {
            if (!dsnItem.hasGroupKey(groupKey) && MdbDSNItems.instance.getDefaultDSN() != MdbDSNItems.instance.getDSNItem(dsnItem.getName())) continue;
            IDBManager tmpForClose = null;
            DefaultContext contextSingleDB = null;
            final IDBManager dbmSingleDB = tmpForClose = multiDBManager.getDBManagerByDsnName(dsnItem.getName());
            dbmSingleDB.getCacheDBRequest().stopLocalIsUseCacheDB();
            contextSingleDB = new DefaultContext((MidVE)newContext.getVE().clone()){

                public IDBManager getDBManager() throws Throwable {
                    return dbmSingleDB;
                }
            };
            mm.merge(contextSingleDB, this.dataObjectKey);
        }
    }
}

