/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.migration.process.merge;

import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.common.struct.RefObject;
import com.bokesoft.yes.mid.connection.dbmanager.BatchPsPara;
import com.bokesoft.yes.mid.io.migration.process.merge.ErpMigrationDataProcess;
import com.bokesoft.yes.mid.migration.period.DataTableBatchPsPara;
import com.bokesoft.yes.mid.migration.period.MigrationStruct;
import com.bokesoft.yes.mid.migration.process.merge.IMigrationMerge;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class ErpMigrationMerge
implements IMigrationMerge {
    ErpMigrationDataProcess dataProcess = new ErpMigrationDataProcess();

    public void merge(DefaultContext context, String dataObjectKey) throws Throwable {
        Object[] actions = new Object[]{"merge _Incr Into _new ", dataObjectKey};
        int action = Performance.startAction((Object[])actions);
        MigrationStruct struct = MigrationStruct.get(dataObjectKey);
        RefObject hasLoadAll = new RefObject((Object)Boolean.FALSE);
        DataTable changeData = this.dataProcess.loadData(context, struct, (RefObject<Boolean>)hasLoadAll);
        while (changeData != null && !changeData.isEmpty()) {
            this.handleMerge(context, struct, changeData);
            if (((Boolean)hasLoadAll.getValue()).booleanValue()) break;
            changeData = this.dataProcess.loadData(context, struct, (RefObject<Boolean>)hasLoadAll);
        }
        Performance.endActive((int)action, (Object[])actions);
    }

    private void handleMerge(DefaultContext context, MigrationStruct struct, DataTable changeData) throws Throwable {
        int[] rowIndexes = this.dataProcess.mergeData(context, struct, changeData);
        this.batchDelete(context, struct, changeData);
        ArrayList<Integer> batchInsertNewRowIndexes = new ArrayList<Integer>();
        int[] nArray = rowIndexes;
        int n = rowIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int rowIndex = nArray[n2];
            if (!this.updateNewTable(context, struct, changeData, rowIndex)) {
                batchInsertNewRowIndexes.add(rowIndex);
            }
            ++n2;
        }
        this.batchInsertNewTable(context, struct, changeData, batchInsertNewRowIndexes);
    }

    private boolean updateNewTable(DefaultContext context, MigrationStruct struct, DataTable changeData, int rowIndex) throws Throwable {
        RefObject refArgumentColumnIndexInIncr = new RefObject(null);
        String updateSql = struct.getUpateNewSqlFromIncr((RefObject<int[]>)refArgumentColumnIndexInIncr);
        int[] columnIndexes = (int[])refArgumentColumnIndexInIncr.getValue();
        int argumentCount = columnIndexes.length;
        ArrayList<Object> arguments = new ArrayList<Object>(argumentCount);
        int i = 0;
        while (i < argumentCount) {
            arguments.add(changeData.getObject(rowIndex, columnIndexes[i]));
            ++i;
        }
        IDBManager dbm = context.getDBManager();
        int updateCount = dbm.execPrepareUpdate(updateSql, arguments);
        return updateCount == 1;
    }

    private void batchInsertNewTable(DefaultContext context, MigrationStruct struct, DataTable changeData, List<Integer> rowIndexList) throws Throwable {
        if (rowIndexList.size() == 0) {
            return;
        }
        int[] rowIndexes = ArrayUtils.toPrimitive((Integer[])rowIndexList.toArray(new Integer[rowIndexList.size()]));
        RefObject argumentSize = new RefObject((Object)0);
        String insertSql = struct.getInsertNewSql((RefObject<Integer>)argumentSize);
        DataTableBatchPsPara batchPsPara = new DataTableBatchPsPara(insertSql, changeData, rowIndexes, (Integer)argumentSize.getValue());
        context.getDBManager().executeUpdate((BatchPsPara)batchPsPara);
    }

    private void batchDelete(DefaultContext context, MigrationStruct struct, DataTable changeData) throws Throwable {
        boolean oidColumnIndex = false;
        int size = changeData.size();
        Object[] result = new Object[size];
        int i = 0;
        while (i < size) {
            result[i] = changeData.getLong(i, 0);
            ++i;
        }
        String deleteSql = struct.getDeleteIncrSql(result.length);
        context.getDBManager().execPrepareUpdate(deleteSql, result);
    }
}

