/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.migration;

import com.bokesoft.yes.mid.connection.dbmanager.BatchPsPara;
import com.bokesoft.yes.mid.connection.dbmanager.PsPara;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.migration.AbstractRemigrateStrategy;
import com.bokesoft.yes.mid.migration.TableArgs;
import com.bokesoft.yigo.meta.datamigration.MetaDMSourceField;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.ArrayList;

public class InsertFastMySQLStrategy
extends AbstractRemigrateStrategy {
    @Override
    public void batchUpdateData(DefaultContext context, DataTable changeData) throws Throwable {
        ArrayList<MetaColumn> insertOrUpdateColumnList = new ArrayList<MetaColumn>();
        IDBManager dbm = context.getDBManager();
        String insertOrUpdateSQL = this.getInsterMegreSQL(dbm, insertOrUpdateColumnList);
        try (PsPara insertOrUpdatePP = null;){
            insertOrUpdatePP = new PsPara(dbm.preparedUpdateStatement(insertOrUpdateSQL), insertOrUpdateSQL);
            BatchPsPara bpp = new BatchPsPara(insertOrUpdateSQL);
            changeData.beforeFirst();
            while (changeData.next()) {
                TableArgs insertOrUpdateArgs = new TableArgs(changeData, insertOrUpdateColumnList);
                dbm.executeUpdate(insertOrUpdatePP, (QueryArguments)insertOrUpdateArgs);
            }
            dbm.executeUpdate(bpp);
        }
    }

    @Override
    public String getInsterMegreSQL(IDBManager dbm, ArrayList<MetaColumn> insertOrUpdateColumnList) {
        if (this.insterMegreSQL != null) {
            return this.insterMegreSQL;
        }
        MetaTable targetMetaTable = this.migrationParas.getTgtDataObject().getErpMigrationNewTable();
        for (MetaColumn column : targetMetaTable) {
            if (!column.isPersist().booleanValue() || column.getKey().equals("SOID") || column.getKey().equals("MapCount") || !column.isPersist().booleanValue()) continue;
            MetaColumn dataColumn = column;
            if (this.migrationParas.getDataFieldByPeriodEndField(column) != null) {
                dataColumn = this.migrationParas.getDataFieldByPeriodEndField(column);
            }
            insertOrUpdateColumnList.add(dataColumn);
        }
        StringBuilder insertOrUpdateSb = new StringBuilder(this.insertSQL);
        insertOrUpdateSb.append(" on duplicate key update ");
        for (MetaColumn column : this.migrationParas.getDataColumnList()) {
            MetaDMSourceField sourceField;
            if (!column.isPersist().booleanValue() || column.isSystemControlField().booleanValue() || (sourceField = (MetaDMSourceField)this.migrationParas.getFieldMap().get(column.getKey())) == null) continue;
            String fieldKey = dbm.keyWordEscape(column.getBindingDBColumnName());
            insertOrUpdateSb.append(fieldKey);
            if (sourceField.getOpSign() == 2) {
                insertOrUpdateSb.append("=?,");
            } else {
                insertOrUpdateSb.append("=");
                insertOrUpdateSb.append(fieldKey);
                insertOrUpdateSb.append("+?,");
            }
            insertOrUpdateColumnList.add(column);
            if (column.getSplitType() != 0) continue;
            String endFiledKey = dbm.keyWordEscape(this.migrationParas.getPeriodEndColumn(column));
            insertOrUpdateSb.append(endFiledKey);
            insertOrUpdateSb.append("=");
            insertOrUpdateSb.append(endFiledKey);
            insertOrUpdateSb.append("+?,");
            insertOrUpdateColumnList.add(column);
        }
        insertOrUpdateSb.deleteCharAt(insertOrUpdateSb.length() - 1);
        this.insterMegreSQL = insertOrUpdateSb.toString();
        return this.insterMegreSQL;
    }
}

