/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.materializedquery;

import com.bokesoft.yes.common.struct.LinkedHashMapIgnoreCase;
import com.bokesoft.yes.mid.materializedquery.AndExpression;
import com.bokesoft.yes.mid.materializedquery.CompareExpression;
import com.bokesoft.yes.mid.materializedquery.JoinType;
import com.bokesoft.yes.mid.materializedquery.MQJoinStruct;
import com.bokesoft.yes.mid.materializedquery.MaterializedQueryStruct;
import com.bokesoft.yes.mid.materializedquery.WhereExpression;
import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

class MQTableStruct {
    public final String tableName;
    public final MaterializedQueryStruct mqStruct;
    public String tableAliasName;
    public List<String> selectColumns;
    public List<Integer> selectColumnIndexes;
    public List<String> selectFormulas;
    public List<Integer> selectFormulaColumnIndexes;
    public List<MetaColumn> selectFormulaColumnTypes;
    public List<String> selectColumnsForFormula;
    public List<MQJoinStruct> refJoinStructs;
    public List<String> joinColumnsNotInSelectItem;
    public List<Integer> joinColumnExtendColumnIndexes;
    public JoinType joinType;
    public List<MQJoinStruct> andJoinStructs;
    public List<MQJoinStruct> orJoinStructs;
    public WhereExpression whereExpression;
    public int oidColumnIndexInQuery;
    private Object[] emptyValues;
    private String[] joinColumnNames;
    private String[] joinRefColumnNamesInQuery;
    private int[] parentJoinColumnIndexes;

    public MQTableStruct(MaterializedQueryStruct mqStruct, String tableName) throws Throwable {
        this.mqStruct = mqStruct;
        this.tableName = tableName;
    }

    public void addSelectColumn(String columnName, int columnIndex) {
        if (this.selectColumns == null) {
            this.selectColumns = new ArrayList<String>();
            this.selectColumnIndexes = new ArrayList<Integer>();
        }
        for (String tmp : this.selectColumns) {
            if (!tmp.equalsIgnoreCase(columnName)) continue;
            throw new RuntimeException("\u7269\u5316\u67e5\u8be2\u8868\u89e3\u6790\u5931\u8d25\uff0c\u8868" + this.tableName + "\u5b57\u6bb5" + columnName + "\u88ab\u67e5\u8be2\u4e24\u6b21\u3002");
        }
        this.selectColumns.add(columnName);
        this.selectColumnIndexes.add(columnIndex);
    }

    public void addSelectFormula(String formula, int columnIndex, MetaColumn metaColumn) {
        if (this.selectFormulas == null) {
            this.selectFormulas = new ArrayList<String>();
            this.selectFormulaColumnIndexes = new ArrayList<Integer>();
            this.selectFormulaColumnTypes = new ArrayList<MetaColumn>();
        }
        this.selectFormulas.add(formula);
        this.selectFormulaColumnIndexes.add(columnIndex);
        this.selectFormulaColumnTypes.add(metaColumn);
    }

    public boolean hasColumn(String columnName) throws Throwable {
        return DataObjects.getInstance().getColumnsByTableName(this.tableName).containsKey(columnName);
    }

    public void addSelectColumnForFormula(String columnName) {
        if (this.selectColumnsForFormula == null) {
            this.selectColumnsForFormula = new ArrayList<String>();
        }
        for (String tmp : this.selectColumnsForFormula) {
            if (!tmp.equalsIgnoreCase(columnName)) continue;
            return;
        }
        this.selectColumnsForFormula.add(columnName);
    }

    public void addJoinColumnsNotInSelectItem(String columnNameInSelect, int columnIndex) {
        if (this.joinColumnsNotInSelectItem == null) {
            this.joinColumnsNotInSelectItem = new ArrayList<String>();
            this.joinColumnExtendColumnIndexes = new ArrayList<Integer>();
        }
        this.joinColumnsNotInSelectItem.add(columnNameInSelect);
        this.joinColumnExtendColumnIndexes.add(columnIndex);
    }

    public int getColumnIndex(String columnName) {
        int size;
        int i;
        int result = -1;
        if (this.selectColumns != null) {
            i = 0;
            size = this.selectColumns.size();
            while (i < size) {
                if (this.selectColumns.get(i).equalsIgnoreCase(columnName)) {
                    result = this.selectColumnIndexes.get(i);
                    break;
                }
                ++i;
            }
        }
        if (result == -1 && this.joinColumnsNotInSelectItem != null) {
            i = 0;
            size = this.joinColumnsNotInSelectItem.size();
            while (i < size) {
                if (this.joinColumnsNotInSelectItem.get(i).equalsIgnoreCase(columnName)) {
                    result = this.joinColumnExtendColumnIndexes.get(i);
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public void addAndJoinStruct(MQJoinStruct joinStruct) {
        if (this.orJoinStructs != null) {
            throw new RuntimeException("\u7269\u5316\u67e5\u8be2\u8868\u89e3\u6790\u5931\u8d25\uff0cJoin\u7684\u6761\u4ef6\u4e0d\u652f\u6301and\u548cor\u6df7\u7528\u3002");
        }
        if (this.andJoinStructs == null) {
            this.andJoinStructs = new ArrayList<MQJoinStruct>();
        }
        this.andJoinStructs.add(joinStruct);
    }

    public void addOrJoinStruct(MQJoinStruct joinStruct) {
        if (this.andJoinStructs != null) {
            throw new RuntimeException("\u7269\u5316\u67e5\u8be2\u8868\u89e3\u6790\u5931\u8d25\uff0cJoin\u7684\u6761\u4ef6\u4e0d\u652f\u6301and\u548cor\u6df7\u7528\u3002");
        }
        if (this.orJoinStructs == null) {
            this.orJoinStructs = new ArrayList<MQJoinStruct>();
        }
        this.orJoinStructs.add(joinStruct);
    }

    public void addRefJoinStruct(MQJoinStruct joinStruct) {
        if (this.refJoinStructs == null) {
            this.refJoinStructs = new ArrayList<MQJoinStruct>();
        }
        this.refJoinStructs.add(joinStruct);
    }

    public void addExpression(String columnName, int binaryOp, Object constantValue) throws Throwable {
        MetaColumn metaColumn = (MetaColumn)DataObjects.getInstance().getColumnsByTableName(this.tableName).get(columnName);
        this.whereExpression = this.whereExpression == null ? new CompareExpression(metaColumn, constantValue, binaryOp) : new AndExpression(this.whereExpression, new CompareExpression(metaColumn, constantValue, binaryOp));
    }

    public Object[] getEmptyValues() throws Throwable {
        if (this.emptyValues == null) {
            int columnIndex;
            int size;
            int i;
            Object[] tmp = new Object[this.mqStruct.columnNames.length];
            LinkedHashMapIgnoreCase<MetaColumn> columns = DataObjects.getInstance().getColumnsByTableName(this.tableName);
            if (this.selectColumns != null) {
                i = 0;
                size = this.selectColumns.size();
                while (i < size) {
                    columnIndex = this.selectColumnIndexes.get(i);
                    tmp[columnIndex] = MQTableStruct.getEmptyValue((MetaColumn)columns.get(this.selectColumns.get(i)));
                    ++i;
                }
            }
            if (this.selectFormulas != null) {
                i = 0;
                size = this.selectFormulas.size();
                while (i < size) {
                    columnIndex = this.selectFormulaColumnIndexes.get(i);
                    tmp[columnIndex] = MQTableStruct.getEmptyValue(this.selectFormulaColumnTypes.get(i));
                    ++i;
                }
            }
            if (this.joinColumnsNotInSelectItem != null) {
                i = 0;
                size = this.joinColumnsNotInSelectItem.size();
                while (i < size) {
                    columnIndex = this.joinColumnExtendColumnIndexes.get(i);
                    tmp[columnIndex] = MQTableStruct.getEmptyValue((MetaColumn)columns.get(this.joinColumnsNotInSelectItem.get(i)));
                    ++i;
                }
            }
            this.emptyValues = tmp;
        }
        return this.emptyValues;
    }

    public static Object getEmptyValue(MetaColumn metaColumn) {
        switch (metaColumn.getDataType()) {
            case 1001: {
                return 0;
            }
            case 1010: {
                return 0L;
            }
            case 1005: {
                return 0;
            }
            case 1002: {
                return "_";
            }
        }
        throw new RuntimeException("\u7269\u5316\u67e5\u8be2\u8868\u4e0d\u652f\u6301\u7684\u7c7b\u578b" + DataType.toString((Integer)metaColumn.getDataType()) + "\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\uff01");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        if (this.joinType != null) {
            sb.append((Object)this.joinType);
        }
        sb.append("select ");
        if (this.selectColumns != null) {
            for (String selectColumn : this.selectColumns) {
                sb.append(selectColumn).append(",");
            }
        }
        if (this.selectFormulas != null) {
            for (String selectFormula : this.selectFormulas) {
                sb.append(selectFormula).append(",");
            }
        }
        if (this.joinColumnsNotInSelectItem != null) {
            int i = 0;
            int size = this.joinColumnsNotInSelectItem.size();
            while (i < size) {
                sb.append("[").append(this.joinColumnsNotInSelectItem.get(i)).append("],");
                ++i;
            }
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" from ").append(this.tableName);
        if (this.joinType != null) {
            if (this.andJoinStructs != null && this.andJoinStructs.size() > 0) {
                sb.append(" on ").append(this.andJoinStructs.get(0));
                int i = 1;
                int size = this.andJoinStructs.size();
                while (i < size) {
                    sb.append(" and ").append(this.andJoinStructs.get(i));
                    ++i;
                }
            } else if (this.orJoinStructs != null && this.orJoinStructs.size() > 0) {
                sb.append(" on ").append(this.orJoinStructs.get(0));
                int i = 1;
                int size = this.orJoinStructs.size();
                while (i < size) {
                    sb.append(" or ").append(this.orJoinStructs.get(i));
                    ++i;
                }
            }
        }
        if (this.whereExpression != null) {
            sb.append(" where ").append(this.whereExpression.toString());
        }
        return sb.toString();
    }

    public String[] getJoinColumnNames() {
        if (this.joinColumnNames == null) {
            int size;
            int n = size = this.andJoinStructs == null ? 0 : this.andJoinStructs.size();
            if (size == 0) {
                this.joinColumnNames = ArrayUtils.EMPTY_STRING_ARRAY;
            } else {
                String[] tmp = new String[size];
                int i = 0;
                while (i < size) {
                    tmp[i] = this.andJoinStructs.get((int)i).columnName;
                    ++i;
                }
                this.joinColumnNames = tmp;
            }
        }
        return this.joinColumnNames;
    }

    public String[] getJoinRefColumnNamesInQuery() {
        if (this.joinRefColumnNamesInQuery == null) {
            int size;
            int n = size = this.andJoinStructs == null ? 0 : this.andJoinStructs.size();
            if (size == 0) {
                this.joinRefColumnNamesInQuery = ArrayUtils.EMPTY_STRING_ARRAY;
            } else {
                String[] tmp = new String[size];
                int i = 0;
                while (i < size) {
                    MQJoinStruct joinStruct = this.andJoinStructs.get(i);
                    MQTableStruct refTableStruct = this.mqStruct.getTableStruct(joinStruct.joinTableName);
                    String refColumnName = joinStruct.joinColumnName;
                    int index = refTableStruct.getColumnIndexInQuery(refColumnName);
                    tmp[i] = this.mqStruct.columnNames[index];
                    ++i;
                }
                this.joinRefColumnNamesInQuery = tmp;
            }
        }
        return this.joinRefColumnNamesInQuery;
    }

    private int getColumnIndexInQuery(String columnName) {
        int index;
        if (columnName.equalsIgnoreCase("OID")) {
            return this.oidColumnIndexInQuery;
        }
        if (this.selectColumns != null && (index = MQTableStruct.containsIngoreCase(this.selectColumns, columnName)) >= 0) {
            return this.selectColumnIndexes.get(index);
        }
        index = MQTableStruct.containsIngoreCase(this.joinColumnsNotInSelectItem, columnName);
        return this.joinColumnExtendColumnIndexes.get(index);
    }

    private static int containsIngoreCase(List<String> stringList, String findString) {
        int i = 0;
        int size = stringList.size();
        while (i < size) {
            if (findString.equalsIgnoreCase(stringList.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int[] getParentJoinColumnIndexes() {
        if (this.parentJoinColumnIndexes == null) {
            ArrayList<Integer> tmp = new ArrayList<Integer>();
            int tableIndex = 0;
            MQTableStruct parentTableStruct = this.mqStruct.tables[tableIndex];
            while (true) {
                String[] joinColumnNames;
                String[] stringArray = joinColumnNames = parentTableStruct.getJoinColumnNames();
                int n = joinColumnNames.length;
                int n2 = 0;
                while (n2 < n) {
                    int index;
                    String joinColumnName = stringArray[n2];
                    if (this.selectColumns != null && (index = MQTableStruct.containsIngoreCase(this.selectColumns, joinColumnName)) >= 0) {
                        tmp.add(this.selectColumnIndexes.get(index));
                    } else {
                        index = MQTableStruct.containsIngoreCase(this.joinColumnsNotInSelectItem, joinColumnName);
                        tmp.add(this.joinColumnExtendColumnIndexes.get(index));
                    }
                    ++n2;
                }
                if (parentTableStruct == this) break;
                ++tableIndex;
            }
            this.parentJoinColumnIndexes = ArrayUtils.toPrimitive((Integer[])tmp.toArray(new Integer[tmp.size()]));
        }
        return this.parentJoinColumnIndexes;
    }

    public String getLoadByJoinSql(int length) throws Throwable {
        StringBuilder sb = new StringBuilder(1024);
        sb.append(this.mqStruct.getLoadSql());
        sb.append(" where ");
        String[] joinRefColumnNamesInQuery = this.getJoinRefColumnNamesInQuery();
        if (joinRefColumnNamesInQuery.length == 1) {
            sb.append(joinRefColumnNamesInQuery[0]);
        } else {
            sb.append("(");
            String[] stringArray = joinRefColumnNamesInQuery;
            int n = joinRefColumnNamesInQuery.length;
            int n2 = 0;
            while (n2 < n) {
                String joinColumnName = stringArray[n2];
                sb.append(joinColumnName).append(",");
                ++n2;
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")");
        }
        sb.append(" in ");
        if (length > 1) {
            sb.append("(");
        }
        int argumentCount = joinRefColumnNamesInQuery.length;
        int i = 0;
        while (i < length) {
            sb.append("(?");
            int j = 1;
            while (j < argumentCount) {
                sb.append(",?");
                ++j;
            }
            sb.append("),");
            ++i;
        }
        sb.deleteCharAt(sb.length() - 1);
        if (length > 1) {
            sb.append(")");
        }
        return sb.toString();
    }

    public String getLoadByOIDSql(int size) throws Throwable {
        StringBuilder sb = new StringBuilder(1024);
        sb.append(this.mqStruct.getLoadSql());
        sb.append(" where ").append(this.mqStruct.columnNames[this.oidColumnIndexInQuery]);
        sb.append(" in (?");
        int i = 1;
        while (i < size) {
            sb.append(",?");
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }
}

