/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.materializedquery;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.materializedquery.WhereExpression;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yes.util.VarUtil;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

class CompareExpression
extends WhereExpression {
    protected Object Data;
    protected int Operationid;
    protected MetaColumn metaColumn;

    public CompareExpression(MetaColumn metaColumn, Object data, int operationid) {
        this.Data = data;
        this.Operationid = operationid;
        this.metaColumn = metaColumn;
    }

    public CompareExpression(MetaColumn metaColumn, Object data) {
        this(metaColumn, data, 2);
    }

    @Override
    public SqlString toSQL(boolean tableNamePrefix) throws Throwable {
        SqlString sb = new SqlString(64);
        this.toSQL(sb, tableNamePrefix);
        return sb;
    }

    @Override
    public SqlString toSQL(SqlString sb, boolean tableNamePrefix) throws Throwable {
        String columnNamePrefix = "";
        if (tableNamePrefix) {
            MetaTable metaTable = this.metaColumn.getTable();
            columnNamePrefix = String.valueOf(metaTable.getBindingDBTableName()) + ".";
        }
        int dataType = this.metaColumn.getDataType();
        if (this.Operationid == 8) {
            sb.append(columnNamePrefix);
            sb.append(this.metaColumn.getBindingDBColumnName());
            sb.append(" in (");
            if (dataType == 1002 && this.Data instanceof String[]) {
                String[] strArray = (String[])this.Data;
                int size = strArray.length;
                int i = 0;
                while (i < size) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.appendPara(strArray[i]);
                    ++i;
                }
            } else if (dataType == 1001 && (this.Data instanceof int[] || this.Data instanceof Integer[])) {
                int[] intArray = this.Data instanceof Integer[] ? ArrayUtils.toPrimitive((Integer[])((Integer[])this.Data)) : (int[])this.Data;
                int size = intArray.length;
                int i = 0;
                while (i < size) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.appendPara(intArray[i]);
                    ++i;
                }
            } else if (dataType == 1010 && this.Data instanceof Long[]) {
                Long[] longArray = (Long[])this.Data;
                int size = longArray.length;
                int i = 0;
                while (i < size) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.appendPara(longArray[i]);
                    ++i;
                }
            } else if (dataType == 1005 && this.Data instanceof BigDecimal[]) {
                BigDecimal[] decArray = (BigDecimal[])this.Data;
                int size = decArray.length;
                int i = 0;
                while (i < size) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.appendPara(decArray[i]);
                    ++i;
                }
            } else {
                throw new RuntimeException("\u7c7b\u578b'" + DataType.toString((Integer)dataType) + "'\u548c\u503c" + this.Data + "\u7ec4\u5408\u8fd8\u4e0d\u652f\u6301,\u8bf7\u4fee\u6539\u4ee3\u7801.");
            }
            sb.append(")");
        } else {
            sb.append("(").append(columnNamePrefix).append(this.metaColumn.getBindingDBColumnName());
            sb.append(CompareExpression.getOperatorString(this.Operationid));
            if (dataType == 1001) {
                int Data = TypeConvertor.toInteger((Object)this.Data);
                sb.appendPara(Data);
            } else if (dataType == 1010) {
                Long Data = TypeConvertor.toLong((Object)this.Data);
                sb.appendPara(Data);
            } else if (dataType == 1002) {
                String Data = TypeConvertor.toString((Object)this.Data);
                sb.appendPara(Data);
                if (StringUtil.isBlankOrNull((String)Data)) {
                    if (this.Operationid == 2) {
                        sb.append(" or ").append(columnNamePrefix).append(this.metaColumn.getBindingDBColumnName()).append(" is null");
                    } else if (this.Operationid == 5) {
                        sb.append(" or ").append(columnNamePrefix).append(this.metaColumn.getBindingDBColumnName()).append(" is not null");
                    }
                }
            } else if (dataType == 1005) {
                BigDecimal Data = TypeConvertor.toBigDecimal((Object)this.Data);
                sb.appendPara(Data);
            } else {
                throw new Exception("\u76ee\u524d\u4e0d\u652f\u6301\u8fd9\u4e2a\u7c7b\u578b" + DataType.toString((Integer)dataType) + ",\u8bf7\u4fee\u6539\u76f8\u5173\u4ee3\u7801.");
            }
            sb.append(")");
        }
        return sb;
    }

    @Override
    public List<MetaTable> getMetaTables() {
        MetaTable metaTable = this.metaColumn.getTable();
        ArrayList<MetaTable> metaTables = new ArrayList<MetaTable>();
        metaTables.add(metaTable);
        return metaTables;
    }

    @Override
    public HashMap<String, MetaColumn> getMetaColumns() {
        HashMap<String, MetaColumn> metaColumns = new HashMap<String, MetaColumn>();
        metaColumns.put(this.metaColumn.getKey(), this.metaColumn);
        return metaColumns;
    }

    @Override
    boolean isMatch(DataTable dataTable, int rowIndex, boolean isOriginal) throws Throwable {
        String columnName = this.metaColumn.getBindingDBColumnName();
        Object tableEntityValue = isOriginal ? dataTable.getOriginalObject(rowIndex, columnName) : dataTable.getObject(rowIndex, columnName);
        boolean b = true;
        switch (this.Operationid) {
            case 2: {
                b = VarUtil.compare(tableEntityValue, this.Data) == 0;
                break;
            }
            case 3: {
                b = VarUtil.compare(tableEntityValue, this.Data) <= 0;
                break;
            }
            case 4: {
                b = VarUtil.compare(tableEntityValue, this.Data) > 0;
                break;
            }
            case 5: {
                b = VarUtil.compare(tableEntityValue, this.Data) != 0;
                break;
            }
            case 6: {
                b = VarUtil.compare(tableEntityValue, this.Data) < 0;
                break;
            }
            case 1: {
                b = VarUtil.compare(tableEntityValue, this.Data) >= 0;
                break;
            }
            case 8: {
                if (this.Data instanceof int[] && tableEntityValue instanceof Integer) {
                    b = ArrayUtils.contains((int[])((int[])this.Data), (int)((Integer)tableEntityValue));
                    break;
                }
                if (this.Data instanceof Integer[] && tableEntityValue instanceof Integer) {
                    b = ArrayUtils.contains((Object[])((Integer[])this.Data), (Object)((Integer)tableEntityValue));
                    break;
                }
                if (this.Data instanceof String[] && tableEntityValue instanceof String) {
                    b = ArrayUtils.contains((Object[])((String[])this.Data), (Object)((String)tableEntityValue));
                    break;
                }
                if (this.Data instanceof BigDecimal[] && tableEntityValue instanceof BigDecimal) {
                    b = ArrayUtils.contains((Object[])((BigDecimal[])this.Data), (Object)((BigDecimal)tableEntityValue));
                    break;
                }
                throw new Exception("\u6570\u7ec4\u6570\u636e'" + this.Data + "'\u548c\u503c" + tableEntityValue + "\u65e0\u6cd5\u6bd4\u8f83,\u8bf7\u4fee\u6539\u4ee3\u7801.");
            }
            default: {
                throw new Exception("\u76ee\u524d\u4e0d\u652f\u6301\u8fd9\u4e2a\u64cd\u4f5c\u7b26" + this.Operationid + ".");
            }
        }
        return b;
    }

    @Override
    boolean isSame(WhereExpression whereExpression) {
        if (whereExpression instanceof CompareExpression) {
            CompareExpression tmp = (CompareExpression)whereExpression;
            return this.Operationid == tmp.Operationid && this.metaColumn.getBindingDBColumnName().equalsIgnoreCase(tmp.metaColumn.getBindingDBColumnName()) && this.isSame(this.Data, tmp.Data);
        }
        return false;
    }

    private boolean isSame(Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (obj1 instanceof Integer) {
            return obj2 instanceof Integer && obj1.equals(obj2);
        }
        if (obj1 instanceof Long) {
            return obj2 instanceof Long && obj1.equals(obj2);
        }
        if (obj1 instanceof String) {
            return obj2 instanceof String && obj1.equals(obj2);
        }
        if (obj1 instanceof BigDecimal) {
            return obj2 instanceof BigDecimal && obj1.equals(obj2);
        }
        if (obj1 instanceof int[] || obj1 instanceof Integer[]) {
            if (obj2 instanceof int[] || obj2 instanceof Integer[]) {
                int[] intArray2;
                int[] intArray1 = obj1 instanceof int[] ? (int[])obj1 : ArrayUtils.toPrimitive((Integer[])((Integer[])obj1));
                int[] nArray = intArray2 = obj2 instanceof int[] ? (int[])obj2 : ArrayUtils.toPrimitive((Integer[])((Integer[])obj2));
                if (intArray1.length != intArray2.length) {
                    return false;
                }
                int[] nArray2 = intArray1;
                int n = intArray1.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray2[n2];
                    if (!ArrayUtils.contains((int[])intArray2, (int)i)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        } else if (obj1 instanceof long[] || obj1 instanceof Long[]) {
            if (obj2 instanceof long[] || obj2 instanceof Long[]) {
                long[] intArray2;
                long[] intArray1 = obj1 instanceof long[] ? (long[])obj1 : ArrayUtils.toPrimitive((Long[])((Long[])obj1));
                long[] lArray = intArray2 = obj2 instanceof long[] ? (long[])obj2 : ArrayUtils.toPrimitive((Long[])((Long[])obj2));
                if (intArray1.length != intArray2.length) {
                    return false;
                }
                long[] lArray2 = intArray1;
                int n = intArray1.length;
                int n3 = 0;
                while (n3 < n) {
                    long i = lArray2[n3];
                    if (!ArrayUtils.contains((long[])intArray2, (long)i)) {
                        return false;
                    }
                    ++n3;
                }
                return true;
            }
        } else if (obj1 instanceof String[] && obj2 instanceof String[]) {
            String[] strArray1 = (String[])obj1;
            Object[] strArray2 = (String[])obj2;
            if (strArray1.length != strArray2.length) {
                return false;
            }
            String[] stringArray = strArray1;
            int n = strArray1.length;
            int n4 = 0;
            while (n4 < n) {
                String str = stringArray[n4];
                if (!ArrayUtils.contains((Object[])strArray2, (Object)str)) {
                    return false;
                }
                ++n4;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMetaColumnWhereClause(MetaColumn metaColumn) {
        return this.metaColumn.compareTo((KeyPairMetaObject)metaColumn) == 0;
    }

    @Override
    public Object getMetaColumnValue(MetaColumn metaColumn) {
        if (this.metaColumn.compareTo((KeyPairMetaObject)metaColumn) == 0) {
            return this.Data;
        }
        return null;
    }

    @Override
    public MetaColumn getMetaColumn() {
        return this.metaColumn;
    }
}

