/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dbcache.datatable;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.TypesStr;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.MidCoreException;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class GroupByUtil {
    private static Object convert(Object value, int dataType, int JDBCDataType) throws Throwable {
        if (value != null) {
            switch (dataType) {
                case 1008: {
                    switch (JDBCDataType) {
                        case -4: 
                        case -3: 
                        case -2: {
                            return (byte[])value;
                        }
                        case 2004: {
                            Blob blob = (Blob)value;
                            return blob.getBytes(1L, (int)blob.length());
                        }
                        case 2005: 
                        case 2011: {
                            Clob clob = (Clob)value;
                            return clob.getSubString(1L, (int)clob.length()).getBytes();
                        }
                    }
                    throw new MidCoreException(8, "\u503c " + value + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)JDBCDataType) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)dataType));
                }
                case 1009: {
                    switch (JDBCDataType) {
                        case 4: {
                            if ((Integer)value == 1) {
                                return true;
                            }
                            return false;
                        }
                        case 2: {
                            if (((BigDecimal)value).intValue() == 1) {
                                return true;
                            }
                            return false;
                        }
                    }
                    throw new MidCoreException(8, "\u503c " + value + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)JDBCDataType) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)dataType));
                }
                case 1003: 
                case 1004: 
                case 1101: {
                    switch (JDBCDataType) {
                        case 91: {
                            return TypeConvertor.toDate((Object)value);
                        }
                        case 92: 
                        case 2013: {
                            return new java.sql.Date(((Time)value).getTime());
                        }
                        case 93: 
                        case 2014: {
                            if (value instanceof Date) {
                                return value;
                            }
                            return new java.sql.Date(((Timestamp)value).getTime());
                        }
                    }
                    throw new MidCoreException(8, "\u503c " + value + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)JDBCDataType) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)dataType));
                }
                case 1005: 
                case 1006: 
                case 1007: {
                    switch (JDBCDataType) {
                        case 2: 
                        case 3: {
                            return (BigDecimal)value;
                        }
                        case 8: {
                            return new BigDecimal((Double)value);
                        }
                        case 6: {
                            return new BigDecimal(((Float)value).floatValue());
                        }
                        case 4: {
                            return new BigDecimal((Integer)value);
                        }
                        case -5: {
                            return new BigDecimal((Long)value);
                        }
                    }
                    throw new MidCoreException(8, "\u503c " + value + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)JDBCDataType) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)dataType));
                }
                case 1001: {
                    switch (JDBCDataType) {
                        case 4: {
                            return (Integer)value;
                        }
                        case -5: {
                            return ((Long)value).intValue();
                        }
                        case 2: 
                        case 3: {
                            return ((BigDecimal)value).intValue();
                        }
                    }
                    throw new MidCoreException(8, "\u503c " + value + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)JDBCDataType) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)dataType));
                }
                case 1010: {
                    switch (JDBCDataType) {
                        case 4: {
                            return ((Integer)value).longValue();
                        }
                        case -5: {
                            if (value instanceof BigInteger) {
                                return ((BigInteger)value).longValue();
                            }
                            if (value instanceof Integer) {
                                return ((Integer)value).longValue();
                            }
                            return (Long)value;
                        }
                        case 2: 
                        case 3: {
                            return ((BigDecimal)value).longValue();
                        }
                        case -9: 
                        case 12: {
                            return Long.parseLong((String)value);
                        }
                    }
                    throw new MidCoreException(8, "\u503c " + value + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)JDBCDataType) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)dataType));
                }
                case 1002: 
                case 1012: {
                    if ("  ".equals(value)) {
                        return "";
                    }
                    return value.toString();
                }
                case 1011: {
                    switch (JDBCDataType) {
                        case 2005: 
                        case 2011: {
                            if (value instanceof String) {
                                return value;
                            }
                            Clob clob = (Clob)value;
                            return GroupByUtil.ClobtoString(clob);
                        }
                        case 2004: {
                            Blob blob = (Blob)value;
                            return new String(blob.getBytes(1L, (int)blob.length()));
                        }
                        case -9: 
                        case -1: 
                        case 12: {
                            if ("  ".equals(value)) {
                                return "";
                            }
                            return (String)value;
                        }
                        case -4: {
                            return new String((byte[])value, "UTF-8");
                        }
                    }
                    throw new MidCoreException(8, "\u503c " + value + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)JDBCDataType) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)dataType));
                }
            }
            throw new MidCoreException(7, " \u4e0d\u652f\u6301\u7684JDBC\u6570\u636e\u7c7b\u578b");
        }
        return null;
    }

    private static String ClobtoString(Clob clob) throws Throwable {
        if (clob == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Reader inStreamDoc = clob.getCharacterStream();){
                char[] resDoc = new char[(int)clob.length()];
                inStreamDoc.read(resDoc);
                return new String(resDoc);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

