/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dbcache.datatable;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.mysqls.resultset.DataTableResultSet;
import com.bokesoft.yes.struct.datatable.Row;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.util.DBManagerUtil;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class DataTableExUtil {
    private static Field field_DataTable_metaData;
    private static Field field_DataTable_ViewDataList;
    private static Field field_DataTable_AllDataList;
    private static Field field_DataTable_BookmarkMap;
    private static Field field_DataTable_Pos;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static DataTable newDataTable(DataTableMetaData metaData) throws Throwable {
        if (field_DataTable_metaData == null) {
            Class<DataTableExUtil> clazz = DataTableExUtil.class;
            // MONITORENTER : com.bokesoft.yes.mid.dbcache.datatable.DataTableExUtil.class
            if (field_DataTable_metaData == null) {
                field_DataTable_metaData = DataTable.class.getDeclaredField("metaData");
                field_DataTable_metaData.setAccessible(true);
            }
            // MONITOREXIT : clazz
        }
        DataTable result = new DataTable();
        field_DataTable_metaData.set(result, metaData);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Field getFieldViewDataList() throws Throwable {
        if (field_DataTable_ViewDataList != null) return field_DataTable_ViewDataList;
        Class<DataTableExUtil> clazz = DataTableExUtil.class;
        synchronized (DataTableExUtil.class) {
            if (field_DataTable_ViewDataList != null) return field_DataTable_ViewDataList;
            field_DataTable_ViewDataList = DataTable.class.getDeclaredField("viewDataList");
            field_DataTable_ViewDataList.setAccessible(true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return field_DataTable_ViewDataList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Field getFieldAllDataList() throws Throwable {
        if (field_DataTable_AllDataList != null) return field_DataTable_AllDataList;
        Class<DataTableExUtil> clazz = DataTableExUtil.class;
        synchronized (DataTableExUtil.class) {
            if (field_DataTable_AllDataList != null) return field_DataTable_AllDataList;
            field_DataTable_AllDataList = DataTable.class.getDeclaredField("allDataList");
            field_DataTable_AllDataList.setAccessible(true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return field_DataTable_AllDataList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Field getFieldBookmarkMap() throws Throwable {
        if (field_DataTable_BookmarkMap != null) return field_DataTable_BookmarkMap;
        Class<DataTableExUtil> clazz = DataTableExUtil.class;
        synchronized (DataTableExUtil.class) {
            if (field_DataTable_BookmarkMap != null) return field_DataTable_BookmarkMap;
            field_DataTable_BookmarkMap = DataTable.class.getDeclaredField("bookmarkMap");
            field_DataTable_BookmarkMap.setAccessible(true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return field_DataTable_BookmarkMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Field getFieldPos() throws Throwable {
        if (field_DataTable_Pos != null) return field_DataTable_Pos;
        Class<DataTableExUtil> clazz = DataTableExUtil.class;
        synchronized (DataTableExUtil.class) {
            if (field_DataTable_Pos != null) return field_DataTable_Pos;
            field_DataTable_Pos = DataTable.class.getDeclaredField("pos");
            field_DataTable_Pos.setAccessible(true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return field_DataTable_Pos;
        }
    }

    public static Row getFirstRow(DataTable dataTable) throws Throwable {
        ArrayList viewDataList = (ArrayList)DataTableExUtil.getFieldViewDataList().get(dataTable);
        if (viewDataList.size() < 1) {
            throw new RuntimeException("\u6570\u636e\u4e2d\u8bb0\u5f55\u4e0d\u8db31\u6761\uff0cgetFirstRow()\u5931\u8d25\u3002");
        }
        return (Row)viewDataList.get(0);
    }

    public static ArrayList<Row> getAllDataList(DataTable dataTable) throws Throwable {
        return (ArrayList)DataTableExUtil.getFieldAllDataList().get(dataTable);
    }

    private static ArrayList<Row> getViewDataList(DataTable dataTable) throws Throwable {
        return (ArrayList)DataTableExUtil.getFieldViewDataList().get(dataTable);
    }

    public static HashMap<Integer, Integer> getBookmarkMap(DataTable dataTable) throws Throwable {
        return (HashMap)DataTableExUtil.getFieldBookmarkMap().get(dataTable);
    }

    public static Row getRowByBookmark(DataTable dataTable, int bookmark) throws Throwable {
        Integer rowIndex = DataTableExUtil.getBookmarkMap(dataTable).get(bookmark);
        if (rowIndex == null) {
            ArrayList<Row> allDataList = DataTableExUtil.getAllDataList(dataTable);
            for (Row row : allDataList) {
                if (row.getBookmark() != bookmark) continue;
                if (!row.isDeleted()) {
                    throw new RuntimeException("\u975e\u5220\u9664\u884c\u65e0\u6cd5\u5b9a\u4f4d\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u3002");
                }
                return row;
            }
            throw new RuntimeException("\u65e0\u6cd5\u5b9a\u4f4d\u884c\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u3002");
        }
        return dataTable.getRowByIndex(rowIndex.intValue());
    }

    public static Row getRowByIndex(DataTable dataTable, int rowIndex) {
        return dataTable.getRowByIndex(rowIndex);
    }

    public static int getRowIndexByBookmark(DataTable dataTable, int bookmark) throws Throwable {
        return dataTable.getRowIndexByBookmark(bookmark);
    }

    public static boolean containsBookMark(DataTable dataTable, int bookMark) throws Throwable {
        return DataTableExUtil.getBookmarkMap(dataTable).containsKey(bookMark);
    }

    public static int appendRow(IDBManager dbManager, int oldBookMark, Long oid, int[] columnIndexes, DataTable tgtDataTable, ResultSet srcResultSet, int[] ignoreQueryColumnIndexes) throws Throwable {
        DataTableMetaData tagMetaData = tgtDataTable.getMetaData();
        ResultSetMetaData srcMetaData = srcResultSet.getMetaData();
        if (oldBookMark >= 0) {
            Row row = DataTableExUtil.getRowByBookmark(tgtDataTable, oldBookMark);
            Object[] dataList = row.getDataList();
            boolean oldStateIsModified = row.getState() == 2;
            int j = 0;
            int size = columnIndexes.length;
            while (j < size) {
                int tmp = columnIndexes[j];
                if (tmp >= 0 && !oldStateIsModified) {
                    Object value = srcResultSet.getObject(j + 1);
                    int dataType = tagMetaData.getColumnInfo(tmp).getDataType();
                    value = DataTableExUtil.convertOneBlankToEmpty(dataType, value);
                    if (DBManagerUtil.isNeedConvert((IDBManager)dbManager, (int)dataType)) {
                        int columnType = srcMetaData.getColumnType(j + 1);
                        value = dbManager.convert(value, dataType, columnType);
                    }
                    dataList[tmp] = value;
                }
                ++j;
            }
            row.updateIndex();
            return oldBookMark;
        }
        Row row = DataTableExUtil.appendDataTable(tgtDataTable);
        row.setState(0);
        Object[] dataList = row.getDataList();
        int i = 0;
        int size = columnIndexes.length;
        while (i < size) {
            int tmp = columnIndexes[i];
            if (tmp >= 0) {
                Object value = srcResultSet.getObject(i + 1);
                int dataType = tagMetaData.getColumnInfo(tmp).getDataType();
                value = DataTableExUtil.convertOneBlankToEmpty(dataType, value);
                if (DBManagerUtil.isNeedConvert((IDBManager)dbManager, (int)dataType)) {
                    int columnType = srcMetaData.getColumnType(i + 1);
                    value = dbManager.convert(value, dataType, columnType);
                }
                dataList[tmp] = value;
            }
            ++i;
        }
        int bookmark = row.getBookmark();
        return bookmark;
    }

    public static int appendPreLoadRow(IDBManager dbManager, int oldBookMark, DataTable tgtDataTable, ResultSet srcResultSet) throws Throwable {
        if (srcResultSet instanceof DataTableResultSet) {
            return DataTableExUtil.appendPreLoadRow(dbManager, oldBookMark, tgtDataTable, (DataTableResultSet)srcResultSet);
        }
        DataTableMetaData tagMetaData = tgtDataTable.getMetaData();
        ResultSetMetaData srcMetaData = srcResultSet.getMetaData();
        if (oldBookMark >= 0) {
            Row row = DataTableExUtil.getRowByBookmark(tgtDataTable, oldBookMark);
            Object[] dataList = row.getDataList();
            boolean oldStateIsModified = row.getState() == 2;
            int j = 0;
            int size = srcMetaData.getColumnCount();
            while (j < size) {
                if (!oldStateIsModified) {
                    Object value = srcResultSet.getObject(j + 1);
                    int dataType = tagMetaData.getColumnInfo(j).getDataType();
                    value = DataTableExUtil.convertOneBlankToEmpty(dataType, value);
                    if (DBManagerUtil.isNeedConvert((IDBManager)dbManager, (int)dataType)) {
                        int columnType = srcMetaData.getColumnType(j + 1);
                        value = dbManager.convert(value, dataType, columnType);
                        if (dataType == 1005 && value != null && value instanceof BigDecimal) {
                            int scale = tagMetaData.getColumnInfo(j).getScale();
                            value = TypeConvertor.toBigDecimal((Object)value, (Integer)scale);
                        }
                    }
                    dataList[j] = value;
                }
                ++j;
            }
            row.updateIndex();
            return oldBookMark;
        }
        Row row = DataTableExUtil.appendDataTable(tgtDataTable);
        row.setState(0);
        Object[] dataList = row.getDataList();
        int i = 0;
        int size = srcMetaData.getColumnCount();
        while (i < size) {
            Object value = srcResultSet.getObject(i + 1);
            int dataType = tagMetaData.getColumnInfo(i).getDataType();
            value = DataTableExUtil.convertOneBlankToEmpty(dataType, value);
            if (DBManagerUtil.isNeedConvert((IDBManager)dbManager, (int)dataType)) {
                int columnType = srcMetaData.getColumnType(i + 1);
                value = dbManager.convert(value, dataType, columnType);
                if (dataType == 1005 && value != null && value instanceof BigDecimal) {
                    int scale = tagMetaData.getColumnInfo(i).getScale();
                    value = TypeConvertor.toBigDecimal((Object)value, (Integer)scale);
                }
            }
            dataList[i] = value;
            ++i;
        }
        row.updateIndex();
        int bookmark = row.getBookmark();
        return bookmark;
    }

    public static int appendPreLoadRow(IDBManager dbManager, int oldBookMark, DataTable tgtDataTable, DataTableResultSet srcResultSet) throws Throwable {
        DataTable srcDataTable = srcResultSet.getDataTable();
        int srcColumnCount = srcDataTable.getMetaData().getColumnCount();
        if (oldBookMark >= 0) {
            Row row = DataTableExUtil.getRowByBookmark(tgtDataTable, oldBookMark);
            if (row.getState() != 2) {
                Object[] dataList = row.getDataList();
                Object[] srcDataList = srcDataTable.impl_getRow();
                System.arraycopy(srcDataList, 0, dataList, 0, srcColumnCount);
                row.updateIndex();
            }
            return oldBookMark;
        }
        Row row = DataTableExUtil.appendDataTable(tgtDataTable);
        row.setState(0);
        Object[] dataList = row.getDataList();
        Object[] srcDataList = srcDataTable.impl_getRow();
        System.arraycopy(srcDataList, 0, dataList, 0, srcColumnCount);
        row.updateIndex();
        int bookmark = row.getBookmark();
        return bookmark;
    }

    public static Row insertDataTable(DataTable dataTable, int rowIndex) {
        int newRowIndex = dataTable.insert(rowIndex);
        Row newRow = dataTable.getRowByIndex(newRowIndex);
        return newRow;
    }

    public static Row appendDataTable(DataTable dataTable) {
        return DataTableExUtil.insertDataTable(dataTable, dataTable.size());
    }

    public static boolean hasDeletedRow(DataTable data) throws Throwable {
        return DataTableExUtil.getAllDataList(data).size() != DataTableExUtil.getViewDataList(data).size();
    }

    public static DataTable subDataTable(DataTable data, List<Integer> rowIndexes) throws Throwable {
        if (data.size() == rowIndexes.size()) {
            return data;
        }
        ArrayList<Row> viewDataList = DataTableExUtil.getViewDataList(data);
        DataTable result = new DataTable(data.getMetaData());
        ArrayList<Row> resultViewDataList = DataTableExUtil.getViewDataList(result);
        ArrayList<Row> resultAllDataList = DataTableExUtil.getAllDataList(result);
        HashMap<Integer, Integer> resultBookmarkMap = DataTableExUtil.getBookmarkMap(result);
        int maxBookmark = -1;
        int i = 0;
        int size = rowIndexes.size();
        while (i < size) {
            Integer rowIndex = rowIndexes.get(i);
            Row row = (Row)viewDataList.get(rowIndex);
            resultViewDataList.add(row);
            resultAllDataList.add(row);
            int bookmark = row.getBookmark();
            resultBookmarkMap.put(bookmark, i);
            maxBookmark = Integer.max(maxBookmark, bookmark);
            ++i;
        }
        result.impl_SetBookmarkSeed(maxBookmark);
        return result;
    }

    public static void prepareUpdate(Row row) {
        if (row.getState() == 0) {
            row.createOriginData();
            row.setState(2);
        }
    }

    public static Long[] getLongValues(DataTable dataTable, String columnName) {
        int count;
        int n = count = dataTable == null ? 0 : dataTable.size();
        if (count == 0) {
            return ArrayUtils.EMPTY_LONG_OBJECT_ARRAY;
        }
        Long[] result = new Long[count];
        int columnIndex = dataTable.getMetaData().findColumnIndexByKey(columnName);
        int rowIndex = 0;
        while (rowIndex < count) {
            result[rowIndex] = dataTable.getLong(rowIndex, columnIndex);
            ++rowIndex;
        }
        return result;
    }

    public static int getMinIntValue(DataTable changeData, int[] rowIndexes, int columnIndex) {
        int rowSize;
        int n = rowSize = rowIndexes == null ? 0 : rowIndexes.length;
        if (rowSize == 0) {
            return Integer.MIN_VALUE;
        }
        int result = changeData.getInt(rowIndexes[0], columnIndex);
        int i = 1;
        while (i < rowSize) {
            int tmp = changeData.getInt(rowIndexes[i], columnIndex);
            if (result > tmp) {
                result = tmp;
            }
            ++i;
        }
        return result;
    }

    public static int getMaxIntValue(DataTable changeData, int[] rowIndexes, int columnIndex) {
        int rowSize;
        int n = rowSize = rowIndexes == null ? 0 : rowIndexes.length;
        if (rowSize == 0) {
            return Integer.MAX_VALUE;
        }
        int result = changeData.getInt(rowIndexes[0], columnIndex);
        int i = 1;
        while (i < rowSize) {
            int tmp = changeData.getInt(rowIndexes[i], columnIndex);
            if (result < tmp) {
                result = tmp;
            }
            ++i;
        }
        return result;
    }

    public static DataTable appendDataTable(DataTable src, DataTable tgt) {
        if (src == null) {
            return tgt;
        }
        if (tgt == null) {
            return src;
        }
        src.beforeFirst();
        int count = src.getMetaData().getColumnCount();
        while (src.next()) {
            tgt.append();
            tgt.setState(src.getState());
            System.arraycopy(src.impl_getRow(), 0, tgt.impl_getRow(), 0, count);
        }
        return tgt;
    }

    private static Object convertOneBlankToEmpty(int dataType, Object value) {
        if (StringUtil.isBlankOrNull((Object)value)) {
            if (dataType == 1002 || dataType == 1012 || dataType == 1011) {
                value = "";
            } else if (dataType == 1001 || dataType == 1010 || dataType == 1005 || dataType == 1006 || dataType == 1007) {
                value = TypeConvertor.toDataType((int)dataType, (Object)0);
            }
        }
        return value;
    }
}

