/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dbcache.config;

import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.common.struct.HashMapIgnoreCaseFastGet;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class GlobalSetting {
    private static HashMapIgnoreCaseFastGet<String> ALL_Global_TableKeyMap = null;
    private static Map<String, String> ALL_Global_FormKeyMap = null;
    private static HashMapIgnoreCase<List<String>> globalTableInForm = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void init() throws Throwable {
        if (ALL_Global_TableKeyMap != null) return;
        Class<GlobalSetting> clazz = GlobalSetting.class;
        synchronized (GlobalSetting.class) {
            if (ALL_Global_TableKeyMap != null) return;
            HashMapIgnoreCaseFastGet globalTableKeyMap = new HashMapIgnoreCaseFastGet();
            ConcurrentHashMap<String, String> globalFormKeyMap = new ConcurrentHashMap<String, String>();
            HashMapIgnoreCase tempGlobalTableInForm = new HashMapIgnoreCase();
            Set<String> globalCacheMetaKeys = GlobalSetting.getGlobalCacheMetaKeys();
            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            for (String formKey : globalCacheMetaKeys) {
                globalFormKeyMap.put(formKey, formKey);
                GlobalSetting.addTableKey(formKey, metaFactory, (HashMapIgnoreCaseFastGet<String>)globalTableKeyMap, (HashMapIgnoreCase<List<String>>)tempGlobalTableInForm);
            }
            globalTableInForm = tempGlobalTableInForm;
            ALL_Global_FormKeyMap = globalFormKeyMap;
            ALL_Global_TableKeyMap = globalTableKeyMap;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean isGlobalTable(String tableKey) throws Throwable {
        GlobalSetting.init();
        return ALL_Global_TableKeyMap.containsKey(tableKey);
    }

    private static void addTableKey(String key, IMetaFactory metaFactory, HashMapIgnoreCaseFastGet<String> globalTableKeyMap, HashMapIgnoreCase<List<String>> globalTableInForm) throws Throwable {
        if (metaFactory.getMetaFormList().containsKey(key)) {
            MetaTableCollection metaTables;
            MetaDataObject metaDataObject;
            MetaForm metaForm = metaFactory.getMetaForm(key);
            MetaDataSource metaDataSource = metaForm.getDataSource();
            if (metaDataSource != null && (metaDataObject = metaDataSource.getDataObject()) != null && (metaTables = metaDataObject.getTableCollection()) != null) {
                for (MetaTable metaTable : metaTables) {
                    String tableKey = metaTable.getKey();
                    globalTableKeyMap.put(tableKey, null);
                    List tables = (List)globalTableInForm.getOrDefault(key, new ArrayList(metaTables.size()));
                    tables.add(tableKey);
                    globalTableInForm.put(key, (Object)tables);
                }
            }
        } else if (metaFactory.getDataObjectList().containsKey(key)) {
            MetaTableCollection metaTables;
            MetaDataObject metaDataObject = metaFactory.getDataObject(key);
            if (metaDataObject != null && (metaTables = metaDataObject.getTableCollection()) != null) {
                for (MetaTable metaTable : metaTables) {
                    String tableKey = metaTable.getKey();
                    globalTableKeyMap.put(tableKey, null);
                    List tables = (List)globalTableInForm.getOrDefault(key, new ArrayList(metaTables.size()));
                    tables.add(tableKey);
                    globalTableInForm.put(key, (Object)tables);
                }
            }
        } else {
            globalTableKeyMap.put(key, null);
            List tables = (List)globalTableInForm.getOrDefault(key, new ArrayList(0));
            globalTableInForm.put(key, (Object)tables);
        }
    }

    private static Set<String> getGlobalCacheMetaKeys() {
        ClassLoader classLoader = GlobalSetting.class.getClassLoader();
        try {
            Class<?> classz = classLoader.loadClass("com.bokesoft.erp.GlobalCacheMetaKeys");
            Method method = classz.getMethod("getGlobalCacheMetaKeys", new Class[0]);
            return (Set)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return Collections.emptySet();
        }
    }

    public static boolean isGlobalForm(String formKey) throws Throwable {
        GlobalSetting.init();
        return ALL_Global_FormKeyMap.containsKey(formKey);
    }

    public static List<String> getGlobalTableByFormKey(String formKey) {
        return (List)globalTableInForm.get(formKey);
    }
}

