/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dbcache;

import com.bokesoft.erp.performance.ActionRecorder;
import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.RefObject;
import com.bokesoft.yes.erp.dev.MetaTableCache;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.connection.util.SystemTables;
import com.bokesoft.yes.mid.dbcache.ICacheDBRequest;
import com.bokesoft.yes.mid.dbcache.IWhereExpression;
import com.bokesoft.yes.mid.dbcache.WhereExpressionForCache;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedDelete;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedInsert;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedOther;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedSelect;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedSql;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedSqls;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedUpdate;
import com.bokesoft.yes.mid.dbcache.structure.CacheDB;
import com.bokesoft.yes.mid.dbcache.structure.CacheQuery;
import com.bokesoft.yes.mid.dbcache.structure.CacheTable;
import com.bokesoft.yes.mid.mysqls.resultset.DataTableResultSet;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yes.struct.abstractdatatable.SortCriteria;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.exception.StructException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheDBRequest
implements ICacheDBRequest {
    public final CacheDB cacheDB;
    private static Boolean isUseCacheDB = null;
    private boolean localIsUseCacheDB = true;
    private static final Logger logger = LoggerFactory.getLogger(ActionRecorder.class);

    public CacheDBRequest(IDBManager dbManager) {
        this.cacheDB = new CacheDB(dbManager);
    }

    public boolean isUseCacheDB() {
        if (isUseCacheDB == null) {
            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            if (metaFactory == null) {
                return false;
            }
            isUseCacheDB = true;
        }
        if (!isUseCacheDB.booleanValue()) {
            return false;
        }
        return this.localIsUseCacheDB;
    }

    public Boolean stopLocalIsUseCacheDB() {
        Boolean result = this.localIsUseCacheDB;
        this.localIsUseCacheDB = false;
        return result;
    }

    public void restoreLocalIsUseCacheDB(boolean org) {
        this.localIsUseCacheDB = org;
    }

    public ResultSet execQuery(String sql) throws SQLException {
        try {
            return this.execPrepareQuery(sql, null);
        }
        catch (Throwable e) {
            this.throwException(e);
            LogSvr.getInstance().info("\u6570\u636e\u7f13\u5b58\u9519\u8befexecQuery " + e);
            throw new SQLException("\u6570\u636e\u7f13\u5b58\u9519\u8bef\nSQL:" + sql + "\n", e);
        }
    }

    public ResultSet appendQuery(IDBManager dbm, String sql, ResultSet resultSet) throws SQLException {
        try {
            return this.appendQuery(dbm, sql, null, resultSet);
        }
        catch (Throwable e) {
            this.throwException(e);
            LogSvr.getInstance().info("\u6570\u636e\u7f13\u5b58\u9519\u8befappendQuery " + e);
            throw new SQLException("\u6570\u636e\u7f13\u5b58\u9519\u8bef\nSQL:" + sql + "\n", e);
        }
    }

    public ResultSet execPrepareQuery(String sql, QueryArguments arguments) throws SQLException {
        if (!this.isUseCacheDB()) {
            return null;
        }
        ParsedSql parsedSql = ParsedSqls.getInstance().getParsedSql(sql);
        DataTableResultSet result = null;
        try {
            if (!(parsedSql instanceof ParsedOther)) {
                CacheQuery cachedQuery;
                List<String> tableNames;
                ParsedSelect select = (ParsedSelect)parsedSql;
                if (select.isSupportCache()) {
                    result = this.cacheDB.query(select, arguments);
                }
                if (result == null && !this.isNoCacheTable(tableNames = parsedSql.getTableNames()) && !CacheDBRequest.hasChangedTable(this.cacheDB, tableNames) && (cachedQuery = this.cacheDB.getCacheQuery(select)) != null) {
                    result = cachedQuery.getDataTable(arguments);
                }
            }
            if (result == null) {
                this.cacheDB.submitByNotSuportCacheSql(this, parsedSql, arguments, null, false);
            }
            return result;
        }
        catch (Throwable e) {
            this.throwException(e);
            logger.warn("\u6570\u636e\u7f13\u5b58\u9519\u8befCacheDBRequest.execPrepareQuery " + e);
            throw new SQLException("\u6570\u636e\u7f13\u5b58\u9519\u8bef\uff1a" + e.getMessage() + "\nSQL:" + sql + "\t paras:" + (arguments == null ? "null" : arguments.toString()) + "\n", e);
        }
    }

    private boolean isNoCacheTable(List<String> tableNames) {
        for (String tableName : tableNames) {
            if (!SystemTables.isSystemTable(tableName)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasChangedTable(CacheDB cacheDB, List<String> tableNames) throws Throwable {
        for (String tableName : tableNames) {
            if (!cacheDB.isUpdatedTable(tableName)) continue;
            return true;
        }
        return false;
    }

    public ResultSet appendQuery(IDBManager dbm, String sql, QueryArguments arguments, ResultSet resultSet) throws SQLException {
        if (!this.isUseCacheDB()) {
            return resultSet;
        }
        ResultSet result = resultSet;
        ParsedSql parsedSql = ParsedSqls.getInstance().getParsedSql(sql);
        try {
            if (parsedSql instanceof ParsedSelect) {
                ParsedSelect select = (ParsedSelect)parsedSql;
                if (!this.isNoCacheTable(parsedSql.getTableNames()) && !CacheDBRequest.hasChangedTable(this.cacheDB, parsedSql.getTableNames())) {
                    String tableName;
                    SqlString defaultSelect;
                    CacheQuery cachedQuery = this.cacheDB.getCacheQuery(select);
                    result = cachedQuery.setDataTable(this.cacheDB.dbManager, arguments, resultSet);
                    List<String> tableNames = select.getTableNames();
                    if (tableNames.size() == 1 && (defaultSelect = MetaTableCache.getDefaultSelect(tableName = tableNames.get(0), dbm)) != null && sql.startsWith(defaultSelect.getSql())) {
                        CacheTable cacheTable = this.cacheDB.getCacheTable(tableName, true);
                        cacheTable.appendPreLoad(dbm, result, null);
                    }
                    result.beforeFirst();
                }
            }
        }
        catch (Throwable e) {
            this.throwException(e);
            LogSvr.getInstance().info("\u6570\u636e\u7f13\u5b58\u9519\u8befappendQuery " + e);
            throw new SQLException("\u6570\u636e\u7f13\u5b58\u9519\u8bef\nSQL:" + sql + "\t paras:" + (arguments != null ? arguments.toString() : "null") + "\n", e);
        }
        return result;
    }

    public int executeUpdate(String sql, QueryArguments args, RefObject<Boolean> isCached) throws SQLException {
        if (!this.isUseCacheDB()) {
            isCached.setValue((Object)false);
            return 0;
        }
        int result = 0;
        ParsedSql parsedSql = ParsedSqls.getInstance().getParsedSql(sql);
        boolean processInCache = false;
        try {
            if (!(parsedSql instanceof ParsedOther) && parsedSql.isSupportCache()) {
                ArrayList<QueryArguments> parases = new ArrayList<QueryArguments>(1);
                parases.add(args);
                if (parsedSql instanceof ParsedInsert) {
                    ArrayList<QueryArguments> notProcessParases = new ArrayList<QueryArguments>(1);
                    result = this.cacheDB.insert((ParsedInsert)parsedSql, parases, notProcessParases);
                    processInCache = notProcessParases.size() == 0;
                } else if (parsedSql instanceof ParsedUpdate) {
                    ArrayList<QueryArguments> notProcessParases = new ArrayList<QueryArguments>(1);
                    result = this.cacheDB.update((ParsedUpdate)parsedSql, parases, notProcessParases);
                    processInCache = notProcessParases.size() == 0;
                } else if (parsedSql instanceof ParsedDelete) {
                    ArrayList<QueryArguments> notProcessParases = new ArrayList<QueryArguments>(1);
                    result = this.cacheDB.delete((ParsedDelete)parsedSql, parases, notProcessParases);
                    processInCache = notProcessParases.size() == 0;
                }
            }
            isCached.setValue((Object)processInCache);
            if (!processInCache) {
                this.cacheDB.submitByNotSuportCacheSql(this, parsedSql, args, null, true);
            }
        }
        catch (Throwable e) {
            this.throwException(e);
            LogSvr.getInstance().info("\u6570\u636e\u7f13\u5b58\u9519\u8befexecuteUpdate " + e);
            throw new SQLException("\u6570\u636e\u7f13\u5b58\u9519\u8bef\nSQL:" + sql + "\t paras:" + (args == null ? "null" : args.toString()) + "\n" + "\u9519\u8bef\u539f\u56e0\uff1a" + e.getMessage(), e);
        }
        return result;
    }

    private void throwException(Throwable e) throws SQLException {
        if (e instanceof SQLException) {
            throw (SQLException)e;
        }
        if (e instanceof ClassCastException) {
            throw (ClassCastException)e;
        }
        if (e instanceof StructException) {
            throw (StructException)e;
        }
        if (e instanceof ConcurrentModificationException) {
            throw (ConcurrentModificationException)e;
        }
        if (e instanceof MidCoreException) {
            throw (MidCoreException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
    }

    public boolean executeUpdate(String sql, List<QueryArguments> parases, List<QueryArguments> notProcessParases) throws SQLException {
        if (!this.isUseCacheDB()) {
            return false;
        }
        ParsedSql parsedSql = ParsedSqls.getInstance().getParsedSql(sql);
        try {
            if (!(parsedSql instanceof ParsedOther) && parsedSql.isSupportCache()) {
                if (parsedSql instanceof ParsedInsert) {
                    this.cacheDB.insert((ParsedInsert)parsedSql, parases, notProcessParases);
                } else if (parsedSql instanceof ParsedUpdate) {
                    this.cacheDB.update((ParsedUpdate)parsedSql, parases, notProcessParases);
                } else if (parsedSql instanceof ParsedDelete) {
                    this.cacheDB.delete((ParsedDelete)parsedSql, parases, notProcessParases);
                }
            } else {
                this.cacheDB.submitByNotSuportCacheSql(this, parsedSql, null, parases, true);
                notProcessParases.addAll(parases);
            }
        }
        catch (Throwable e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new SQLException(e.getMessage(), e);
        }
        return true;
    }

    public boolean saveDataTable(DataTable dataTable, String tableName, MetaTable metaTable, Object causeCacheObject) throws SQLException {
        if (!this.isUseCacheDB()) {
            return false;
        }
        try {
            return this.cacheDB.saveDataTable(dataTable, tableName, metaTable, causeCacheObject);
        }
        catch (Throwable e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new SQLException(e.getMessage(), e);
        }
    }

    public void submit() throws Throwable {
        if (!this.isUseCacheDB()) {
            return;
        }
        Object[] actions = new Object[]{"submit"};
        int action = Performance.startAction((Object[])actions);
        this.cacheDB.submit(this);
        Performance.endActive((int)action, (Object[])actions);
    }

    public void rollback() {
        if (!this.isUseCacheDB()) {
            return;
        }
        Object[] actions = new Object[]{"rollback"};
        int action = Performance.startAction((Object[])actions);
        this.cacheDB.rollback(this);
        Performance.endActive((int)action, (Object[])actions);
    }

    public Object getCacheBillEntity(String formKey, Long oid) throws Throwable {
        return this.cacheDB.getCacheBillEntity(formKey, oid);
    }

    public void cacheBillEntity(String formKey, Long oid, Object billEntity) {
        this.cacheDB.cacheBillEntity(formKey, oid, billEntity);
    }

    public DataTable queryByOID(String tableKey, Long oid) throws Throwable {
        return this.cacheDB.queryByOID(tableKey, oid);
    }

    public DataTable queryByWhereExpression(String tableKey, IWhereExpression whereExpression, SortCriteria[] sorts) throws Throwable {
        WhereExpressionForCache whereExpressionForCache = (WhereExpressionForCache)WhereExpressionForCache.class.cast(whereExpression);
        return this.cacheDB.queryByWhereExpression(tableKey, whereExpressionForCache, sorts);
    }

    public void addPreLoadingArgument(String tableKey, IWhereExpression whereExpression) throws Throwable {
        WhereExpressionForCache whereExpressionForCache = (WhereExpressionForCache)WhereExpressionForCache.class.cast(whereExpression);
        this.cacheDB.addPreLoadingArgument(tableKey, whereExpressionForCache);
    }

    public boolean hasOIDInCacheTable(String tableName, Long oid) throws Throwable {
        CacheTable cacheTable = this.cacheDB.getCacheTable(tableName, false);
        return cacheTable == null ? false : cacheTable.existOID(oid);
    }

    public boolean isNewInsertSOID(String tableName, Long soid) throws Throwable {
        CacheDB cacheDB = this.cacheDB;
        return cacheDB.isNewInsertSOID(tableName, soid);
    }

    public boolean hasSOIDLoadAllInCacheTable(String tableName, Long soid) throws Throwable {
        CacheDB cacheDB = this.cacheDB;
        if (cacheDB.isNewInsertSOID(tableName, soid)) {
            return true;
        }
        CacheTable cacheTable = cacheDB.getCacheTable(tableName, false);
        return cacheTable == null ? false : cacheTable.existSOID(soid);
    }

    public Object getValueFromCacheTableByOID(String tableName, Long oid, String columnName) throws Throwable {
        CacheTable cacheTable = this.cacheDB.getCacheTable(tableName, false);
        if (cacheTable == null) {
            return null;
        }
        return cacheTable.getValueByOID(oid, columnName);
    }

    public Object getOrgValueFromCacheTableByOID(String tableName, Long oid, String columnName) throws Throwable {
        CacheTable cacheTable = this.cacheDB.getCacheTable(tableName, false);
        if (cacheTable == null) {
            return null;
        }
        return cacheTable.getOrgValueByOID(oid, columnName);
    }

    public Long[] getOIDsbySOID(String tableName, Long soid) throws Throwable {
        CacheDB cacheDB = this.cacheDB;
        CacheTable cacheTable = cacheDB.getCacheTable(tableName, false);
        if (cacheTable == null && cacheDB.isNewInsertSOID(tableName, soid)) {
            return ArrayUtils.EMPTY_LONG_OBJECT_ARRAY;
        }
        if (!cacheTable.existSOID(soid)) {
            cacheDB.isNewInsertSOID(tableName, soid);
        }
        return cacheTable.getOIDsBySOID(soid);
    }
}

