/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection.dbmanager;

import com.bokesoft.erp.mid.util.NotImplemented;
import com.bokesoft.erp.performance.Performance;
import com.bokesoft.erp.sql.check.CheckSplitSql;
import com.bokesoft.yes.common.struct.RefObject;
import com.bokesoft.yes.mid.connection.dbmanager.ConvertSqlByDBType;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.connection.dbmanager.SQLLogUtils;
import com.bokesoft.yes.mid.connection.dbmanager.SlowSqlSetting;
import com.bokesoft.yes.mid.connection.dbmanager.SqlServerDBManager;
import com.bokesoft.yes.mid.dbcache.ICacheDBRequest;
import com.bokesoft.yes.mid.dbcache.structure.Parameters;
import com.bokesoft.yes.mid.mysqls.resultset.DataTableResultSet;
import com.bokesoft.yes.mid.mysqls.resultset.JoinResultSet;
import com.bokesoft.yes.mid.mysqls.resultset.UnionResultSet;
import com.bokesoft.yes.mid.server.weight.action.SqlTimePOS;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import net.boke.jsqlparser.expression.operators.SqlParametricCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementWithLog
implements Statement {
    protected IDBManager dbManager;
    protected Statement statement;
    protected String sql;
    protected static final int INT_FetchSize_NoSetValue = -1;
    protected int fetchSize = -1;
    protected SqlTimePOS timeConsumeAction = null;
    private static final Logger logger = LoggerFactory.getLogger(StatementWithLog.class);
    Parameters curArguments;
    List<QueryArguments> processParases;
    protected ICacheDBRequest cacheDBRequest;

    public StatementWithLog(IDBManager dbManager, ICacheDBRequest cacheDBRequest) {
        this(dbManager, null, cacheDBRequest);
    }

    public StatementWithLog(IDBManager dbManager, String sql, ICacheDBRequest cacheDBRequest) {
        this.dbManager = dbManager;
        this.sql = sql;
        this.cacheDBRequest = cacheDBRequest;
        this.timeConsumeAction = new SqlTimePOS();
    }

    protected Statement getStatement() throws SQLException {
        if (this.statement == null) {
            this.statement = this.dbManager.createJDBCStatement();
            if (this.fetchSize != -1) {
                this.statement.setFetchSize(this.fetchSize);
            }
        }
        return this.statement;
    }

    public void noCache() {
        this.cacheDBRequest = null;
    }

    protected void setSqlMaxTime(String sql) throws SQLException {
        if (SlowSqlSetting.instance.isLimitTime(sql)) {
            this.getStatement().setQueryTimeout(SlowSqlSetting.instance.slowSqlMaxTime);
        }
    }

    private void setSqlMaxTime(String sql, int count) throws SQLException {
        if (SlowSqlSetting.instance.isLimitTime(sql)) {
            this.getStatement().setQueryTimeout(SlowSqlSetting.instance.slowSqlMaxTime * count);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.getStatement().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getStatement().isWrapperFor(iface);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        ResultSet result = null;
        try {
            new SqlParametricCheck().checkSelectSQL(sql);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.getMessage());
        }
        if (this.cacheDBRequest != null) {
            result = this.cacheDBRequest.execQuery(sql);
        }
        String oldSQL = sql;
        if (result == null) {
            sql = ConvertSqlByDBType.convertSql(sql, this.dbManager.getDBType(), this.curArguments);
            Object[] actions = new Object[]{"QueryDatabase/", sql, this.curArguments};
            int action = Performance.startAction((Object[])actions);
            this.setSqlMaxTime(oldSQL);
            this.timeConsumeAction.start(seconds -> this.getStatement().setQueryTimeout(Math.min(this.getStatement().getQueryTimeout(), seconds)));
            CheckSplitSql.logActualSql(sql, sql);
            long startData = System.currentTimeMillis();
            result = this.getStatement().executeQuery(sql);
            long endData = System.currentTimeMillis();
            this.timeConsumeAction.end((Object)sql);
            int row = 0;
            if (result instanceof DataTableResultSet) {
                DataTable table = ((DataTableResultSet)result).getDataTable();
                row = table.size();
            } else if (!(result instanceof JoinResultSet) && !(result instanceof UnionResultSet)) {
                result.last();
                row = result.getRow();
                result.first();
                if (!(this.dbManager instanceof SqlServerDBManager) || row != 0) {
                    result.relative(-2);
                }
            }
            long l = endData - startData;
            SQLLogUtils.logSQL(this.dbManager, logger, l, row, sql, actions);
            Performance.endActive((int)action, (Object[])actions);
            result = this.cacheDBRequest.appendQuery(this.dbManager, oldSQL, result);
        }
        return result;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            new SqlParametricCheck().checkSelectSQL(sql);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.getMessage());
        }
        RefObject isCached = new RefObject((Object)false);
        int result = -1;
        if (this.cacheDBRequest != null) {
            result = this.cacheDBRequest.executeUpdate(sql, (QueryArguments)this.curArguments, isCached);
        }
        String oldSQL = sql;
        sql = ConvertSqlByDBType.convertSql(sql, this.dbManager.getDBType(), this.curArguments);
        if (!((Boolean)isCached.getValue()).booleanValue()) {
            if (this.curArguments != null) {
                PreparedStatement preparedStatement = (PreparedStatement)this.getStatement();
                int i = 0;
                int length = this.curArguments.size();
                while (i < length) {
                    preparedStatement.setObject(i + 1, this.curArguments.get(i));
                    ++i;
                }
            }
            Object[] actions = new Object[]{sql, this.curArguments};
            int action = Performance.startAction((Object[])actions);
            this.setSqlMaxTime(oldSQL);
            this.timeConsumeAction.start(seconds -> this.getStatement().setQueryTimeout(Math.min(this.getStatement().getQueryTimeout(), seconds)));
            long startData = System.currentTimeMillis();
            result = this.getStatement().executeUpdate(sql);
            long endData = System.currentTimeMillis();
            this.timeConsumeAction.end((Object)sql);
            long l = endData - startData;
            SQLLogUtils.logSQL(this.dbManager, logger, l, result, sql, actions);
            Performance.endActive((int)action, (Object[])actions);
            this.curArguments = null;
        }
        return result;
    }

    @Override
    public void close() throws SQLException {
        this.dbManager = null;
        if (this.statement != null) {
            this.statement.close();
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.getStatement().getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.getStatement().setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.getStatement().getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.getStatement().setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.getStatement().setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.getStatement().getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.getStatement().setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.getStatement().cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.getStatement().getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.getStatement().clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.getStatement().setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            new SqlParametricCheck().checkSelectSQL(sql);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.getMessage());
        }
        RefObject isCached = new RefObject((Object)false);
        boolean result = false;
        if (this.cacheDBRequest != null) {
            result = this.cacheDBRequest.executeUpdate(sql, (QueryArguments)this.curArguments, isCached) > 0;
        }
        String oldSQL = sql;
        if (!((Boolean)isCached.getValue()).booleanValue()) {
            if (this.curArguments != null) {
                sql = ConvertSqlByDBType.convertSql(sql, this.dbManager.getDBType(), this.curArguments);
                PreparedStatement preparedStatement = (PreparedStatement)this.getStatement();
                int i = 0;
                int length = this.curArguments.size();
                while (i < length) {
                    preparedStatement.setObject(i + 1, this.curArguments.get(i));
                    ++i;
                }
                this.curArguments = null;
            }
            int action = Performance.startAction((Object[])new Object[]{sql});
            this.setSqlMaxTime(oldSQL);
            CheckSplitSql.logActualSql(sql, sql);
            this.timeConsumeAction.start(seconds -> this.getStatement().setQueryTimeout(Math.min(this.getStatement().getQueryTimeout(), seconds)));
            long startData = System.currentTimeMillis();
            result = this.getStatement().execute(sql);
            long endData = System.currentTimeMillis();
            this.timeConsumeAction.end((Object)sql);
            Object[] actions = new Object[]{sql, this.curArguments};
            long l = endData - startData;
            int size = result ? 1 : 0;
            SQLLogUtils.logSQL(this.dbManager, logger, l, size, sql, actions);
            Performance.endActive((int)action, (Object[])new Object[]{sql});
        }
        return result;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.getStatement().getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.getStatement().getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getStatement().getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.getStatement().setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.getStatement().getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (this.statement == null) {
            this.fetchSize = rows;
        } else {
            this.statement.setFetchSize(rows);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.getStatement().getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.getStatement().getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.getStatement().getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.getStatement().addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.processParases != null) {
            this.processParases.clear();
        }
        this.getStatement().clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int batchCount = this.processParases.size();
        List<Object> notProcessParases = new ArrayList();
        if (this.cacheDBRequest != null && !this.cacheDBRequest.executeUpdate(this.sql, this.processParases, notProcessParases)) {
            notProcessParases = this.processParases;
        }
        if (notProcessParases.size() > 0) {
            PreparedStatement preparedStatement = (PreparedStatement)this.getStatement();
            int length = ((QueryArguments)notProcessParases.get(0)).size();
            for (QueryArguments queryArguments : notProcessParases) {
                int i = 0;
                while (i < length) {
                    preparedStatement.setObject(i + 1, queryArguments.get(i));
                    ++i;
                }
                preparedStatement.addBatch();
            }
            Object[] objectArray = new Object[]{"executeBatch:", batchCount, "\t", this.sql, this.processParases};
            int action = Performance.startAction((Object[])objectArray);
            this.setSqlMaxTime(this.sql, batchCount);
            this.timeConsumeAction.start(seconds -> preparedStatement.setQueryTimeout(Math.min(preparedStatement.getQueryTimeout(), seconds)));
            long startData = System.currentTimeMillis();
            int[] result = preparedStatement.executeBatch();
            long endData = System.currentTimeMillis();
            this.timeConsumeAction.end((Object)this.sql);
            long l = endData - startData;
            SQLLogUtils.logSQL(this.dbManager, logger, l, result.length, this.sql, objectArray);
            this.processParases.clear();
            Performance.endActive((int)action, (Object[])objectArray);
            return result;
        }
        this.processParases.clear();
        return null;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getStatement().getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.getStatement().getMoreResults();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.getStatement().getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.getStatement().getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.dbManager == null;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.getStatement().setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.getStatement().isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.getStatement().closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.getStatement().isCloseOnCompletion();
    }
}

