/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection.dbmanager;

import com.bokesoft.erp.mid.util.NotImplemented;
import com.bokesoft.erp.performance.Performance;
import com.bokesoft.erp.sql.check.CheckSplitSql;
import com.bokesoft.yes.common.struct.RefObject;
import com.bokesoft.yes.mid.connection.dbmanager.ConvertSqlByDBType;
import com.bokesoft.yes.mid.connection.dbmanager.IPreparedStatementSetParaCount;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.connection.dbmanager.SQLLogUtils;
import com.bokesoft.yes.mid.connection.dbmanager.SqlServerDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.StatementWithLog;
import com.bokesoft.yes.mid.dbcache.ICacheDBRequest;
import com.bokesoft.yes.mid.dbcache.structure.Parameters;
import com.bokesoft.yes.mid.mysqls.resultset.DataTableResultSet;
import com.bokesoft.yes.mid.mysqls.resultset.JoinResultSet;
import com.bokesoft.yes.mid.mysqls.resultset.UnionResultSet;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfos;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import net.boke.jsqlparser.expression.operators.SqlParametricCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedStatementWithLog
extends StatementWithLog
implements PreparedStatement,
IPreparedStatementSetParaCount {
    private final Object queryCacheLock = new Object();
    private static final Logger logger = LoggerFactory.getLogger(PreparedStatementWithLog.class);
    private int parameterCount = -1;

    public PreparedStatementWithLog(IDBManager dbManager, String sql, ICacheDBRequest cacheDBRequest) {
        super(dbManager, sql, cacheDBRequest);
    }

    @Override
    protected Statement getStatement() throws SQLException {
        if (this.statement == null) {
            this.statement = this.dbManager.createJDBCPrepareStatement(this.sql);
            if (this.fetchSize != -1) {
                this.statement.setFetchSize(this.fetchSize);
            }
        }
        return this.statement;
    }

    private PreparedStatement getPreparedStatement() throws SQLException {
        return (PreparedStatement)this.getStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery() throws SQLException {
        try {
            new SqlParametricCheck().checkSelectSQL(this.sql);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.getMessage());
        }
        ResultSet result = null;
        Object object = this.queryCacheLock;
        synchronized (object) {
            if (this.cacheDBRequest != null) {
                result = this.cacheDBRequest.execPrepareQuery(this.sql, (QueryArguments)this.curArguments);
            }
            String oldSQL = this.sql;
            if (result == null) {
                this.sql = ConvertSqlByDBType.convertSql(this.sql, this.dbManager.getDBType(), this.curArguments);
                PreparedStatement tmp = this.getPreparedStatement();
                if (this.curArguments != null) {
                    int i = 0;
                    int length = this.curArguments.size();
                    while (i < length) {
                        tmp.setObject(i + 1, this.curArguments.get(i));
                        ++i;
                    }
                }
                Object[] actions = new Object[]{"QueryDatabase/", this.sql, this.curArguments};
                int action = Performance.startAction((Object[])actions);
                this.setSqlMaxTime(oldSQL);
                CheckSplitSql.logActualSql(tmp, this.sql);
                this.timeConsumeAction.start(seconds -> tmp.setQueryTimeout(Math.min(tmp.getQueryTimeout(), seconds)));
                long startData = System.currentTimeMillis();
                result = tmp.executeQuery();
                long endData = System.currentTimeMillis();
                this.timeConsumeAction.end((Object)this.sql);
                int row = 0;
                if (result instanceof DataTableResultSet) {
                    DataTable table = ((DataTableResultSet)result).getDataTable();
                    table.beforeFirst();
                    row = table.size();
                } else if (!(result instanceof JoinResultSet) && !(result instanceof UnionResultSet)) {
                    result.last();
                    row = result.getRow();
                    result.first();
                    if (!(this.dbManager instanceof SqlServerDBManager) || row != 0) {
                        result.relative(-2);
                    }
                }
                long l = endData - startData;
                SQLLogUtils.logSQL(this.dbManager, logger, l, row, this.sql, actions);
                Performance.endActive((int)action, (Object[])actions);
                if (this.cacheDBRequest != null) {
                    result = this.cacheDBRequest.appendQuery(this.dbManager, oldSQL, (QueryArguments)this.curArguments, result);
                }
                this.curArguments = null;
            }
        }
        return result;
    }

    @Override
    public int executeUpdate() throws SQLException {
        try {
            new SqlParametricCheck().checkSelectSQL(this.sql);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.getMessage());
        }
        RefObject isCached = new RefObject((Object)false);
        int result = -1;
        if (this.cacheDBRequest != null) {
            result = this.cacheDBRequest.executeUpdate(this.sql, (QueryArguments)this.curArguments, isCached);
        }
        String oldSQL = this.sql;
        if (!((Boolean)isCached.getValue()).booleanValue()) {
            this.sql = ConvertSqlByDBType.convertSql(this.sql, this.dbManager.getDBType(), this.curArguments);
            PreparedStatement tmp = this.getPreparedStatement();
            if (this.curArguments != null) {
                int i = 0;
                int length = this.curArguments.size();
                while (i < length) {
                    tmp.setObject(i + 1, this.curArguments.get(i));
                    ++i;
                }
            }
            Object[] actions = new Object[]{this.sql, this.curArguments};
            int action = Performance.startAction((Object[])actions);
            this.setSqlMaxTime(oldSQL);
            CheckSplitSql.logActualSql(tmp, this.sql);
            this.timeConsumeAction.start(seconds -> tmp.setQueryTimeout(Math.min(tmp.getQueryTimeout(), seconds)));
            long startData = System.currentTimeMillis();
            result = tmp.executeUpdate();
            long endData = System.currentTimeMillis();
            this.timeConsumeAction.end((Object)this.sql);
            long l = endData - startData;
            SQLLogUtils.logSQL(this.dbManager, logger, l, result, this.sql, actions);
            Performance.endActive((int)action, (Object[])actions);
            this.curArguments = null;
        }
        return result;
    }

    private Parameters getCurParameters() {
        if (this.curArguments == null) {
            int size = this.getParameterCount();
            this.curArguments = new Parameters(size);
        }
        return this.curArguments;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.getCurParameters().set(parameterIndex - 1, null);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.getCurParameters().set(parameterIndex - 1, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.getCurParameters().set(parameterIndex - 1, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.getCurParameters().set(parameterIndex - 1, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.getCurParameters().set(parameterIndex - 1, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.getCurParameters().set(parameterIndex - 1, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.getCurParameters().set(parameterIndex - 1, Float.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.getCurParameters().set(parameterIndex - 1, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.getCurParameters().set(parameterIndex - 1, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.getCurParameters().set(parameterIndex - 1, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.getCurParameters().set(parameterIndex - 1, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.getCurParameters().set(parameterIndex - 1, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.getCurParameters().set(parameterIndex - 1, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.getCurParameters().set(parameterIndex - 1, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.getPreparedStatement().clearParameters();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.getCurParameters().set(parameterIndex - 1, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.getCurParameters().set(parameterIndex - 1, x);
    }

    @Override
    public boolean execute() throws SQLException {
        try {
            new SqlParametricCheck().checkSelectSQL(this.sql);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.getMessage());
        }
        RefObject isCached = new RefObject((Object)false);
        boolean result = false;
        if (this.cacheDBRequest != null) {
            result = this.cacheDBRequest.executeUpdate(this.sql, (QueryArguments)this.curArguments, isCached) > 0;
        }
        String oldSQL = this.sql;
        if (!((Boolean)isCached.getValue()).booleanValue()) {
            this.sql = ConvertSqlByDBType.convertSql(this.sql, this.dbManager.getDBType());
            PreparedStatement tmp = this.getPreparedStatement();
            if (this.curArguments != null) {
                int i = 0;
                int length = this.curArguments.size();
                while (i < length) {
                    tmp.setObject(i + 1, this.curArguments.get(i));
                    ++i;
                }
                this.curArguments = null;
            }
            int action = Performance.startAction((Object[])new Object[]{this.sql});
            this.setSqlMaxTime(oldSQL);
            CheckSplitSql.logActualSql(tmp, this.sql);
            this.timeConsumeAction.start(seconds -> tmp.setQueryTimeout(Math.min(tmp.getQueryTimeout(), seconds)));
            long startData = System.currentTimeMillis();
            result = tmp.execute();
            long endData = System.currentTimeMillis();
            this.timeConsumeAction.end((Object)this.sql);
            Object[] actions = new Object[]{this.sql};
            long l = endData - startData;
            int row = result ? 1 : 0;
            SQLLogUtils.logSQL(this.dbManager, logger, l, row, this.sql, actions);
            Performance.endActive((int)action, (Object[])new Object[]{this.sql});
        }
        return result;
    }

    @Override
    public void addBatch() throws SQLException {
        if (this.curArguments != null) {
            if (this.processParases == null) {
                this.processParases = new ArrayList();
            }
            this.processParases.add(this.curArguments);
            this.curArguments = null;
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.getCurParameters().set(parameterIndex - 1, x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.getCurParameters().set(parameterIndex - 1, x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.getPreparedStatement().getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.getCurParameters().set(parameterIndex - 1, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.getCurParameters().set(parameterIndex - 1, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.getCurParameters().set(parameterIndex - 1, x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.getCurParameters().set(parameterIndex - 1, null);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.getCurParameters().set(parameterIndex - 1, x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.getPreparedStatement().getParameterMetaData();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.getCurParameters().set(parameterIndex - 1, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.getCurParameters().set(parameterIndex - 1, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new NotImplemented();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new NotImplemented();
    }

    private int getParameterCount() {
        if (this.parameterCount < 0) {
            this.parameterCount = SqlInfos.instance.getJDBCParameterCount(this.sql);
        }
        return this.parameterCount;
    }

    @Override
    public void setParameterCount(int count) {
        this.parameterCount = count;
    }
}

