/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection.dbmanager;

import com.bokesoft.yes.base.IStartListener;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.mid.connection.dbmanager.SlowSqlSetting;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InitSlowSqlSetting
implements IStartListener {
    private static final String SolutionKey = "YigoERPPractices";
    private File settingFile;
    private long lastModified = 0L;
    private long lastFileLength = 0L;
    private int reloadSettingTime = 300;

    public void invoke(DefaultContext c) throws Throwable {
        IMetaFactory metaFactory = c.getVE().getMetaFactory();
        Collection metaSolutions = metaFactory.getMetaSolutions();
        for (MetaSolution metaSolution : metaSolutions) {
            String key = metaSolution.getKey();
            if (!key.equalsIgnoreCase(SolutionKey)) continue;
            IMetaResolverFactory metaResolverFactoryBySolution = metaFactory.getMetaResolverFactoryBySolution(key);
            String solutionPath = metaResolverFactoryBySolution.getSolutionPath();
            String filePath = new StringBuilder(256).append(solutionPath).append(File.separator).append("SlowSqlSetting.xml").toString();
            this.settingFile = new File(filePath);
            this.fileToSlowSQLSetting();
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep(InitSlowSqlSetting.this.reloadSettingTime * 1000);
                                InitSlowSqlSetting.this.fileToSlowSQLSetting();
                            }
                        }
                        catch (Throwable e) {
                            LogSvr.getInstance().error("ReloadSlowSqlSetting\u51fa\u9519", e);
                            continue;
                        }
                        break;
                    }
                }
            }, "ReloadSlowSqlSetting");
            thread.start();
        }
    }

    private void fileToSlowSQLSetting() throws Throwable {
        if (this.settingFile.exists() && this.settingFile.isFile()) {
            if (this.lastModified == this.settingFile.lastModified() && this.lastFileLength == this.settingFile.length()) {
                return;
            }
            String content = FileUtils.readFileToString((File)this.settingFile, (String)"utf-8");
            this.xmlToSlowSQLSetting(content);
        }
    }

    private void xmlToSlowSQLSetting(String xml) throws Throwable {
        Document doc = DomHelper.createDocument((String)xml);
        Element root = doc.getDocumentElement();
        NodeList list = root.getChildNodes();
        HashSet<String> unlimitTimeSqls = new HashSet<String>();
        int i = 0;
        int count = list.getLength();
        while (i < count) {
            Node node = list.item(i);
            if (node instanceof Element) {
                Element element = (Element)node;
                if (element.getTagName().equals("SlowSql")) {
                    int time;
                    if (element.hasAttribute("SlowSqlMaxTime")) {
                        time = TypeConvertor.toInteger((Object)element.getAttribute("SlowSqlMaxTime"));
                        int n = SlowSqlSetting.instance.slowSqlMaxTime = time > 0 ? time : 1;
                    }
                    if (element.hasAttribute("ReloadSettingTime")) {
                        time = TypeConvertor.toInteger((Object)element.getAttribute("ReloadSettingTime"));
                        this.reloadSettingTime = time < 300 ? 300 : time;
                    }
                } else if (element.getTagName().equals("UnlimitTimeSql")) {
                    NodeList tmpList = element.getChildNodes();
                    int j = 0;
                    int len = tmpList.getLength();
                    while (j < len) {
                        Node tmpNode = tmpList.item(j);
                        if (tmpNode instanceof CDATASection) {
                            String sql = tmpNode.getTextContent();
                            unlimitTimeSqls.add(sql);
                            break;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        SlowSqlSetting.instance.unlimitTimeSqls = unlimitTimeSqls;
    }
}

