/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection;

import com.alibaba.druid.pool.xa.DruidXADataSource;
import com.atomikos.jdbc.AtomikosDataSourceBean;
import com.bokesoft.yes.mid.connection.MdbConnectionProfile;
import com.bokesoft.yigo.mid.connection.IConnectionFactory;
import com.bokesoft.yigo.mid.connection.IConnectionProfile;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XAConnectionFactory
implements IConnectionFactory {
    private static final Logger logger = LoggerFactory.getLogger(XAConnectionFactory.class);
    private static Map<String, AtomikosDataSourceBean> dsCache = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSource getDataSource(IConnectionProfile profile) {
        String key = profile.getKey().toLowerCase();
        logger.debug("getDataSource..DSN:{} \u7ebf\u7a0b\uff1a{}", (Object)key, (Object)Thread.currentThread().getId());
        if (dsCache.get(key) == null) {
            Map<String, AtomikosDataSourceBean> map = dsCache;
            synchronized (map) {
                if (!dsCache.containsKey(key)) {
                    logger.debug("getDataSource..\u521b\u5efa");
                    String dbDriver = profile.getDriver().trim();
                    AtomikosDataSourceBean ds = new AtomikosDataSourceBean();
                    ds.setUniqueResourceName(key);
                    if (dbDriver.equals("com.alibaba.druid.pool.xa.DruidXADataSource")) {
                        DruidXADataSource druid = new DruidXADataSource();
                        druid.setUrl(profile.getURL());
                        druid.setUsername(profile.getUser());
                        druid.setPassword(profile.getPassword());
                        druid.setMaxActive(200);
                        this.setDataSourceProfile((DataSource)druid, profile, 2);
                        ds.setXaDataSourceClassName(dbDriver);
                        ds.setXaDataSource((XADataSource)druid);
                    } else {
                        ds.setXaDataSourceClassName(dbDriver);
                        Properties properties = new Properties();
                        int dbType = profile.getDBType();
                        properties.put(dbType == 4 ? "url" : "URL", profile.getURL());
                        properties.put("password", profile.getPassword());
                        ds.setMinPoolSize(10);
                        ds.setMaxPoolSize(300);
                        properties.put("user", profile.getUser());
                        if (dbType == 4) {
                            properties.put("pinGlobalTxToPhysicalConnection", "true");
                        }
                        ds.setXaProperties(properties);
                    }
                    this.setDataSourceProfile((DataSource)ds, profile, 1);
                    dsCache.put(key, ds);
                }
            }
        }
        return (DataSource)dsCache.get(key);
    }

    private void setDataSourceProfile(DataSource ds, IConnectionProfile profile, int extType) {
        String[] extPropNames;
        String[] stringArray = extPropNames = extType == 1 ? profile.getExtPropNames() : ((MdbConnectionProfile)profile).getExtPropNames2();
        if (extPropNames != null) {
            Method[] methods = ds.getClass().getMethods();
            HashMap<String, Method> mapMethod = new HashMap<String, Method>();
            int length = methods.length;
            Method method = null;
            String methodName = null;
            String propName = null;
            int i = 0;
            while (i < length) {
                method = methods[i];
                methodName = method.getName();
                if (methodName.length() > 3 && methodName.substring(0, 3).equals("set")) {
                    propName = methodName.substring(3);
                    mapMethod.put(propName.toLowerCase(), method);
                }
                ++i;
            }
            length = extPropNames.length;
            i = 0;
            while (i < length) {
                String extPropName = extPropNames[i];
                method = (Method)mapMethod.get(extPropName.toLowerCase());
                if (method != null) {
                    Class<?>[] paraTypes = method.getParameterTypes();
                    Class<?> type = null;
                    if (paraTypes != null && paraTypes.length == 1) {
                        String value;
                        String string = value = extType == 1 ? profile.getExtProp(extPropName) : ((MdbConnectionProfile)profile).getExtProp2(extPropName);
                        if (value != null && !value.isEmpty()) {
                            type = paraTypes[0];
                            ArrayList<String> paraValue = null;
                            if (type == Integer.class || type == Integer.TYPE) {
                                paraValue = Integer.parseInt(value);
                            } else if (type == String.class) {
                                paraValue = value;
                            } else if (type == BigDecimal.class) {
                                paraValue = new BigDecimal(value);
                            } else if (type == Double.class || type == Double.TYPE) {
                                paraValue = Double.parseDouble(value);
                            } else if (type == Long.class || type == Long.TYPE) {
                                paraValue = Long.parseLong(value);
                            } else if (type == Float.class || type == Float.TYPE) {
                                paraValue = Float.valueOf(Float.parseFloat(value));
                            } else if (type == Boolean.class || type == Boolean.TYPE) {
                                paraValue = Boolean.parseBoolean(value);
                            } else if (type == Collection.class) {
                                String[] tmpValues = value.split(";");
                                int tmpLength = tmpValues.length;
                                ArrayList<String> listValue = new ArrayList<String>();
                                int j = 0;
                                while (j < tmpLength) {
                                    listValue.add(tmpValues[j]);
                                    ++j;
                                }
                                paraValue = listValue;
                            }
                            try {
                                method.invoke((Object)ds, paraValue);
                            }
                            catch (Throwable e) {
                                logger.debug(e.getMessage());
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    public Connection getConnection(IConnectionProfile profile) throws Exception {
        DataSource ds = this.getDataSource(profile);
        logger.debug("getConnection..DSN:{} dsHashCode:{}", (Object)profile.getKey(), (Object)ds.hashCode());
        Connection connection = ds.getConnection();
        if (connection.getAutoCommit()) {
            connection.setAutoCommit(false);
        }
        if (connection.getTransactionIsolation() != 2) {
            connection.setTransactionIsolation(2);
        }
        return connection;
    }
}

