/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.erp.dev;

import com.bokesoft.erp.metaobjectchange.MetaObjectChange;
import com.bokesoft.erp.metaobjectchange.MetaObjectChangeListener;
import com.bokesoft.yes.base.IStartListener;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.erp.dev.MetaTableKeyIgnoreCase;
import com.bokesoft.yes.mid.materializedquery.InitMaterializedQuery;
import com.bokesoft.yes.mid.materializedquery.MaterializedQueryStruct;
import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationList;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationProfile;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import com.bokesoft.yigo.tools.ve.VE;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetaTableCache
implements IStartListener {
    private static final Logger logger = LoggerFactory.getLogger(MetaTableCache.class);
    private static Map<String, MetaTableKeyIgnoreCase> metaTables = new ConcurrentHashMap<String, MetaTableKeyIgnoreCase>();
    private static final Set<String> processDataObject = new ConcurrentSkipListSet<String>();
    private static Map<String, String> delayCachedFormKeys = new ConcurrentHashMap<String, String>();
    private static boolean parallel = true;

    static {
        MetaObjectChange.register((MetaObjectChangeListener)new MetaObjectChangeListener(){

            public void changeMetaAll() {
                MetaTableCache.clearAllTableCache();
            }

            public void changeMetaForm(MetaForm metaForm) throws Throwable {
                MetaDataSource dataSource = metaForm.getDataSource();
                if (dataSource == null) {
                    return;
                }
                MetaDataObject dataObject = dataSource.getDataObject();
                this.changeMetaDataObject(dataObject);
            }

            public void batchChangeMetaForm(CopyOnWriteArrayList<MetaForm> metaForms) throws Throwable {
                if (metaForms == null || metaForms.size() == 0) {
                    return;
                }
                CopyOnWriteArrayList<String> formKeys = new CopyOnWriteArrayList<String>();
                boolean hasPersistTable = false;
                for (MetaForm metaForm : metaForms) {
                    MetaDataObject dataObject;
                    boolean tmpHasPersistTable;
                    formKeys.add(metaForm.getKey());
                    MetaDataSource dataSource = metaForm.getDataSource();
                    if (dataSource == null || !(tmpHasPersistTable = this.hasPersistTable(dataObject = dataSource.getDataObject()))) continue;
                    hasPersistTable = true;
                }
                if (!hasPersistTable) {
                    return;
                }
                logger.debug(">>> MetaTableCache.BatchChangeMetaForm: {}", formKeys);
                MetaTableCache.clearAllTableCache();
            }

            public void clearTableCache(MetaDataObject dataObject) {
                LogSvr.getInstance().info("\u8868\u7ed3\u6784\u7f13\u5b58\u6e05\u9664com.bokesoft.yes.erp.dev.MetaTableCache.clearTableCache().");
                StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
                int i = 1;
                while (i < stackTraceElements.length) {
                    StackTraceElement stackTraceElement = stackTraceElements[i];
                    String className = stackTraceElement.getClassName();
                    LogSvr.getInstance().info(String.valueOf(className) + " " + stackTraceElement.getMethodName() + " " + stackTraceElement.getLineNumber());
                    ++i;
                }
                for (MetaTable table : dataObject.getTableCollection()) {
                    String key = table.getBindingDBTableName().toLowerCase();
                    metaTables.remove(key);
                }
                processDataObject.remove(dataObject.getKey());
            }

            public void changeMetaDataObject(MetaDataObject dataObject) throws Throwable {
                boolean hasPersistTable = this.hasPersistTable(dataObject);
                if (!hasPersistTable) {
                    return;
                }
                MetaTableCache.clearAllTableCache();
            }

            private boolean hasPersistTable(MetaDataObject dataObject) {
                if (dataObject == null) {
                    return false;
                }
                MetaTableCollection tableCollection = dataObject.getTableCollection();
                if (tableCollection == null || tableCollection.isEmpty()) {
                    return false;
                }
                boolean hasPersist = false;
                for (MetaTable metaTable : dataObject.getTableCollection()) {
                    if (!metaTable.isPersist().booleanValue()) continue;
                    hasPersist = true;
                    break;
                }
                return hasPersist;
            }
        }, (String)"TableCacheAll");
    }

    private static synchronized MetaTableKeyIgnoreCase getMetaTableKeyIgnoreCase(String tableKey) throws Throwable {
        if (!metaTables.containsKey(tableKey = tableKey.toLowerCase())) {
            MetaTableCache.getFullMetaTable(tableKey);
        }
        return metaTables.get(tableKey);
    }

    public static MetaTable getFullMetaTable(String tableKey) throws Throwable {
        if (StringUtil.isBlankOrNull((String)tableKey)) {
            return null;
        }
        MetaTableKeyIgnoreCase metaTableKeyIgnoreCase = MetaTableCache.getMetaTableByTableKey(tableKey);
        return metaTableKeyIgnoreCase != null ? metaTableKeyIgnoreCase.metaTable : null;
    }

    public static MetaTable getFullMetaTableWithNotPersist(String tableKey) throws Throwable {
        MetaTable fullMetaTable = MetaTableCache.getFullMetaTable(tableKey);
        if (fullMetaTable == null) {
            fullMetaTable = MetaTableCache.getFullMetaTable(String.valueOf(tableKey) + "notpersist");
        }
        return fullMetaTable;
    }

    public static List<MetaTable> getMetaTablesByColumn(String columnName) throws Throwable {
        if (StringUtil.isBlankOrNull((String)columnName)) {
            return null;
        }
        Map<String, MetaTableKeyIgnoreCase> tmpAll = MetaTableCache.init();
        ArrayList<MetaTable> result = new ArrayList<MetaTable>();
        block0: for (MetaTableKeyIgnoreCase tmp : tmpAll.values()) {
            MetaTable metaTable = tmp.metaTable;
            for (MetaColumn metaColumn : metaTable) {
                if (!columnName.equalsIgnoreCase(metaColumn.getKey())) continue;
                result.add(metaTable);
                continue block0;
            }
        }
        return result;
    }

    public static void updateMetaTables(IMetaFactory metaFactory, MetaDataMigration dataMigration) throws Throwable {
        MetaTable erpMigrationNewTable;
        MetaTable erpMigrationIncrTable;
        MetaTable erpMigrationKeysTable;
        Map<String, MetaTableKeyIgnoreCase> tempMetaTables = metaTables;
        String tgtDataObjectKey = dataMigration.getTgtDataObjectKey();
        MetaDataObject dataObject = metaFactory.getDataObject(tgtDataObjectKey);
        String dataObjectKey = dataObject.getKey();
        MetaTableCache.addDataObject(tempMetaTables, dataObject, "", null);
        String projectKey = dataMigration.getProject().getKey();
        MetaTable migrationLastPointTable = dataObject.getMigrationLastPointTable();
        if (migrationLastPointTable != null) {
            MetaTableCache.addMetaTable(tempMetaTables, projectKey, migrationLastPointTable, dataObjectKey, "", null);
        }
        if ((erpMigrationKeysTable = dataObject.getErpMigrationKeysTable()) != null) {
            MetaTableCache.addMetaTable(tempMetaTables, projectKey, erpMigrationKeysTable, dataObjectKey, "", null);
        }
        if ((erpMigrationIncrTable = dataObject.getErpMigrationIncrTable()) != null) {
            MetaTableCache.addMetaTable(tempMetaTables, projectKey, erpMigrationIncrTable, dataObjectKey, "", null);
        }
        if ((erpMigrationNewTable = dataObject.getErpMigrationNewTable()) != null) {
            MetaTableCache.addMetaTable(tempMetaTables, projectKey, erpMigrationNewTable, dataObjectKey, "", null);
        }
    }

    public static synchronized Map<String, MetaTableKeyIgnoreCase> getMetaTables() {
        return metaTables;
    }

    public static synchronized Set<String> getProcessDataObject() {
        return processDataObject;
    }

    private static synchronized Map<String, MetaTableKeyIgnoreCase> init() throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        return MetaTableCache.initByMetaFactory(metaFactory);
    }

    private static synchronized MetaTableKeyIgnoreCase getMetaTableByTableKey(String tableKey) throws Throwable {
        if (metaTables.size() == 0) {
            metaTables = MetaTableCache.init();
        }
        return metaTables.get(tableKey.toLowerCase());
    }

    public static synchronized Map<String, MetaTableKeyIgnoreCase> initByMetaFactory(IMetaFactory metaFactory) throws Throwable {
        if (metaTables.size() == 0) {
            metaTables = MetaTableCache.init(metaFactory, null);
        }
        return metaTables;
    }

    private static void processMetaFormProfile(Map<String, MetaTableKeyIgnoreCase> tempMetaTables, IMetaFactory metaFactory, MetaFormProfile metaFormProfile, List<Object> checkInfos) throws Throwable {
        MetaDataObject dataObject;
        if (metaFormProfile == null) {
            return;
        }
        MetaForm metaForm = metaFactory.getMetaForm(metaFormProfile.getKey());
        String extendFormKey = metaForm.getExtend();
        if (!StringUtil.isBlankOrNull((String)extendFormKey)) {
            MetaForm sourceMetaForm = metaFactory.getMetaForm(extendFormKey);
            if (metaForm.getFormType() != sourceMetaForm.getFormType()) {
                return;
            }
        }
        if (metaForm.getFormType() == 8) {
            return;
        }
        if (metaForm.getDataSource() != null && (dataObject = metaForm.getDataSource().getDataObject()) != null && dataObject.getPrimaryType() == 2) {
            return;
        }
        MetaTableCache.addMetaForm(tempMetaTables, metaFactory, metaForm, checkInfos);
    }

    public static void addDelayCachedFormKey(String ... formKeys) {
        if (formKeys == null || formKeys.length == 0) {
            return;
        }
        String[] stringArray = formKeys;
        int n = formKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String formKey = stringArray[n2];
            delayCachedFormKeys.put(formKey.intern(), null);
            ++n2;
        }
    }

    public static List<Object> check(IMetaFactory metaFactory) throws Throwable {
        ArrayList<Object> checkInfos = new ArrayList<Object>();
        MetaTableCache.init(metaFactory, checkInfos);
        return checkInfos;
    }

    public static void setParallel(boolean parallel) {
        MetaTableCache.parallel = parallel;
    }

    private static Map<String, MetaTableKeyIgnoreCase> init(IMetaFactory metaFactory, List<Object> checkInfos) throws Throwable {
        ConcurrentHashMap<String, MetaTableKeyIgnoreCase> tempMetaTables = new ConcurrentHashMap<String, MetaTableKeyIgnoreCase>(4500);
        return MetaTableCache.init(metaFactory, checkInfos, tempMetaTables);
    }

    public static Map<String, MetaTableKeyIgnoreCase> init(IMetaFactory metaFactory, List<Object> checkInfos, Map<String, MetaTableKeyIgnoreCase> tempMetaTables) throws Throwable {
        MetaDataObject dataObject;
        if (checkInfos == null) {
            LogSvr.getInstance().info("\u8868\u7ed3\u6784\u7f13\u5b58\u521d\u59cb\u5316\u5f00\u59cb.");
        }
        if (InitMaterializedQuery.mq != null) {
            MaterializedQueryStruct struct = MaterializedQueryStruct.getStruct(InitMaterializedQuery.mq);
            tempMetaTables.put(struct.mq.key.toLowerCase(), new MetaTableKeyIgnoreCase(struct.getMetaTable()));
        }
        MetaFormList metaFormList = metaFactory.getMetaFormList();
        if (parallel) {
            Stream<MetaFormProfile> stream = StreamSupport.stream(metaFormList.spliterator(), true);
            stream.forEachOrdered(metaFormProfile -> {
                try {
                    String key = metaFormProfile.getKey();
                    if (delayCachedFormKeys.size() > 0 && delayCachedFormKeys.get(key) != null) {
                        return;
                    }
                    MetaTableCache.processMetaFormProfile(tempMetaTables, metaFactory, metaFormProfile, checkInfos);
                }
                catch (Throwable e) {
                    logger.error(e.getMessage(), e);
                }
            });
            if (delayCachedFormKeys.size() > 0) {
                for (String key : delayCachedFormKeys.keySet()) {
                    MetaFormProfile formProfile = (MetaFormProfile)metaFormList.get(key);
                    MetaTableCache.processMetaFormProfile(tempMetaTables, metaFactory, formProfile, checkInfos);
                }
                delayCachedFormKeys.clear();
            }
        } else {
            int i = 0;
            while (i < metaFormList.size()) {
                MetaFormProfile metaFormProfile2 = (MetaFormProfile)metaFormList.get(i);
                MetaTableCache.initMetaFormTableCache(metaFactory, checkInfos, metaFormProfile2, tempMetaTables);
                ++i;
            }
        }
        MetaDataMigrationList dataMigrationList = metaFactory.getDataMigrationList();
        for (MetaDataMigrationProfile dataMigrationProfile : dataMigrationList) {
            MetaTable erpMigrationNewTable;
            MetaTable erpMigrationIncrTable;
            MetaTable erpMigrationKeysTable;
            MetaDataMigration dataMigration;
            if (dataMigrationProfile == null || (dataMigration = metaFactory.getDataMigration(dataMigrationProfile.getKey())) == null) continue;
            String tgtDataObjectKey = dataMigration.getTgtDataObjectKey();
            dataObject = metaFactory.getDataObject(tgtDataObjectKey);
            DataObjects.updateMDGroupColumnKeys(dataObject);
            String dataObjectKey = dataObject.getKey();
            MetaTableCache.addDataObject(tempMetaTables, dataObject, "", checkInfos);
            String projectKey = dataMigration.getProject().getKey();
            MetaTable migrationLastPointTable = dataObject.getMigrationLastPointTable();
            if (migrationLastPointTable != null) {
                MetaTableCache.addMetaTable(tempMetaTables, projectKey, migrationLastPointTable, dataObjectKey, "", checkInfos);
            }
            if ((erpMigrationKeysTable = dataObject.getErpMigrationKeysTable()) != null) {
                MetaTableCache.addMetaTable(tempMetaTables, projectKey, erpMigrationKeysTable, dataObjectKey, "", checkInfos);
            }
            if ((erpMigrationIncrTable = dataObject.getErpMigrationIncrTable()) != null) {
                MetaTableCache.addMetaTable(tempMetaTables, projectKey, erpMigrationIncrTable, dataObjectKey, "", checkInfos);
            }
            if ((erpMigrationNewTable = dataObject.getErpMigrationNewTable()) == null) continue;
            MetaTableCache.addMetaTable(tempMetaTables, projectKey, erpMigrationNewTable, dataObjectKey, "", checkInfos);
        }
        MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
        for (MetaDataObjectProfile metaDataObjectProfile : dataObjectList) {
            dataObject = metaDataObjectProfile.getDataObject();
            if (dataObject == null || processDataObject.contains(dataObject.getKey())) continue;
            MetaTableCache.addDataObject(tempMetaTables, dataObject, "", checkInfos);
        }
        if (checkInfos == null) {
            LogSvr.getInstance().info("\u8868\u7ed3\u6784\u7f13\u5b58\u521d\u59cb\u5316\u5b8c\u6210.");
        }
        return tempMetaTables;
    }

    public static void initMetaFormTableCache(IMetaFactory metaFactory, List<Object> checkInfos, MetaFormProfile metaFormProfile, Map<String, MetaTableKeyIgnoreCase> tempMetaTables) throws Throwable {
        MetaDataObject dataObject;
        if (metaFormProfile == null) {
            return;
        }
        MetaForm metaForm = metaFactory.getMetaForm(metaFormProfile.getKey());
        String extendFormKey = metaForm.getExtend();
        if (!StringUtil.isBlankOrNull((String)extendFormKey)) {
            MetaForm sourceMetaForm = metaFactory.getMetaForm(extendFormKey);
            if (metaForm.getFormType() != sourceMetaForm.getFormType()) {
                return;
            }
        }
        if (metaForm.getFormType() == 8) {
            return;
        }
        if (metaForm.getDataSource() != null && (dataObject = metaForm.getDataSource().getDataObject()) != null && dataObject.getPrimaryType() == 2) {
            return;
        }
        MetaTableCache.addMetaForm(tempMetaTables, metaFactory, metaForm, checkInfos);
    }

    private static void addMetaForm(Map<String, MetaTableKeyIgnoreCase> tempMetaTables, IMetaFactory metaFactory, MetaForm metaForm, List<Object> checkInfos) throws Throwable {
        if (metaForm == null) {
            return;
        }
        MetaDataSource dataSource = metaForm.getDataSource();
        if (dataSource == null || dataSource.getDataObject() == null) {
            return;
        }
        MetaDataObject dataObject = dataSource.getDataObject();
        String relateObjectKey = dataSource.getRefObjectKey();
        if (!StringUtil.isBlankOrNull((String)relateObjectKey)) {
            dataObject = metaFactory.getDataObject(relateObjectKey);
        }
        MetaTableCache.addDataObject(tempMetaTables, dataObject, metaForm.getKey(), checkInfos);
    }

    public static void addDataObject(Map<String, MetaTableKeyIgnoreCase> tempMetaTables, MetaDataObject dataObject, String formKey, List<Object> checkInfos) throws Throwable {
        if (dataObject == null) {
            return;
        }
        MetaTableCollection tableCollection = dataObject.getTableCollection();
        if (tableCollection == null) {
            return;
        }
        if (dataObject.getPrimaryType() == 2) {
            return;
        }
        for (MetaTable table : tableCollection) {
            MetaTableCache.addMetaTable(tempMetaTables, dataObject.getProjectKey(), table, dataObject.getKey(), formKey, checkInfos);
        }
    }

    private static void addMetaTable(Map<String, MetaTableKeyIgnoreCase> tempMetaTables, String projectKey, MetaTable table, String dataObjectKey, String formKey, List<Object> checkInfos) throws Throwable {
        MetaTable metaTable;
        if (table == null) {
            return;
        }
        String tableName = table.getBindingDBTableName();
        MetaTableKeyIgnoreCase metaTableKeyIgnoreCase = null;
        MetaTableKeyIgnoreCase tmpMetaTableKeyIgnoreCase = null;
        boolean tableIsPersist = table.isPersist();
        String mapKey = null;
        if (!tableIsPersist) {
            mapKey = String.valueOf(tableName.toLowerCase()) + "notpersist";
            tmpMetaTableKeyIgnoreCase = metaTableKeyIgnoreCase = tempMetaTables.get(mapKey);
            if (metaTableKeyIgnoreCase == null) {
                tmpMetaTableKeyIgnoreCase = new MetaTableKeyIgnoreCase(tableName, dataObjectKey, formKey);
            }
        } else {
            mapKey = tableName.toLowerCase();
            tmpMetaTableKeyIgnoreCase = metaTableKeyIgnoreCase = tempMetaTables.get(mapKey);
            if (metaTableKeyIgnoreCase == null) {
                tmpMetaTableKeyIgnoreCase = new MetaTableKeyIgnoreCase(tableName, dataObjectKey, formKey);
            }
        }
        if (!(metaTable = tmpMetaTableKeyIgnoreCase.metaTable).isPersist().booleanValue() && tableIsPersist) {
            metaTable.setPersist(Boolean.valueOf(true));
        }
        Iterator it = table.entryIterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            MetaColumn column = (MetaColumn)entry.getValue();
            String key = column.getBindingDBColumnName();
            key = tmpMetaTableKeyIgnoreCase.getKeyCaseSameInTable(key);
            MetaColumn existColumn = (MetaColumn)metaTable.get(key);
            MetaTableCache.checkSameColumnType(projectKey, column, existColumn, tmpMetaTableKeyIgnoreCase, dataObjectKey, formKey, checkInfos);
            if (existColumn != null) {
                boolean columnPersist;
                boolean bl = columnPersist = tableIsPersist && column.isPersist() != false;
                if (!columnPersist) continue;
                existColumn.setPersist(Boolean.valueOf(true));
                continue;
            }
            MetaColumn cloneColumn = (MetaColumn)column.clone();
            cloneColumn.setKey(key.intern());
            if (!tableIsPersist) {
                cloneColumn.setPersist(Boolean.valueOf(false));
            }
            tmpMetaTableKeyIgnoreCase.addColumn(cloneColumn);
        }
        if (!metaTable.containsKey("Slock")) {
            MetaColumn slockMetaColumn = new MetaColumn();
            slockMetaColumn.setKey("Slock");
            slockMetaColumn.setDataType(Integer.valueOf(1001));
            slockMetaColumn.setPersist(Boolean.valueOf(false));
            tmpMetaTableKeyIgnoreCase.addColumn(slockMetaColumn);
        }
        if (metaTableKeyIgnoreCase == null) {
            tempMetaTables.put(mapKey.intern(), tmpMetaTableKeyIgnoreCase);
        }
        processDataObject.add(dataObjectKey);
    }

    private static void checkSameColumnType(String projectKey, MetaColumn curColumn, MetaColumn existColumn, MetaTableKeyIgnoreCase existTable, String curDataObjectKey, String curFormKey, List<Object> checkInfos) throws Throwable {
        String tableName;
        if (existColumn == null || curColumn == null || existTable == null || existTable.metaTable == null || !existColumn.isPersist().booleanValue() || !curColumn.isPersist().booleanValue()) {
            return;
        }
        String string = tableName = StringUtil.isBlankOrNull((String)existTable.metaTable.getDBTableName()) ? existTable.metaTable.getKey() : existTable.metaTable.getDBTableName();
        if (existColumn.getDataType().intValue() != curColumn.getDataType().intValue()) {
            StringBuilder oError = new StringBuilder();
            oError.append("\u914d\u7f6e\u6587\u4ef6\u4e2d\u5b58\u5728\u8868\u540d\u76f8\u540c\uff0c\u4f46\u5217\u7c7b\u578b\u4e0d\u4e00\u81f4\u7684\u60c5\u51b5\uff0c\u8bf7\u4fee\u6539\u914d\u7f6e\uff0c \u53c2\u8003\u4fe1\u606f:  \u5de5\u7a0b ").append(projectKey).append(" \u4e2d\uff1aformKey1=").append(existTable.formKey).append("; dataObjectKey1=").append(existTable.dataObjectKey).append("; formKey2=").append(curFormKey).append("; dataObjectKey2=").append(curDataObjectKey).append("; dbTableName=").append(tableName).append("; columnKey1=").append(existColumn.getKey()).append("; dataType1=").append(DataType.toString((Integer)existColumn.getDataType())).append("; columnKey2=").append(curColumn.getKey()).append("; dataType2=").append(DataType.toString((Integer)curColumn.getDataType()));
            if (checkInfos != null) {
                checkInfos.add(oError.toString());
            } else {
                LogSvr.getInstance().info(oError.toString());
            }
        }
    }

    public void invoke(DefaultContext context) throws Throwable {
        MetaTableCache.initByMetaFactory(context.getVE().getMetaFactory());
    }

    public static synchronized void clearAllTableCache() {
        LogSvr.getInstance().info("\u8868\u7ed3\u6784\u7f13\u5b58\u6e05\u9664com.bokesoft.yes.erp.dev.MetaTableCache.clearAllTableCache().");
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        int i = 1;
        while (i < stackTraceElements.length) {
            StackTraceElement stackTraceElement = stackTraceElements[i];
            String className = stackTraceElement.getClassName();
            LogSvr.getInstance().info(String.valueOf(className) + " " + stackTraceElement.getMethodName() + " " + stackTraceElement.getLineNumber());
            ++i;
        }
        if (metaTables != null) {
            metaTables.clear();
            processDataObject.clear();
            LogSvr.getInstance().info("\u8868\u7ed3\u6784\u7f13\u5b58\u6e05\u9664\u5b8c\u6210com.bokesoft.yes.erp.dev.MetaTableCache.clearAllTableCache().");
        }
    }

    public static DataTable newEmptyDataTable(MetaTable metaTable) throws Throwable {
        DataTable result;
        MetaTableKeyIgnoreCase metaTableKeyIgnoreCase = MetaTableCache.getMetaTableKeyIgnoreCase(metaTable.getKey());
        DataTableMetaData tableMetaData = metaTableKeyIgnoreCase.getDataTableMetaDataCache();
        if (tableMetaData == null) {
            result = MetaTableCache.newEmptyDataTable(metaTable, null);
            metaTableKeyIgnoreCase.setDataTableMetaDataCache(result.getMetaData());
        } else {
            result = new DataTable(tableMetaData);
        }
        result.setKey(metaTable.getKey());
        result.setCheckLength(metaTable.isPersist().booleanValue());
        return result;
    }

    public static int[] getIgnoreQueryColumnIndexes(MetaTable metaTable) throws Throwable {
        int[] ignoreQueryColumnIndexesCache = MetaTableCache.getMetaTableKeyIgnoreCase(metaTable.getKey()).getIgnoreQueryColumnIndexesCache();
        if (ignoreQueryColumnIndexesCache == null) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        return ignoreQueryColumnIndexesCache;
    }

    public static DataTable newEmptyDataTable(MetaTable metaTable, DataTable result) throws Throwable {
        HashMapIgnoreCase keys = new HashMapIgnoreCase();
        DataTable table = new DataTable();
        DataTableMetaData tableMetaData = table.getMetaData();
        table.setKey(metaTable.getKey());
        table.setCheckLength(metaTable.isPersist().booleanValue());
        Iterator it = metaTable.iterator();
        MetaColumn metaColumn = null;
        ArrayList<Integer> ignoreQueryColumnIndexes = new ArrayList<Integer>();
        ArrayList<ColumnInfo> ignoreQueryColumnInfos = new ArrayList<ColumnInfo>();
        while (it.hasNext()) {
            metaColumn = (MetaColumn)it.next();
            if (metaColumn.isHidden().booleanValue()) continue;
            String columnKey = metaColumn.getBindingDBColumnName();
            if (keys.containsKey(columnKey)) {
                throw new RuntimeException("\u7a0b\u5e8f\u9519\u8bef\uff0c\u91cd\u590d\u52a0\u8f7d\u5b57\u6bb5\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u3002/n" + metaTable.getKey() + ":" + columnKey + " \u5f53\u524d\u5df2\u7ecf\u5b58\u5728\u7684keys=" + keys.toString() + " \u5f53\u524dmetaTable\u4e2d\u6240\u6709colKey=" + MetaTableCache.getMetaTableAllColKey(metaTable));
            }
            ColumnInfo column = new ColumnInfo(columnKey, metaColumn.getDataType().intValue());
            column.setAccessControl(metaColumn.isAccessControl());
            column.setPrimary(metaColumn.getIsPrimary());
            column.setScale(metaColumn.getScale());
            column.setLength(metaColumn.getLength());
            column.setCheckLength(metaColumn.isPersist().booleanValue());
            if (metaColumn.isIgnoreQuery().booleanValue() || !metaColumn.isPersist().booleanValue() && !metaColumn.isSupportI18n().booleanValue()) {
                ignoreQueryColumnIndexes.add(tableMetaData.getColumnCount());
                ignoreQueryColumnInfos.add(column);
            } else {
                tableMetaData.addColumn(column);
            }
            keys.put(columnKey, null);
        }
        for (ColumnInfo column : ignoreQueryColumnInfos) {
            tableMetaData.addColumn(column);
        }
        int[] tmp = ArrayUtils.toPrimitive((Integer[])ignoreQueryColumnIndexes.toArray(new Integer[ignoreQueryColumnIndexes.size()]));
        MetaTableCache.getMetaTableKeyIgnoreCase(metaTable.getKey()).setIgnoreQueryColumnIndexesCache(tmp);
        if (result != null) {
            DataTableMetaData metaData = result.getMetaData();
            int index = 0;
            int size = metaData.getColumnCount();
            while (index < size) {
                ColumnInfo columnInfo = metaData.getColumnInfo(index);
                String columnKey = columnInfo.getColumnKey();
                if (!keys.containsKey(columnKey)) {
                    ColumnInfo deepClone = columnInfo.deepClone();
                    int dataType = deepClone.getDataType();
                    if (dataType == 1002 || dataType == 1012 || dataType == 1011) {
                        deepClone.setLength(Integer.MAX_VALUE);
                    }
                    tableMetaData.addColumn(deepClone);
                    keys.put(columnKey, null);
                }
                ++index;
            }
        }
        return table;
    }

    public static void append(DataTable src, DataTable tgt) throws Throwable {
        DataTableMetaData srcMetaData = src.getMetaData();
        HashMapIgnoreCase srcColumnNames = new HashMapIgnoreCase();
        int index = 0;
        int size = srcMetaData.getColumnCount();
        while (index < size) {
            ColumnInfo columnInfo = srcMetaData.getColumnInfo(index);
            srcColumnNames.put(columnInfo.getColumnKey(), (Object)columnInfo);
            ++index;
        }
        int count = tgt.getMetaData().getColumnCount();
        int srcRowIndex = 0;
        int size2 = src.size();
        while (srcRowIndex < size2) {
            int tgtRowIndex = tgt.append();
            tgt.setState(tgt.getState());
            int index2 = 0;
            while (index2 < count) {
                ColumnInfo columnInfo = tgt.getMetaData().getColumnInfo(index2);
                String columnKey = columnInfo.getColumnKey();
                int dataType = columnInfo.getDataType();
                if (srcColumnNames.containsKey(columnKey)) {
                    tgt.setObject(tgtRowIndex, index2, TypeConvertor.toDataType((int)dataType, (Object)src.getObject(srcRowIndex, columnKey)));
                }
                ++index2;
            }
            ++srcRowIndex;
        }
    }

    private static SqlString getColumnNames(IDBManager dbManager, String[] formKeys, String metaTableKey, String[] dataObjectKeys) throws Throwable {
        MetaTableKeyIgnoreCase metaTableKeyIgnoreCase = MetaTableCache.getMetaTableKeyIgnoreCase(metaTableKey);
        SqlString result = metaTableKeyIgnoreCase.getColumnNameCache();
        if (result == null) {
            boolean firstColumn = true;
            MetaTable metaTable = MetaTableCache.getFullMetaTable(metaTableKey);
            if (metaTable != null) {
                SqlString sql = new SqlString();
                HashMapIgnoreCase existColumns = new HashMapIgnoreCase();
                for (MetaColumn metaColumn : metaTable) {
                    String columnName;
                    if (metaColumn.isPersist().booleanValue() && !metaColumn.isIgnoreQuery().booleanValue()) {
                        columnName = dbManager.keyWordEscape(metaColumn.getBindingDBColumnName());
                        if (existColumns.containsKey(columnName)) continue;
                        if (!firstColumn) {
                            sql.append(",");
                        }
                        sql.append(columnName);
                        existColumns.put(columnName, null);
                        firstColumn = false;
                        continue;
                    }
                    if (!metaColumn.isSupportI18n().booleanValue() || existColumns.containsKey(columnName = dbManager.keyWordEscape(metaColumn.getBindingDBColumnName()))) continue;
                    if (!firstColumn) {
                        sql.append(",");
                    }
                    SqlString str = new SqlString().appendPara("");
                    sql.append(str).append(columnName);
                    existColumns.put(columnName, null);
                    firstColumn = false;
                }
                result = sql;
            } else {
                result = SqlString.SqlString_Null;
                LogSvr.getInstance().info("\u8868" + metaTableKey + "\u83b7\u53d6\u6240\u6709\u5217\u9519\u8bef\uff01");
            }
            metaTableKeyIgnoreCase.setColumnNameCache(result);
        }
        return result;
    }

    public static SqlString getMultilLangCol(String lang, MetaTable metaTable, String colName) {
        if (StringUtil.isBlankOrNull((String)lang)) {
            lang = "zh-CN";
        }
        SqlString str = new SqlString();
        str.append("(select T." + colName + " from " + metaTable.getBindingDBTableName() + "_T T where " + metaTable.getBindingDBTableName() + ".OID=T.SrcLangOID and T.Lang=").appendPara(lang).append(") as ");
        return str;
    }

    public static SqlString getMultilLangCol(IDBManager dbManager, MetaTable metaTable, String colName) {
        VE ve = dbManager.getVE();
        String lang = "zh-CN";
        if (ve != null) {
            lang = ve.getEnv().getLocale();
        }
        return MetaTableCache.getMultilLangCol(lang, metaTable, colName);
    }

    public static SqlString getMultilLangCol(IDBManager dbManager, String tableName, String colKey) throws Throwable {
        MetaTable metaTable = MetaTableCache.getFullMetaTable(tableName);
        MetaColumn col = (MetaColumn)metaTable.get(colKey);
        if (!col.isSupportI18n().booleanValue()) {
            return new SqlString();
        }
        return MetaTableCache.getMultilLangCol(dbManager, metaTable, col.getBindingDBColumnName());
    }

    public static SqlString getMultilLangCol(IDBManager dbManager, String tableName, String colKey, String alias) throws Throwable {
        MetaTable metaTable = MetaTableCache.getFullMetaTable(tableName);
        MetaColumn col = (MetaColumn)metaTable.get(colKey);
        if (!col.isSupportI18n().booleanValue()) {
            return new SqlString();
        }
        VE ve = dbManager.getVE();
        String lang = "zh-CN";
        if (ve != null) {
            lang = ve.getEnv().getLocale();
        }
        return new SqlString().append("(select T." + col.getBindingDBColumnName() + " from " + tableName + "_T T where " + (!StringUtil.isBlankOrNull((String)alias) ? alias : tableName) + ".OID=T.SrcLangOID and T.Lang=").appendPara(lang).append(") as ");
    }

    public static SqlString getDefaultSelect(String tableName, IDBManager dbManager) throws Throwable {
        MetaTableKeyIgnoreCase metaTableKeyIgnoreCase = MetaTableCache.getMetaTableKeyIgnoreCase(tableName);
        if (metaTableKeyIgnoreCase == null) {
            LogSvr.getInstance().info("\u8868" + tableName + "\u83b7\u53d6\u9ed8\u8ba4SelectSQL\u9519\u8bef\uff01");
            return null;
        }
        SqlString result = metaTableKeyIgnoreCase.getDefaultSelect();
        if (result == null) {
            SqlString columnNames = MetaTableCache.getColumnNames(dbManager, null, tableName, null);
            if (columnNames != null && columnNames != SqlString.SqlString_Null) {
                result = new SqlString(1024).append("select ", columnNames, " from ", tableName);
                metaTableKeyIgnoreCase.setDefaultSelect(result);
            } else {
                metaTableKeyIgnoreCase.setDefaultSelect(SqlString.SqlString_Null);
                LogSvr.getInstance().info("\u8868" + tableName + "\u83b7\u53d6\u9ed8\u8ba4SelectSQL\u9519\u8bef\uff01");
            }
        } else if (result == SqlString.SqlString_Null) {
            LogSvr.getInstance().info("\u8868" + tableName + "\u83b7\u53d6\u9ed8\u8ba4SelectSQL\u9519\u8bef\uff01");
            return null;
        }
        return result;
    }

    public static boolean isExistColumn(String tableName, String columnName) throws Throwable {
        MetaTableKeyIgnoreCase metaTable = MetaTableCache.getMetaTableByTableKey(tableName);
        return metaTable != null && metaTable.containsColumn(columnName);
    }

    public static int getDataType(String tableName, String columnName) throws Throwable {
        return MetaTableCache.getMetaTableByTableKey(tableName).getColumn(columnName).getDataType();
    }

    public static int getLength(String tableName, String columnName) throws Throwable {
        return MetaTableCache.getMetaTableByTableKey(tableName).getColumn(columnName).getLength();
    }

    public static int getPrecision(String tableName, String columnName) throws Throwable {
        return MetaTableCache.getMetaTableByTableKey(tableName).getColumn(columnName).getPrecision();
    }

    public static int getScale(String tableName, String columnName) throws Throwable {
        return MetaTableCache.getMetaTableKeyIgnoreCase(tableName).getColumn(columnName).getScale();
    }

    private static List<String> getMetaTableAllColKey(MetaTable metaTable) {
        final ArrayList<String> list = new ArrayList<String>();
        metaTable.items().forEach(new Consumer<MetaColumn>(){

            @Override
            public void accept(MetaColumn col) {
                list.add(col.getKey());
            }
        });
        return list;
    }
}

