/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.datastruct.metaload;

import com.bokesoft.yes.datastruct.meta.MetaDataStruct;
import com.bokesoft.yes.datastruct.meta.MetaDataStructTable;
import com.bokesoft.yes.datastruct.metaload.AndExp;
import com.bokesoft.yes.datastruct.metaload.ColumnExp;
import com.bokesoft.yes.datastruct.metaload.CompareExp;
import com.bokesoft.yes.datastruct.metaload.ValueRange;
import com.bokesoft.yes.datastruct.metaload.WhereExp;
import com.bokesoft.yes.erp.dev.MetaTableCache;
import com.bokesoft.yes.mid.mysqls.processselect.ParsedSqlUtil;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import java.util.ArrayList;
import java.util.List;
import net.boke.jsqlparser.JSQLParserException;
import net.boke.jsqlparser.expression.BinaryExpression;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.LongValue;
import net.boke.jsqlparser.expression.StringValue;
import net.boke.jsqlparser.expression.operators.conditional.AndExpression;
import net.boke.jsqlparser.expression.operators.relational.EqualsTo;
import net.boke.jsqlparser.expression.operators.relational.ExpressionList;
import net.boke.jsqlparser.expression.operators.relational.GreaterThan;
import net.boke.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.boke.jsqlparser.expression.operators.relational.InExpression;
import net.boke.jsqlparser.expression.operators.relational.MinorThan;
import net.boke.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.boke.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.boke.jsqlparser.parser.CCJSqlParserManager;
import net.boke.jsqlparser.schema.Column;

public class WhereExpUtils {
    public static Expression parseExpression(String whereClause) throws JSQLParserException {
        CCJSqlParserManager parser = new CCJSqlParserManager();
        return parser.parseExpression(whereClause);
    }

    public static WhereExp parseWhereClause(String whereClause, MetaDataStructTable table, boolean isInDSTable, MetaDataStruct dataStruct) throws Throwable {
        Expression expression = WhereExpUtils.parseExpression(whereClause);
        return WhereExpUtils.parseWhereClause(expression, table, isInDSTable, dataStruct);
    }

    private static WhereExp parseWhereClause(Expression expression, MetaDataStructTable table, boolean isInDSTable, MetaDataStruct dataStruct) throws Throwable {
        if (expression instanceof AndExpression) {
            AndExpression tmp = (AndExpression)expression;
            WhereExp left = WhereExpUtils.parseWhereClause(tmp.getLeftExpression(), table, isInDSTable, dataStruct);
            if (left instanceof AndExp) {
                return ((AndExp)left).addExpression(WhereExpUtils.parseWhereClause(tmp.getRightExpression(), table, isInDSTable, dataStruct));
            }
            return new AndExp(left, WhereExpUtils.parseWhereClause(tmp.getRightExpression(), table, isInDSTable, dataStruct));
        }
        if (expression instanceof EqualsTo) {
            BinaryExpression tmp = (BinaryExpression)expression;
            Expression left = tmp.getLeftExpression();
            Object leftObj = ParsedSqlUtil.isConstant(left) ? WhereExpUtils.parseWhereClauseConst(left) : WhereExpUtils.parseWhereClauseColumn(left, table, isInDSTable, dataStruct);
            Expression right = tmp.getRightExpression();
            Object rightObj = ParsedSqlUtil.isConstant(right) ? WhereExpUtils.parseWhereClauseConst(right) : WhereExpUtils.parseWhereClauseColumn(right, table, isInDSTable, dataStruct);
            return new CompareExp(leftObj, rightObj, 2);
        }
        if (expression instanceof EqualsTo || expression instanceof NotEqualsTo || expression instanceof GreaterThan || expression instanceof GreaterThanEquals || expression instanceof MinorThan || expression instanceof MinorThanEquals) {
            BinaryExpression tmp = (BinaryExpression)expression;
            Expression left = tmp.getLeftExpression();
            Object leftObj = ParsedSqlUtil.isConstant(left) ? WhereExpUtils.parseWhereClauseConst(left) : WhereExpUtils.parseWhereClauseColumn(left, table, isInDSTable, dataStruct);
            Expression right = tmp.getRightExpression();
            Object rightObj = ParsedSqlUtil.isConstant(right) ? WhereExpUtils.parseWhereClauseConst(right) : WhereExpUtils.parseWhereClauseColumn(right, table, isInDSTable, dataStruct);
            return new CompareExp(leftObj, rightObj, WhereExpUtils.getBinaryOp(expression));
        }
        if (expression instanceof InExpression) {
            InExpression tmp = (InExpression)expression;
            Expression left = tmp.getLeftExpression();
            ColumnExp leftObj = WhereExpUtils.parseWhereClauseColumn(left, table, isInDSTable, dataStruct);
            List values = ((ExpressionList)tmp.getItemsList()).getExpressions();
            int size = values.size();
            Object[] rightObj = new Object[size];
            int i = 0;
            while (i < values.size()) {
                Object value = values.get(i);
                rightObj[i] = WhereExpUtils.parseWhereClauseConst((Expression)value);
                ++i;
            }
            return new CompareExp(leftObj, rightObj, 8);
        }
        throw new AssertionError((Object)"\u6761\u4ef6\u53ea\u652f\u6301and\uff0c=\u3001!=\u3001>\u3001>=\u3001<\u3001<=\u6bd4\u8f83\u7b26\uff0c\u5b57\u6bb5In\u5e38\u91cf\u3002");
    }

    private static int getBinaryOp(Expression exp) {
        if (exp instanceof EqualsTo) {
            return 2;
        }
        if (exp instanceof NotEqualsTo) {
            return 5;
        }
        if (exp instanceof GreaterThan) {
            return 4;
        }
        if (exp instanceof GreaterThanEquals) {
            return 1;
        }
        if (exp instanceof MinorThan) {
            return 6;
        }
        if (exp instanceof MinorThanEquals) {
            return 3;
        }
        throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784\u89e3\u6790\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f\uff0c" + exp.toString()));
    }

    private static ColumnExp parseWhereClauseColumn(Expression expression, MetaDataStructTable table, boolean isInDSTable, MetaDataStruct dataStruct) throws Throwable {
        if (expression instanceof Column) {
            Column column = (Column)expression;
            if (isInDSTable) {
                String columnTableName = column.getTable().getWholeTableName();
                MetaDataStructTable columnTable = dataStruct.getTableByKeyOrName(columnTableName);
                MetaTable metaTable = MetaTableCache.getFullMetaTable(columnTable.getRefTable());
                MetaColumn metaColumn = (MetaColumn)metaTable.get(column.getColumnName());
                return new ColumnExp(columnTable, metaColumn);
            }
            MetaTable metaTable = MetaTableCache.getFullMetaTable(table.getRefTable());
            MetaColumn metaColumn = (MetaColumn)metaTable.get(column.getColumnName());
            return new ColumnExp(table, metaColumn);
        }
        throw new AssertionError((Object)("\u6761\u4ef6\u5185\u5bb9" + expression.toString() + "\u4e0d\u662f\u5b57\u6bb5\u3002"));
    }

    private static Object parseWhereClauseConst(Expression expression) {
        if (expression instanceof LongValue) {
            return Long.valueOf(((LongValue)expression).getValue()).intValue();
        }
        if (expression instanceof StringValue) {
            return ((StringValue)expression).getValue();
        }
        throw new AssertionError((Object)("\u5e38\u91cf" + expression.toString() + "\u4e0d\u662f\u6574\u578b\u6216\u5b57\u7b26\u4e32\uff0c\u7c7b\u578b\u4e0d\u652f\u6301\u3002"));
    }

    public static int[] checkWhereIsolation(WhereExp[] whereExps, MetaDataStructTable table) throws Throwable {
        int length = whereExps.length;
        int i = 0;
        while (i < length) {
            int j = i + 1;
            while (j < length) {
                if (!WhereExpUtils.checkWhereIsolation(whereExps[i], whereExps[j], table)) {
                    return new int[]{i, j};
                }
                ++i;
            }
            ++i;
        }
        return null;
    }

    public static boolean checkWhereIsolation(WhereExp exp1, WhereExp exp2, MetaDataStructTable table) throws Throwable {
        if (exp1 == null || exp2 == null) {
            return false;
        }
        List<ColumnExp> columns1 = exp1.getColumns(table);
        List<ColumnExp> columns2 = exp2.getColumns(table);
        ArrayList<ColumnExp> sameColumns = new ArrayList<ColumnExp>();
        for (ColumnExp tmp : columns1) {
            if (!columns2.contains(tmp)) continue;
            sameColumns.add(tmp);
        }
        for (ColumnExp column : sameColumns) {
            ValueRange valueRange2;
            ValueRange valueRange1 = exp1.getValueRange(column);
            if (!valueRange1.isIntersect(valueRange2 = exp2.getValueRange(column))) continue;
            return false;
        }
        return true;
    }
}

