/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.datastruct.metaload;

import com.bokesoft.yes.common.struct.RefObject;
import com.bokesoft.yes.datastruct.meta.MetaDataStruct;
import com.bokesoft.yes.datastruct.meta.MetaDataStructColumn;
import com.bokesoft.yes.datastruct.meta.MetaDataStructSource;
import com.bokesoft.yes.datastruct.meta.MetaDataStructSourceColumn;
import com.bokesoft.yes.datastruct.meta.MetaDataStructTable;
import com.bokesoft.yes.datastruct.metaload.DataStructSourceTableNode;
import com.bokesoft.yes.datastruct.metaload.DataStructSourceTableTree;
import com.bokesoft.yes.datastruct.metaload.WhereExp;
import com.bokesoft.yes.datastruct.metaload.WhereExpUtils;
import com.bokesoft.yes.erp.dev.MetaTableCache;
import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yes.mid.mysqls.processselect.ParsedSqlUtil;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.boke.jsqlparser.JSQLParserException;
import net.boke.jsqlparser.expression.BinaryExpression;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.operators.conditional.AndExpression;
import net.boke.jsqlparser.expression.operators.relational.EqualsTo;
import net.boke.jsqlparser.expression.operators.relational.ExpressionList;
import net.boke.jsqlparser.expression.operators.relational.GreaterThan;
import net.boke.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.boke.jsqlparser.expression.operators.relational.InExpression;
import net.boke.jsqlparser.expression.operators.relational.ItemsList;
import net.boke.jsqlparser.expression.operators.relational.MinorThan;
import net.boke.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.boke.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.boke.jsqlparser.schema.Column;

public class MetaDataStructCheck {
    public static void check(MetaDataStruct dataStruct, MetaDataStructSource[] dataStructSources) throws Throwable {
        MetaDataStructCheck.checkWhereClause(dataStruct, dataStructSources);
        MetaDataStructCheck.checkColumnType(dataStruct, dataStructSources);
        MetaDataStructCheck.checkRefTable(dataStruct);
        MetaDataStructCheck.checkSourceOriginalTable(dataStructSources);
        MetaDataStructCheck.checkDBTableName(dataStruct, dataStructSources);
        MetaDataStructCheck.checkOneDataOneSource(dataStruct, dataStructSources);
        MetaDataStructCheck.checkConstValueAndOriginalTable(dataStructSources);
        MetaDataStructCheck.checkTableRefField(dataStruct, dataStructSources);
        MetaDataStructCheck.checkNotExistMultiToMulti(dataStruct, dataStructSources);
    }

    private static void checkWhereClause(MetaDataStruct dataStruct, MetaDataStructSource[] dataStructSources) throws Throwable {
        Iterator iterator = dataStruct.getColumnCollection().iterator();
        while (iterator.hasNext()) {
            MetaDataStructColumn column = (MetaDataStructColumn)iterator.next();
            String whereClause = column.getWhereClause();
            if (column.isKeyField()) {
                if (whereClause == null || whereClause.length() <= 0) continue;
                try {
                    MetaDataStructCheck.checkWhereClause(whereClause, column.getDataStructTableKey(), true, dataStruct);
                    continue;
                }
                catch (AssertionError e) {
                    throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784" + dataStruct.getKey() + "\u7684\u5b57\u6bb5" + column.getKey() + "\u7684\u6761\u4ef6\u68c0\u67e5\u4e0d\u901a\u8fc7\uff0c" + ((Throwable)((Object)e)).getMessage()));
                }
            }
            if (whereClause != null && whereClause.length() > 0) {
                throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784" + dataStruct.getKey() + "\u7684\u5b57\u6bb5" + column.getKey() + "\u5b9a\u4e49\u4e86\u6761\u4ef6\uff0c\u9519\u8bef\uff0c\u53ea\u6709\u6570\u636e\u7ed3\u6784\u5173\u8054\u5b57\u6bb5\u80fd\u5b9a\u4e49\u6761\u4ef6\u3002"));
            }
        }
        MetaDataStructSource[] metaDataStructSourceArray = dataStructSources;
        int n = dataStructSources.length;
        int n2 = 0;
        while (n2 < n) {
            MetaDataStructSource source = metaDataStructSourceArray[n2];
            Iterator iterator2 = source.getColumnCollection().iterator();
            while (iterator2.hasNext()) {
                MetaDataStructSourceColumn column = (MetaDataStructSourceColumn)iterator2.next();
                String whereClause = column.getWhereClause();
                if (whereClause == null || whereClause.length() <= 0) continue;
                MetaDataStructColumn dsColumn = (MetaDataStructColumn)dataStruct.getColumnCollection().get(column.getKey());
                if (!dsColumn.isKeyField()) {
                    throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784\u6e90" + source.getKey() + "\u7684\u5b57\u6bb5" + column.getKey() + "\u4e0d\u662f\u5173\u8054\u5b57\u6bb5\uff0c\u4f46\u8bbe\u7f6e\u4e86\u6761\u4ef6\uff0c\u9519\u8bef\u3002"));
                }
                try {
                    MetaDataStructCheck.checkWhereClause(whereClause, dsColumn.getDataStructTableKey(), false, dataStruct);
                }
                catch (AssertionError e) {
                    throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784\u6e90" + source.getKey() + "\u5b57\u6bb5" + column.getKey() + "\u7684\u6761\u4ef6\u68c0\u67e5\u4e0d\u901a\u8fc7\uff0c" + ((Throwable)((Object)e)).getMessage()));
                }
            }
            ++n2;
        }
    }

    private static boolean checkWhereClause(String whereClause, String table, boolean isInDSTable, MetaDataStruct dataStruct) throws Throwable {
        Expression expression;
        try {
            expression = WhereExpUtils.parseExpression(whereClause);
        }
        catch (JSQLParserException e) {
            throw new AssertionError((Object)(String.valueOf(whereClause) + "\u89e3\u6790\u9519\u8bef\uff0c" + e.getMessage()));
        }
        return MetaDataStructCheck.checkWhereClause(expression, whereClause, table, isInDSTable, dataStruct);
    }

    private static boolean checkWhereClause(Expression expression, String whereClause, String table, boolean isInDSTable, MetaDataStruct dataStruct) throws Throwable {
        if (expression instanceof AndExpression) {
            AndExpression tmp = (AndExpression)expression;
            return MetaDataStructCheck.checkWhereClause(tmp.getLeftExpression(), whereClause, table, isInDSTable, dataStruct) && MetaDataStructCheck.checkWhereClause(tmp.getRightExpression(), whereClause, table, isInDSTable, dataStruct);
        }
        if (expression instanceof EqualsTo || expression instanceof NotEqualsTo || expression instanceof GreaterThan || expression instanceof GreaterThanEquals || expression instanceof MinorThan || expression instanceof MinorThanEquals) {
            BinaryExpression tmp = (BinaryExpression)expression;
            Expression left = tmp.getLeftExpression();
            Expression right = tmp.getRightExpression();
            return !(!ParsedSqlUtil.isConstant(left) && !MetaDataStructCheck.checkWhereClauseColumn(left, whereClause, table, isInDSTable, dataStruct) || !ParsedSqlUtil.isConstant(right) && !MetaDataStructCheck.checkWhereClauseColumn(right, whereClause, table, isInDSTable, dataStruct));
        }
        if (expression instanceof InExpression) {
            InExpression tmp = (InExpression)expression;
            Expression left = tmp.getLeftExpression();
            MetaDataStructCheck.checkWhereClauseColumn(left, whereClause, table, isInDSTable, dataStruct);
            ItemsList right = tmp.getItemsList();
            if (right instanceof ExpressionList) {
                List values = ((ExpressionList)right).getExpressions();
                int i = 0;
                while (i < values.size()) {
                    Object value = values.get(i);
                    if (value instanceof Expression) {
                        if (ParsedSqlUtil.isConstant((Expression)value)) {
                            throw new AssertionError((Object)("\u6761\u4ef6\u5185\u5bb9" + expression.toString() + "\u4e0d\u5168\u662f\u5e38\u91cf\u3002"));
                        }
                    } else {
                        throw new AssertionError((Object)("\u6761\u4ef6\u5185\u5bb9" + expression.toString() + "\u4e0d\u5168\u662f\u5e38\u91cf\u3002"));
                    }
                    ++i;
                }
                return true;
            }
            throw new AssertionError((Object)("\u6761\u4ef6\u5185\u5bb9" + expression.toString() + "\u4e0d\u5168\u662f\u5e38\u91cf\u3002"));
        }
        throw new AssertionError((Object)"\u6761\u4ef6\u53ea\u652f\u6301and\uff0c=\u3001!=\u3001>\u3001>=\u3001<\u3001<=\u6bd4\u8f83\u7b26\uff0c\u5b57\u6bb5In\u5e38\u91cf\u3002");
    }

    private static boolean checkWhereClauseColumn(Expression expression, String whereClause, String tableKey, boolean isInDSTable, MetaDataStruct dataStruct) throws Throwable {
        if (expression instanceof Column) {
            Column column = (Column)expression;
            if (isInDSTable) {
                String columnTableName = column.getTable().getWholeTableName();
                MetaDataStructTable columnTable = dataStruct.getTableByKeyOrName(columnTableName);
                if (columnTable == null) {
                    throw new AssertionError((Object)("\u5b57\u6bb5" + column + "\u4e2d\u7684\u8868\u540d\u4e0d\u5b58\u5728\u3002"));
                }
                if (!MetaTableCache.isExistColumn(columnTable.getRefTable(), column.getColumnName())) {
                    throw new AssertionError((Object)("\u5b57\u6bb5" + column + "\u5728\u6570\u636e\u5e93\uff08Yigo\u7684\u914d\u7f6e\u4e2d\uff09\u4e0d\u5b58\u5728\u3002"));
                }
                return true;
            }
            String columnTableName = column.getTable() != null && column.getTable().getName() != null ? column.getTable().getName() : tableKey;
            MetaDataStructTable columnTable = dataStruct.getTableByKeyOrName(columnTableName);
            if (!MetaTableCache.isExistColumn(columnTable.getRefTable(), column.getColumnName())) {
                throw new AssertionError((Object)("\u5b57\u6bb5" + column + "\u5728\u6570\u636e\u5e93\uff08Yigo\u7684\u914d\u7f6e\u4e2d\uff09\u4e0d\u5b58\u5728\u3002"));
            }
            return true;
        }
        throw new AssertionError((Object)("\u6761\u4ef6\u5185\u5bb9" + expression.toString() + "\u4e0d\u662f\u5b57\u6bb5\u3002"));
    }

    private static void checkColumnType(MetaDataStruct dataStruct, MetaDataStructSource[] dataStructSources) throws Throwable {
        RefObject errorInfo = new RefObject(null);
        Iterator iterator = dataStruct.getColumnCollection().iterator();
        while (iterator.hasNext()) {
            MetaDataStructColumn column = (MetaDataStructColumn)iterator.next();
            if (column.isKeyField()) {
                column.setDataType(1010);
                MetaDataStructSource[] metaDataStructSourceArray = dataStructSources;
                int n = dataStructSources.length;
                int n2 = 0;
                while (n2 < n) {
                    MetaDataStructSource source = metaDataStructSourceArray[n2];
                    MetaDataStructSourceColumn sourceColumn = (MetaDataStructSourceColumn)source.getColumnCollection().get(column.getKey());
                    if (sourceColumn != null) {
                        String constValue = sourceColumn.getConstValue();
                        if (constValue != null && constValue.length() > 0) {
                            if (!MetaDataStructCheck.checkConstValueType(constValue, 1010, (RefObject<String>)errorInfo)) {
                                throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784\u6e90" + source.getKey() + "\u4e2d\u5b57\u6bb5" + sourceColumn.getKey() + "\u7c7b\u578b\u4e0d\u5bf9\uff0c" + (String)errorInfo.getValue()));
                            }
                        } else if (sourceColumn.getOriginalRealTable() != null && sourceColumn.getOriginalRealTable().length() > 0) {
                            if (!MetaTableCache.isExistColumn(sourceColumn.getOriginalRealTable(), sourceColumn.getOriginalColumn())) {
                                throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784\u6e90" + source.getKey() + "\u4e2d\u5b57\u6bb5" + sourceColumn.getKey() + "\u5728\u6570\u636e\u5e93\uff08Yigo\u914d\u7f6e\uff09\u4e2d\u4e0d\u5b58\u5728\u3002"));
                            }
                            if (MetaTableCache.getDataType(sourceColumn.getOriginalRealTable(), sourceColumn.getOriginalColumn()) != 1010) {
                                throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784\u6e90" + source.getKey() + "\u4e2d\u5b57\u6bb5" + sourceColumn.getKey() + "\u6307\u5411\u5173\u8054\u5b57\u6bb5\uff0c\u7c7b\u578b\u4e0d\u4e3aLong\uff0c\u9519\u8bef\u3002"));
                            }
                        }
                    }
                    ++n2;
                }
                continue;
            }
            if (column.isTableRefField()) {
                String columnName;
                String tableName = ((MetaDataStructTable)dataStruct.getTableCollection().get(column.getDataStructTableKey())).getRefTable();
                if (!MetaTableCache.isExistColumn(tableName, columnName = column.getRefColumn())) {
                    throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784" + dataStruct.getKey() + "\u4e2d\u5b57\u6bb5" + column.getKey() + "\u7684\u5f15\u7528\u5b57\u6bb5\u5728\u6570\u636e\u5e93\uff08Yigo\u914d\u7f6e\uff09\u4e2d\u4e0d\u5b58\u5728\u3002"));
                }
                int dataType = MetaTableCache.getDataType(tableName, columnName);
                if (dataType == 1002) {
                    column.setLength(MetaTableCache.getLength(tableName, columnName));
                } else if (dataType == 1005) {
                    column.setPrecision(MetaTableCache.getPrecision(tableName, columnName));
                    column.setScale(MetaTableCache.getScale(tableName, columnName));
                }
                column.setDataType(dataType);
                MetaDataStructSource[] metaDataStructSourceArray = dataStructSources;
                int n = dataStructSources.length;
                int sourceColumn = 0;
                while (sourceColumn < n) {
                    MetaDataStructSource source = metaDataStructSourceArray[sourceColumn];
                    MetaDataStructSourceColumn sourceColumn2 = (MetaDataStructSourceColumn)source.getColumnCollection().get(column.getKey());
                    if (sourceColumn2 != null) {
                        throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784\u6e90" + source.getKey() + "\u4e2d\u5b57\u6bb5" + sourceColumn2.getKey() + "\u6307\u5411\u5173\u7cfb\u5f15\u7528\u5b57\u6bb5\uff0c\u9519\u8bef\u3002"));
                    }
                    ++sourceColumn;
                }
                continue;
            }
            if (!column.isOtherField()) continue;
            int dataType = -1;
            int length = 0;
            int precision = 0;
            int scale = 0;
            MetaDataStructSource[] metaDataStructSourceArray = dataStructSources;
            int n = dataStructSources.length;
            int n3 = 0;
            while (n3 < n) {
                MetaDataStructSource source = metaDataStructSourceArray[n3];
                MetaDataStructSourceColumn sourceColumn = (MetaDataStructSourceColumn)source.getColumnCollection().get(column.getKey());
                if (sourceColumn != null) {
                    int sourceDataType;
                    String constValue = sourceColumn.getConstValue();
                    int sourceLength = 0;
                    int sourcePrecision = 0;
                    int sourceScale = 0;
                    if (constValue != null && constValue.length() > 0) {
                        sourceDataType = MetaDataStructCheck.getConstValueType(constValue);
                        if (sourceDataType == 1002) {
                            sourceLength = (constValue.length() - 2) * 5;
                        }
                    } else {
                        sourceDataType = MetaTableCache.getDataType(sourceColumn.getOriginalRealTable(), sourceColumn.getOriginalColumn());
                        if (sourceDataType == 1002) {
                            sourceLength = MetaTableCache.getDataType(sourceColumn.getOriginalRealTable(), sourceColumn.getOriginalColumn());
                        } else if (sourceDataType == 1005) {
                            sourcePrecision = MetaTableCache.getPrecision(sourceColumn.getOriginalRealTable(), sourceColumn.getOriginalColumn());
                            sourceScale = MetaTableCache.getScale(sourceColumn.getOriginalRealTable(), sourceColumn.getOriginalColumn());
                        }
                    }
                    if (dataType == -1) {
                        dataType = sourceDataType;
                        length = sourceLength;
                        precision = sourcePrecision;
                        scale = sourceScale;
                    } else {
                        if (dataType != sourceDataType) {
                            throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784\u6e90" + source.getKey() + "\u4e2d\u5b57\u6bb5" + sourceColumn.getKey() + "\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u6307\u5411\u540c\u4e00\u5b57\u6bb5\u7684\u6e90\u7c7b\u578b\u5e94\u76f8\u540c\u3002"));
                        }
                        dataType = Integer.max(dataType, sourceLength);
                        if (precision != sourcePrecision || scale != sourceScale) {
                            throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784\u6e90" + source.getKey() + "\u4e2d\u5b57\u6bb5" + sourceColumn.getKey() + "\u7c7b\u578b\u6570\u503c\u7cbe\u5ea6\u6216\u5c0f\u6570\u4f4d\u6570\u4e0d\u4e00\u81f4\uff0c\u6307\u5411\u540c\u4e00\u5b57\u6bb5\u7684\u6e90\u7c7b\u578b\u5e94\u76f8\u540c\u3002"));
                        }
                    }
                }
                ++n3;
            }
            if (dataType == -1) {
                throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784" + dataStruct.getKey() + "\u4e2d\u5b57\u6bb5" + column.getKey() + "\u5728\u6e90\u4e2d\u6ca1\u6709\u88ab\u5f15\u7528\uff0c\u53ef\u80fd\u662f\u4e2a\u9519\u8bef\u3002"));
            }
            column.setDataType(dataType);
            column.setLength(length);
            column.setPrecision(precision);
            column.setScale(scale);
        }
    }

    private static int getConstValueType(String constValue) {
        if (constValue.length() > 2 && constValue.startsWith("'") && constValue.endsWith("'")) {
            return 1002;
        }
        return 1001;
    }

    private static boolean checkConstValueType(String constValue, int dataType, RefObject<String> errorInfo) {
        if (dataType == 1010) {
            try {
                Long.parseLong(constValue);
            }
            catch (NumberFormatException e) {
                errorInfo.setValue((Object)("\u5e38\u91cf\u503c" + constValue + "\u4e0d\u662f\u957f\u6574\u578b\u3002"));
                return false;
            }
            return true;
        }
        if (dataType == 1001) {
            try {
                Integer.parseInt(constValue);
            }
            catch (NumberFormatException e) {
                errorInfo.setValue((Object)("\u5e38\u91cf\u503c" + constValue + "\u4e0d\u662f\u6574\u578b\u3002"));
                return false;
            }
            return true;
        }
        if (dataType == 1002) {
            if (constValue.length() < 2 || !constValue.startsWith("'") || !constValue.endsWith("'")) {
                errorInfo.setValue((Object)("\u5e38\u91cf\u503c" + constValue + "\u4e0d\u662f\u5b57\u7b26\u4e32\u7c7b\u578b\u3002"));
                return false;
            }
            return true;
        }
        errorInfo.setValue((Object)("\u5e38\u91cf\u4e0d\u652f\u6301" + DataType.toString((Integer)dataType) + "\u7c7b\u578b\u3002"));
        return false;
    }

    private static void checkRefTable(MetaDataStruct dataStruct) throws Throwable {
        Iterator iterator = dataStruct.getTableCollection().iterator();
        while (iterator.hasNext()) {
            MetaDataStructTable table = (MetaDataStructTable)iterator.next();
            String refTable = table.getRefTable();
            String dataObjectKey = table.getRefDataObject();
            String formKey = table.getRefForm();
            if (formKey != null && formKey.length() > 0 && (dataObjectKey == null || dataObjectKey.length() == 0)) {
                dataObjectKey = MetaFactory.getGlobalInstance().getMetaForm(formKey).getDataSource().getDataObject().getKey();
                table.setCalcedRefDataObject(dataObjectKey);
            }
            if (dataObjectKey != null && dataObjectKey.length() > 0) {
                MetaDataObject metaDataObject = MetaFactory.getGlobalInstance().getDataObject(dataObjectKey);
                if (DataObjects.getMetaTableByTableNameIgnoreCase(metaDataObject, refTable) == null) {
                    throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784" + dataStruct.getKey() + "\u4e2d\u8868" + table.getKey() + "\u7684\u539f\u59cb\u8868\u4e0d\u5b58\u5728\u3002"));
                }
            } else {
                if (dataObjectKey == null || dataObjectKey.length() == 0) {
                    List<MetaDataObject> metaDataObjects = MetaDataStructCheck.removeRepeatDataObject(DataObjects.getInstance().getDataObjectsByTableName(table.getRefTable()));
                    if (metaDataObjects == null || metaDataObjects.size() > 1) {
                        throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784" + dataStruct.getKey() + "\u4e2d\u8868" + table.getKey() + "\u7684\u539f\u59cb\u8868\u4e0d\u5b58\u5728\u6216\u65e0\u6cd5\u5b9a\u4f4d\u4e00\u4e2a\u6570\u636e\u5bf9\u8c61\uff0c" + MetaDataStructCheck.getMetaDataObjectKeys(metaDataObjects) + "\u3002"));
                    }
                    dataObjectKey = metaDataObjects.get(0).getKey();
                }
                table.setCalcedRefDataObject(dataObjectKey);
            }
            if (formKey != null && formKey.length() != 0) continue;
            List<MetaForm> metaForms = MetaDataStructCheck.getMetaFormsByDataObject(MetaFactory.getGlobalInstance().getDataObject(dataObjectKey));
            if (metaForms == null || metaForms.size() > 1) {
                throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784" + dataStruct.getKey() + "\u4e2d\u8868" + table.getKey() + "\u7684\u539f\u59cb\u8868\u4e0d\u5b58\u5728\u6216\u65e0\u6cd5\u5b9a\u4f4d\u4e00\u4e2a\u8868\u5355\uff0c" + MetaDataStructCheck.getMetaFormKeys(metaForms) + "\u3002"));
            }
            formKey = metaForms.get(0).getKey();
            table.setCalcedRefForm(formKey);
        }
    }

    private static void checkSourceOriginalTable(MetaDataStructSource[] dataStructSources) throws Throwable {
        MetaDataStructSource[] metaDataStructSourceArray = dataStructSources;
        int n = dataStructSources.length;
        int n2 = 0;
        while (n2 < n) {
            MetaDataStructSource source = metaDataStructSourceArray[n2];
            Iterator iterator = source.getColumnCollection().iterator();
            while (iterator.hasNext()) {
                String formKey;
                MetaDataStructSourceColumn sourceColumn = (MetaDataStructSourceColumn)iterator.next();
                String originalTable = sourceColumn.getOriginalTable();
                if (originalTable == null || originalTable.length() <= 0) continue;
                String originalRealTable = sourceColumn.getOriginalRealTable();
                int pos = originalTable.indexOf(".");
                String prefix = pos > 0 ? originalTable.substring(0, pos) : null;
                String dataObjectKey = prefix != null && prefix.startsWith("[") ? null : prefix;
                String string = formKey = prefix != null && prefix.startsWith("[") && prefix.length() > 2 ? prefix.substring(1, prefix.length() - 1) : null;
                if (formKey != null) {
                    dataObjectKey = MetaFactory.getGlobalInstance().getMetaForm(formKey).getDataSource().getDataObject().getKey();
                }
                if (dataObjectKey != null) {
                    MetaDataObject metaDataObject = MetaFactory.getGlobalInstance().getDataObject(dataObjectKey);
                    if (DataObjects.getMetaTableByTableNameIgnoreCase(metaDataObject, originalRealTable) == null) {
                        throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784\u6e90" + source.getKey() + "\u4e2d\u5b57\u6bb5" + sourceColumn.getKey() + "\u7684\u539f\u59cb\u8868\u4e0d\u5b58\u5728\u3002"));
                    }
                } else {
                    List<MetaDataObject> metaDataObjects = MetaDataStructCheck.removeRepeatDataObject(DataObjects.getInstance().getDataObjectsByTableName(originalRealTable));
                    if (metaDataObjects == null || metaDataObjects.size() > 1) {
                        throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784\u6e90" + source.getKey() + "\u4e2d\u5b57\u6bb5" + sourceColumn.getKey() + "\u7684\u539f\u59cb\u8868\u4e0d\u5b58\u5728\u6216\u65e0\u6cd5\u5b9a\u4f4d\u4e00\u4e2a\u6570\u636e\u5bf9\u8c61\uff0c" + MetaDataStructCheck.getMetaDataObjectKeys(metaDataObjects) + "\u3002"));
                    }
                    dataObjectKey = metaDataObjects.get(0).getKey();
                }
                if (formKey == null) {
                    List<MetaForm> metaForms = MetaDataStructCheck.getMetaFormsByDataObject(MetaFactory.getGlobalInstance().getDataObject(dataObjectKey));
                    if (metaForms == null || metaForms.size() > 1) {
                        throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784\u6e90" + source.getKey() + "\u4e2d\u5b57\u6bb5" + sourceColumn.getKey() + "\u7684\u539f\u59cb\u8868\u4e0d\u5b58\u5728\u6216\u65e0\u6cd5\u5b9a\u4f4d\u4e00\u4e2a\u8868\u5355\uff0c" + MetaDataStructCheck.getMetaFormKeys(metaForms) + "\u3002"));
                    }
                    formKey = metaForms.get(0).getKey();
                }
                sourceColumn.setOriginalDataObjectKey(dataObjectKey);
                sourceColumn.setOriginalFormKey(formKey);
            }
            ++n2;
        }
    }

    private static List<MetaForm> getMetaFormsByDataObject(MetaDataObject metaDataObject) throws Throwable {
        ArrayList<MetaForm> result = new ArrayList<MetaForm>();
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        for (MetaFormProfile formProfile : metaFactory.getMetaFormList()) {
            MetaForm metaForm = metaFactory.getMetaForm(formProfile.getKey());
            if (metaForm.getDataSource() == null || metaForm.getDataSource().getDataObject() != metaDataObject) continue;
            result.add(metaForm);
        }
        return result;
    }

    public static List<MetaDataObject> removeRepeatDataObject(List<MetaDataObject> list) {
        if (list == null || list.size() <= 1) {
            return list;
        }
        List<MetaDataObject> result = MetaDataStructCheck.removeRepeatDataObjectOne(list);
        while (result.size() != list.size()) {
            list = result;
            result = MetaDataStructCheck.removeRepeatDataObjectOne(list);
        }
        return result;
    }

    private static List<MetaDataObject> removeRepeatDataObjectOne(List<MetaDataObject> list) {
        ArrayList<MetaDataObject> result = new ArrayList<MetaDataObject>(list.size());
        for (MetaDataObject tmp : list) {
            if (tmp.getPrimaryType() == 2) continue;
            boolean isProcessed = false;
            int i = 0;
            int size = result.size();
            while (i < size) {
                MetaDataObject tmpInResult = (MetaDataObject)result.get(i);
                if (MetaDataStructCheck.isDataObjectInclude(tmpInResult, tmp)) {
                    isProcessed = true;
                    break;
                }
                if (MetaDataStructCheck.isDataObjectInclude(tmp, tmpInResult)) {
                    result.set(i, tmp);
                    isProcessed = true;
                    break;
                }
                ++i;
            }
            if (isProcessed) continue;
            result.add(tmp);
        }
        return result;
    }

    private static boolean isDataObjectInclude(MetaDataObject dataObject1, MetaDataObject dataObject2) {
        int tableCount2;
        if (dataObject1 == dataObject2) {
            return true;
        }
        MetaTableCollection tables1 = dataObject1.getTableCollection();
        MetaTableCollection tables2 = dataObject2.getTableCollection();
        int tableCount1 = tables1 == null ? 0 : tables1.size();
        int n = tableCount2 = tables2 == null ? 0 : tables2.size();
        if (tableCount1 < tableCount2) {
            return false;
        }
        int i = 0;
        while (i < tableCount2) {
            MetaTable table2 = (MetaTable)tables2.get(i);
            if (table2.isPersist().booleanValue()) {
                MetaTable table1 = (MetaTable)tables1.get(table2.getKey());
                if (table1 == null) {
                    return false;
                }
                for (MetaColumn column2 : table2) {
                    if (!column2.isPersist().booleanValue() && column2.isIgnoreQuery().booleanValue() || table1.get(column2.getKey()) != null) continue;
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    static String getMetaDataObjectKeys(List<MetaDataObject> list) {
        if (list == null) {
            return "null";
        }
        int size = list.size();
        if (size == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(128).append("[").append(list.get(0).getKey());
        int i = 1;
        while (i < size) {
            sb.append(",").append(list.get(i).getKey());
            ++i;
        }
        return sb.append("]").toString();
    }

    private static String getMetaFormKeys(List<MetaForm> list) {
        if (list == null) {
            return "null";
        }
        int size = list.size();
        if (size == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(128).append("[").append(list.get(0).getKey());
        int i = 1;
        while (i < size) {
            sb.append(",").append(list.get(i).getKey());
            ++i;
        }
        return sb.append("]").toString();
    }

    private static void checkDBTableName(MetaDataStruct dataStruct, MetaDataStructSource[] dataStructSources) {
        boolean hasDBTableName;
        boolean hasKeyField = false;
        boolean hasOtherField = false;
        boolean hasTableRefField = false;
        Iterator iterator = dataStruct.getColumnCollection().iterator();
        while (iterator.hasNext()) {
            MetaDataStructColumn column = (MetaDataStructColumn)iterator.next();
            hasKeyField = hasKeyField || column.isKeyField();
            hasTableRefField = hasTableRefField || column.isTableRefField();
            boolean bl = hasOtherField = hasOtherField || column.isOtherField();
        }
        boolean isSameTable = true;
        MetaDataStructSource[] metaDataStructSourceArray = dataStructSources;
        int n = dataStructSources.length;
        int n2 = 0;
        while (n2 < n) {
            MetaDataStructSource source = metaDataStructSourceArray[n2];
            String originalTable = null;
            Iterator iterator2 = source.getColumnCollection().iterator();
            while (iterator2.hasNext()) {
                MetaDataStructSourceColumn sourceColumn = (MetaDataStructSourceColumn)iterator2.next();
                String colunmOriginalTable = sourceColumn.getOriginalRealTable();
                if (originalTable == null) {
                    if (colunmOriginalTable == null) continue;
                    originalTable = colunmOriginalTable;
                    continue;
                }
                if (originalTable == colunmOriginalTable || colunmOriginalTable == null) continue;
                isSameTable = false;
            }
            ++n2;
        }
        boolean bl = hasDBTableName = dataStruct.getRelationTableName() != null && dataStruct.getRelationTableName().length() > 0;
        if (isSameTable && hasDBTableName) {
            throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784" + dataStruct.getKey() + "\u4e0d\u5e94\u8be5\u5b9a\u4e49DBTableName\u3002"));
        }
        if (!isSameTable && !hasDBTableName) {
            throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784" + dataStruct.getKey() + "\u9700\u8981\u5b9a\u4e49DBTableName\u3002"));
        }
    }

    private static void checkOneDataOneSource(MetaDataStruct dataStruct, MetaDataStructSource[] dataStructSources) throws Throwable {
        int sourceSize = dataStructSources.length;
        DataStructSourceTableTree[] sourceTableTrees = new DataStructSourceTableTree[sourceSize];
        int i = 0;
        while (i < sourceSize) {
            sourceTableTrees[i] = new DataStructSourceTableTree(dataStruct, dataStructSources[i]);
            ++i;
        }
        ArrayList<MetaDataStructTable> needCheckTables = new ArrayList<MetaDataStructTable>();
        Object[] objectArray = sourceTableTrees;
        int n = sourceTableTrees.length;
        int n2 = 0;
        while (n2 < n) {
            DataStructSourceTableTree sourceTableTree = objectArray[n2];
            MetaDataStructCheck.addListNotRepeat(needCheckTables, sourceTableTree.root.table);
            MetaDataStructCheck.getNeedCheckTables(sourceTableTree.root, needCheckTables);
            ++n2;
        }
        for (MetaDataStructTable table : needCheckTables) {
            WhereExp[] whereExps = new WhereExp[sourceSize];
            int i2 = 0;
            while (i2 < sourceSize) {
                DataStructSourceTableNode sourceTableNode = sourceTableTrees[i2].getNode(table);
                if (sourceTableNode != null) {
                    whereExps[i2] = sourceTableNode.getWhereExp();
                }
                ++i2;
            }
            objectArray = WhereExpUtils.checkWhereIsolation(whereExps, table);
        }
    }

    private static <T> void addListNotRepeat(List<T> list, T t) {
        if (!list.contains(t)) {
            list.add(t);
        }
    }

    private static List<MetaDataStructTable> getNeedCheckTables(DataStructSourceTableNode sourceTableNode, List<MetaDataStructTable> result) {
        MetaDataStructSourceColumn sourceColumn = sourceTableNode.getSourceColumn();
        if (sourceColumn != null && sourceColumn.isOuterJoin()) {
            MetaDataStructCheck.addListNotRepeat(result, sourceTableNode.table);
        }
        if (sourceTableNode.children != null) {
            for (DataStructSourceTableNode child : sourceTableNode.children) {
                MetaDataStructCheck.getNeedCheckTables(child, result);
            }
        }
        return result;
    }

    private static void checkConstValueAndOriginalTable(MetaDataStructSource[] dataStructSources) {
        MetaDataStructSource[] metaDataStructSourceArray = dataStructSources;
        int n = dataStructSources.length;
        int n2 = 0;
        while (n2 < n) {
            MetaDataStructSource source = metaDataStructSourceArray[n2];
            Iterator iterator = source.getColumnCollection().iterator();
            while (iterator.hasNext()) {
                MetaDataStructSourceColumn sourceColumn = (MetaDataStructSourceColumn)iterator.next();
                String constValue = sourceColumn.getConstValue();
                String originalTable = sourceColumn.getOriginalTable();
                if (constValue != null && constValue.length() > 0 && originalTable != null && originalTable.length() > 0) {
                    throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784\u6e90" + source.getKey() + "\u4e2d\u5b57\u6bb5" + sourceColumn.getKey() + "\u540c\u65f6\u5b9a\u4e49\u7684\u5e38\u91cf\u548c\u6e90\u8868\uff0c\u9519\u8bef\u3002"));
                }
            }
            ++n2;
        }
    }

    private static void checkTableRefField(MetaDataStruct dataStruct, MetaDataStructSource[] dataStructSources) {
        MetaDataStructSource[] metaDataStructSourceArray = dataStructSources;
        int n = dataStructSources.length;
        int n2 = 0;
        while (n2 < n) {
            MetaDataStructSource source = metaDataStructSourceArray[n2];
            Iterator iterator = source.getColumnCollection().iterator();
            while (iterator.hasNext()) {
                MetaDataStructSourceColumn sourceColumn = (MetaDataStructSourceColumn)iterator.next();
                MetaDataStructColumn column = (MetaDataStructColumn)dataStruct.getColumnCollection().get(sourceColumn.getKey());
                if (column.isTableRefField()) {
                    throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784\u6e90" + source.getKey() + "\u4e2d\u5b57\u6bb5" + sourceColumn.getKey() + "\u662f\u8868\u5f15\u7528\u5b57\u6bb5\uff0c\u9519\u8bef\u3002"));
                }
            }
            ++n2;
        }
    }

    private static void checkNotExistMultiToMulti(MetaDataStruct dataStruct, MetaDataStructSource[] dataStructSources) throws Throwable {
        MetaDataStructSource[] metaDataStructSourceArray = dataStructSources;
        int n = dataStructSources.length;
        int n2 = 0;
        while (n2 < n) {
            MetaDataStructSource source = metaDataStructSourceArray[n2];
            new DataStructSourceTableTree(dataStruct, source);
            ++n2;
        }
    }
}

