/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.datastruct.metaload;

import com.bokesoft.yes.datastruct.meta.MetaDataStructSource;
import com.bokesoft.yes.datastruct.meta.MetaDataStructSourceColumn;
import com.bokesoft.yes.datastruct.meta.MetaDataStructTable;
import com.bokesoft.yes.datastruct.metaload.DataStructUtils;
import com.bokesoft.yes.datastruct.metaload.WhereExp;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DataStructSourceTableNode {
    public final MetaDataStructSource source;
    public final MetaDataStructTable table;
    private MetaDataStructSourceColumn sourceColumn;
    DataStructSourceTableNode parent;
    List<DataStructSourceTableNode> children;
    private WhereExp whereExp;

    DataStructSourceTableNode(MetaDataStructSource source, MetaDataStructTable table) {
        this.source = source;
        this.table = table;
    }

    public void addChild(DataStructSourceTableNode childNode) {
        if (childNode.parent != null) {
            if (childNode.parent == this) {
                return;
            }
            throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784\u8868" + childNode.table.getKey() + "\u5b58\u5728\u81f3\u5c11\u4e24\u4e2a\u7236\u8282\u70b9\uff0c\u9519\u8bef\u3002"));
        }
        childNode.parent = this;
        if (this.children == null) {
            this.children = new ArrayList<DataStructSourceTableNode>();
        }
        this.children.add(childNode);
    }

    public List<DataStructSourceTableNode> getChildren() {
        return this.children;
    }

    public void setSourceColumn(MetaDataStructSourceColumn sourceColumn) {
        this.sourceColumn = sourceColumn;
    }

    public MetaDataStructSourceColumn getSourceColumn() {
        return this.sourceColumn;
    }

    public MetaDataObject getDataObject() throws Throwable {
        return MetaFactory.getGlobalInstance().getDataObject(this.table.getRefDataObject());
    }

    public WhereExp getWhereExp() throws Throwable {
        if (this.whereExp == null) {
            Map<MetaDataStructTable, WhereExp> whereExps = DataStructUtils.getSourceWhereExpression(this.table.getDataStruct(), this.source);
            this.whereExp = whereExps.get(this.table);
        }
        return this.whereExp;
    }

    public String toString() {
        return String.valueOf(super.toString()) + "@" + this.table.getKey();
    }
}

