/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.sql.check;

import com.bokesoft.yes.mid.mysqls.execute.ExecuteUtil;
import com.bokesoft.yes.mid.mysqls.sql.SelectSqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfos;
import com.mysql.cj.jdbc.ClientPreparedStatement;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckSplitSql {
    private static boolean check = false;
    private static boolean checkLimitSql = false;
    private static boolean enableShardingWarn = false;
    private static HashSet<String> sqls = new HashSet();
    private static Logger logger = LoggerFactory.getLogger(CheckSplitSql.class);
    private static List<String> list = Arrays.asList("GeneralDBManager", "StatementWithLog", "PreparedStatementWithLog", "MultiDBPreparedStatement", "RichDocumentContext", "EntityContextAction", "EntityContext", "TableEntityManager", "NativeMethodAccessorImpl", "Thread", "CheckSplitSql", "DelegatingMethodAccessorImpl");

    public static void setCheck(boolean check) {
        CheckSplitSql.check = check;
    }

    public static void setNeedCheckLimit(boolean checkLimit) {
        checkLimitSql = checkLimit;
    }

    public static boolean isNeedCheckLimit() {
        return checkLimitSql;
    }

    public static void setShardingWarnEnable(boolean bEnable) {
        enableShardingWarn = bEnable;
    }

    public static boolean isShardingWarnEnable() {
        return enableShardingWarn;
    }

    public static void logActualSql(PreparedStatement statement, String sql) {
        if (!check) {
            return;
        }
        if (System.getenv().containsKey("MULTI_DB") && System.getenv().get("MULTI_DB").equalsIgnoreCase("true")) {
            return;
        }
        boolean isLoged = false;
        if (statement instanceof ClientPreparedStatement) {
            try {
                String actualSql = ((ClientPreparedStatement)statement).asSql();
                CheckSplitSql.logActualSql(actualSql, sql);
            }
            catch (Throwable actualSql) {}
        } else {
            Class<?> clz = statement.getClass();
            while (clz != Object.class) {
                try {
                    Field delegate = clz.getDeclaredField("delegate");
                    if (delegate != null) {
                        delegate.setAccessible(true);
                        Object object = delegate.get(statement);
                        if (object instanceof ClientPreparedStatement) {
                            String actualSql = ((ClientPreparedStatement)object).asSql();
                            CheckSplitSql.logActualSql(actualSql, sql);
                        }
                        isLoged = true;
                        break;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                clz = clz.getSuperclass();
            }
        }
        if (!isLoged) {
            logger.info(statement + "\u672a\u8bb0\u5f55\u8c03\u7528\u6808");
        }
    }

    public static void logActualSql(String actualSql, String sql) {
        if (!check) {
            return;
        }
        if (!sqls.contains(sql)) {
            StringBuilder logMsg = new StringBuilder();
            logMsg.append("\r\n").append("sql\u8bed\u53e5:").append("\r\n").append(actualSql).append("\r\n");
            logMsg.append("\u65b9\u6cd5\u8c03\u7528\u6808\u4e3a\uff1a").append("\r\n");
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            int i = 0;
            while (i < stackTrace.length && i < 15) {
                StackTraceElement stackTraceElement = stackTrace[i];
                if (CheckSplitSql.isNeedLog(stackTraceElement)) {
                    logMsg.append(stackTraceElement.toString()).append("\r\n");
                }
                ++i;
            }
            logger.info(logMsg.toString());
            sqls.add(sql);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void check(String sql) {
        if (!CheckSplitSql.check || ExecuteUtil.isDDL(sql)) {
            return;
        }
        sqlInfo = null;
        try {
            try {
                sqlInfo = SqlInfos.instance.getSqlInfo(sql);
                if (!(sqlInfo instanceof SelectSqlInfo)) return;
                ((SelectSqlInfo)sqlInfo).getComplexSQL();
                return;
            }
            catch (Throwable throwable) {
                if (CheckSplitSql.sqls.contains(sql)) return;
                errorMsg = "\u5206\u5e93sql\u89e3\u6790\u4e0d\u901a\u8fc7\uff1a" + throwable.getMessage() + "SQL\u8bed\u53e5\u4e3a\uff1a\r\n" + sql;
                CheckSplitSql.logger.error(errorMsg);
                CheckSplitSql.logger.error("\u65b9\u6cd5\u8c03\u7528\u6808\u4e3a\uff1a");
                stackTrace = Thread.currentThread().getStackTrace();
                i = 0;
                ** while (i < stackTrace.length && i < 15)
            }
lbl-1000:
            // 1 sources

            {
                stackTraceElement = stackTrace[i];
                if (CheckSplitSql.isNeedLog(stackTraceElement)) {
                    CheckSplitSql.logger.error(stackTraceElement.toString());
                }
                ++i;
                continue;
            }
lbl24:
            // 1 sources

            CheckSplitSql.sqls.add(sql);
            return;
        }
        finally {
            SqlInfos.instance.remove(sql);
        }
    }

    private static boolean isNeedLog(StackTraceElement stackTraceElement) {
        for (String string : list) {
            if (!stackTraceElement.toString().contains(string)) continue;
            return false;
        }
        return true;
    }
}

