/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.mid.schema;

import com.bokesoft.erp.index.ERPCreateIndex;
import com.bokesoft.erp.mid.schema.ERPSchemaProcess;
import com.bokesoft.erp.mid.schema.ERPSchemaViewDependSchemaTable;
import com.bokesoft.erp.mid.util.ProcessKeysMigrateDataObject;
import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.materializedquery.InitMaterializedQuery;
import com.bokesoft.yes.mid.materializedquery.MaterializedQueryStruct;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yes.mid.schema.ISchemaProvider;
import com.bokesoft.yes.mid.schemamgr.SchemaProProcess;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.schema.MetaIndex;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.connection.DataBaseInfo;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.schemamgr.ISchemaCreate;
import com.bokesoft.yigo.mid.schemamgr.SchemaCreateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ERPSchemaMaintance {
    private final String TABLE_SUFFIX = "_old";
    private static final String CONST_I = "I_";
    private static final String CONST_UNION = "_UNION";
    private static final String CONST_GroupAndPeriod = "_GP";
    private static final String CONST_HASHCODE = "_HASHCODE";
    private final String SQL_CONST_DROP_VIEW = "drop view ";
    private ISchemaProvider provider = null;
    public static ERPSchemaProcess schemaProcess = null;

    public static ERPSchemaProcess getSchemaProcess() {
        return schemaProcess;
    }

    public static void setSchemaProcess(ERPSchemaProcess schemaProcess) {
        ERPSchemaMaintance.schemaProcess = schemaProcess;
    }

    public ERPSchemaMaintance(ISchemaProvider provider) {
        this.provider = provider;
    }

    public void maintance(IDBManager dbManager) throws Throwable {
        List allKeysMigrationDataObjet;
        List allTable = this.provider.getAllTable();
        if (InitMaterializedQuery.mq != null) {
            allTable.add(MaterializedQueryStruct.getStruct(InitMaterializedQuery.mq).getSchemaTable());
        }
        if (allTable == null || allTable.size() == 0) {
            return;
        }
        ProcessKeysMigrateDataObject.getMDGroupColumnKeys(allTable, this.provider.getAllKeysMigrationDataObject());
        ArrayList<MetaSchemaTable> addFiledsList = new ArrayList<MetaSchemaTable>();
        List KeysMigrationMainTableNameList = this.provider.getKeysMigrationMainTableNameList();
        Iterator iterator = allTable.iterator();
        HashMap<String, MetaSchemaTable> map = new HashMap<String, MetaSchemaTable>();
        schemaProcess = new ERPSchemaProcess(dbManager);
        HashMapIgnoreCase changedMetaSchemaTables = new HashMapIgnoreCase();
        while (iterator.hasNext()) {
            boolean isKeysMigrationMainTable;
            MetaSchemaTable schemaTable = (MetaSchemaTable)iterator.next();
            SchemaProProcess.dataObjectProProcess((IDBManager)dbManager, (MetaSchemaTable)schemaTable);
            String schemaTableKey = schemaTable.getKey();
            boolean bl = isKeysMigrationMainTable = CollectionUtils.isNotEmpty((Collection)KeysMigrationMainTableNameList) && KeysMigrationMainTableNameList.contains(schemaTableKey);
            if (!isKeysMigrationMainTable) {
                Object partitionMethod;
                if (schemaProcess.tableRebuild(dbManager, schemaTable)) {
                    changedMetaSchemaTables.put(schemaTableKey, null);
                }
                if ((partitionMethod = schemaTable.getPartitionMethod()) == null || "".equals(partitionMethod)) continue;
                map.put(schemaTable.getKey(), schemaTable);
                continue;
            }
            addFiledsList.add(schemaTable);
        }
        for (MetaSchemaTable schemaTable : map.values()) {
            schemaProcess.tableRepartition(dbManager, schemaTable);
        }
        if (CollectionUtils.isNotEmpty(addFiledsList)) {
            for (MetaSchemaTable table : addFiledsList) {
                if (!schemaProcess.addColumnIntoKeysMigrationTable(dbManager, table)) continue;
                changedMetaSchemaTables.put(table.getKey(), null);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(allKeysMigrationDataObjet = this.provider.getAllKeysMigrationDataObject()))) {
            for (MetaDataObject dataObject : allKeysMigrationDataObjet) {
                if (StringUtils.isNotEmpty((CharSequence)dataObject.getExtend())) continue;
                MetaTable mainMetaTable = dataObject.getMainTable();
                ERPSchemaMaintance.generateUnionIndex(dbManager, dataObject, schemaProcess);
                ERPSchemaViewDependSchemaTable views = new ERPSchemaViewDependSchemaTable(dataObject);
                List<String> viewNames = views.getViewNames();
                DataBaseInfo info = schemaProcess.getInfo();
                if (views.isDepend((HashMapIgnoreCase<String>)changedMetaSchemaTables)) {
                    this.rebuildView(dbManager, mainMetaTable, views, viewNames, info);
                    continue;
                }
                if (StringUtils.isNotEmpty((CharSequence)dataObject.getMergeToSourceMapKey())) {
                    this.rebuildView(dbManager, mainMetaTable, views, viewNames, info);
                    continue;
                }
                boolean needGenView = false;
                for (String viewName : viewNames) {
                    if (info.checkViewExist(viewName)) continue;
                    needGenView = true;
                    break;
                }
                if (!needGenView) continue;
                this.rebuildView(dbManager, mainMetaTable, views, viewNames, info);
            }
        }
    }

    public static void generateUnionIndex(IDBManager dbManager, MetaDataObject dataObject, ERPSchemaProcess schemaProcess) throws Throwable {
        MetaTable mainMetaTable = dataObject.getMainTable();
        MetaTable keysMetaTable = dataObject.getErpMigrationKeysTable();
        MetaTable incrMetaTable = dataObject.getErpMigrationIncrTable();
        MetaTable newMetaTable = dataObject.getErpMigrationNewTable();
        MetaTable lpMetaTable = dataObject.getMigrationLastPointTable();
        StringBuilder indexColumns = new StringBuilder();
        indexColumns.append("GroupId");
        String periodFieldName = "";
        for (MetaColumn metaColumn : mainMetaTable) {
            if (metaColumn.getGroupType() != 1) continue;
            indexColumns.append(",").append(metaColumn.getBindingDBColumnName());
            periodFieldName = metaColumn.getBindingDBColumnName();
            break;
        }
        String incrTableName = incrMetaTable.getBindingDBTableName();
        String indexName = StringUtil.strcat((Object[])new Object[]{CONST_I, incrTableName, CONST_UNION});
        if (!ERPCreateIndex.checkIndexExist(schemaProcess, incrTableName, indexName)) {
            MetaIndex index = new MetaIndex();
            index.setKey(indexName);
            index.setUnique(Boolean.valueOf(false));
            index.setColumns(indexColumns.toString());
            MetaSchemaTable table = new MetaSchemaTable();
            table.setKey(incrTableName);
            ISchemaCreate schemaCreate = SchemaCreateFactory.getInstance().create();
            schemaCreate.createIndex(dbManager, table, index);
            if (dbManager.getDBType() == 14) {
                dbManager.commit();
            }
        }
        String newTableName = newMetaTable.getBindingDBTableName();
        indexName = StringUtil.strcat((Object[])new Object[]{CONST_I, newTableName, CONST_GroupAndPeriod});
        if (!ERPCreateIndex.checkIndexExist(schemaProcess, newTableName, indexName)) {
            MetaIndex index = new MetaIndex();
            index.setKey(indexName);
            index.setUnique(Boolean.valueOf(true));
            index.setColumns(indexColumns.toString());
            MetaSchemaTable table = new MetaSchemaTable();
            table.setKey(newTableName);
            ISchemaCreate schemaCreate = SchemaCreateFactory.getInstance().create();
            schemaCreate.createIndex(dbManager, table, index);
            if (dbManager.getDBType() == 14) {
                dbManager.commit();
            }
        }
        String hashcodeIndexName = StringUtil.strcat((Object[])new Object[]{keysMetaTable.getIndexPrefix4Create(), CONST_HASHCODE});
        String hashCodeTableName = keysMetaTable.getBindingDBTableName();
        boolean containIndex = ERPCreateIndex.checkIndexExist(schemaProcess, hashCodeTableName, hashcodeIndexName);
        if (!containIndex) {
            MetaIndex index = new MetaIndex();
            index.setKey(hashcodeIndexName);
            index.setColumns("HashCode");
            Iterator table = new MetaSchemaTable();
            table.setKey(hashCodeTableName);
            ISchemaCreate schemaCreate = SchemaCreateFactory.getInstance().create();
            schemaCreate.createIndex(dbManager, (MetaSchemaTable)table, index);
            if (dbManager.getDBType() == 14) {
                dbManager.commit();
            }
        }
        if (lpMetaTable != null) {
            indexColumns = new StringBuilder();
            for (MetaColumn metaColumn : lpMetaTable) {
                if (metaColumn.getGroupType() != 2) continue;
                indexColumns.append(metaColumn.getBindingDBColumnName()).append(",");
            }
            if (indexColumns.length() > 0) {
                String lpTableName = lpMetaTable.getBindingDBTableName();
                indexName = StringUtil.strcat((Object[])new Object[]{CONST_I, lpTableName, CONST_GroupAndPeriod});
                containIndex = ERPCreateIndex.checkIndexExist(schemaProcess, lpTableName, indexName);
                if (!containIndex) {
                    indexColumns.append(periodFieldName);
                    MetaIndex index = new MetaIndex();
                    index.setUnique(Boolean.valueOf(true));
                    index.setKey(indexName);
                    index.setColumns(indexColumns.toString());
                    MetaSchemaTable table = new MetaSchemaTable();
                    table.setKey(lpTableName);
                    ISchemaCreate schemaCreate = SchemaCreateFactory.getInstance().create();
                    schemaCreate.createIndex(dbManager, table, index);
                    if (dbManager.getDBType() == 14) {
                        dbManager.commit();
                    }
                }
            }
        }
    }

    private void rebuildView(IDBManager dbManager, MetaTable mainMetaTable, ERPSchemaViewDependSchemaTable views, List<String> viewNames, DataBaseInfo info) throws Throwable {
        for (String viewName : viewNames) {
            if (!info.checkViewExist(viewName)) continue;
            String sql = new SqlString().append("drop view ").append(viewName).getSql();
            if (dbManager.getDBType() == 14) {
                sql = new SqlString().append("drop view ").append(viewName).append(" CASCADE").getSql();
            }
            dbManager.execPrepareUpdate(sql, new Object[0]);
            if (dbManager.getDBType() != 14) continue;
            dbManager.commit();
        }
        this.changeTableName(dbManager, mainMetaTable.getBindingDBTableName());
        Map<String, String> createViewSqls = views.generateViewSqls(dbManager);
        if (!createViewSqls.isEmpty()) {
            for (Map.Entry<String, String> entry : createViewSqls.entrySet()) {
                String viewSql = entry.getValue();
                dbManager.execPrepareUpdate(viewSql, new Object[0]);
                if (dbManager.getDBType() != 14) continue;
                dbManager.commit();
            }
        }
    }

    private void changeTableName(IDBManager dbManager, String tableName) throws Throwable {
        if (dbManager.checkTableExist(tableName)) {
            String oldTableName = String.valueOf(tableName) + "_old";
            if (dbManager.checkTableExist(oldTableName)) {
                this.renameTable(dbManager, oldTableName, String.valueOf(oldTableName) + System.currentTimeMillis());
            }
            this.renameTable(dbManager, tableName, oldTableName);
        }
    }

    private void renameTable(IDBManager dbManager, String sourceTable, String targetTable) throws Throwable {
        SqlString sql = new SqlString();
        switch (dbManager.getDBType()) {
            case 4: {
                sql.append("rename table ", sourceTable, " to ", targetTable);
                break;
            }
            case 2: 
            case 8: 
            case 14: {
                sql.append("alter table ", sourceTable, " rename to ", targetTable);
                break;
            }
            case 1: {
                sql.append("exec sp_rename ", sourceTable, ",", targetTable);
                break;
            }
        }
        dbManager.execPrepareUpdate(sql.getSql(), new Object[0]);
        if (dbManager.getDBType() == 14) {
            dbManager.commit();
        }
    }
}

