// smart.tree需优先于smart-tree-ext、yigo-favorite-tree加载
import "../../lib/smart-webcomponents/smart.tree.js";
import "./smart-tree-ext.js";
import "../../widgets/yigo-favorite-tree/yigo-favorite-tree.js";
// 引入util
import { loadcss } from "../../../ux/util/util.js";
//引入 favorite 需要的 CSS
loadcss(window.Yes_ENV_WebRoot + "home/lib/smart-webcomponents/smart.default.css");
loadcss(window.Yes_ENV_WebRoot + "home/js/favorite/favorite.css");

let _rootEntry;

const newFolderName = "新建文件夹";

// 获取 字符中 指定 前缀 后面的 数字
const _getEndNumFromStr = (str, prefix) => {
    const regex = new RegExp(`^${prefix}(\\d+)`);
    const match = str.match(regex);
    return match ? parseInt(match[1], 10) : null;
}

// 获取 新建文件夹 的序号
const _getNewFolderIndex = (treeData) => {
    let curIndex = 0;
    const recursion = (treeData) => {
        treeData.forEach((node) => {
            if (node.items) {
                const orderNum = _getEndNumFromStr(node.label, newFolderName);
                if (orderNum && orderNum > curIndex) {
                    curIndex = orderNum;
                }
                recursion(node.items, curIndex);
            }
        });
        return curIndex;
    };
    return recursion(treeData);
}

// 获取菜单中的收藏夹数据
const _getFavoritesFromMenu = () => {
    var favorites = null;
    if (_rootEntry && _rootEntry.children) {
        var children = _rootEntry.children;
        children.forEach(function (item, index) {
            if (item && item.key && item.key == "PFC1") {
                favorites = item;
            }
        });
    }
    return favorites;
}
// 判断表单是否被收藏
const _isFormCollected = (formEntry, _favorites) => {
    if (!_favorites) {
        return false;
    }
    function isInTree(_entry, _tree) {
        if (_entry && _tree) {
            if (_tree.children && _tree.children.length > 0) {
                //树含多个节点。
                for (var i = 0, _len = _tree.children.length; i < _len; i++) {
                    var node = _tree.children[i];
                    if (isInTree(_entry, node)) {
                        return true;
                    } else {
                        if (i == _len - 1) {
                            //最后一个节点
                            return false;
                        } else {
                            //继续循环查看下一个节点
                        }
                    }
                }
            } else {
                if (_tree.path && _tree.path === _entry) {
                    //树是单节点
                    return true;
                } else {
                    return false;
                }
            }
        } else {
            return false;
        }
    }
    if (!formEntry) {
        return false;
    } else {
        if (formEntry && _favorites && _favorites.children.length > 0) {
            return isInTree(formEntry, _favorites);
        } else {
            return false;
        }
    }
}

// 保存后刷新菜单收藏夹数据
const _refreshFavorites = async () => {
    var rootEntryCopy = _rootEntry;
    const mainTree = YIUI.MainTree.mainTree;
    var result = await Favorite.addFavorites2MenuData({
        children: [],
    });
    if (result.children && result.children.length) {
        var _favorites = result.children[0];
        mainTree.initDataSource(_favorites);
        mainTree.dataSourceCopy(result.children);
        rootEntryCopy.children.shift();
        rootEntryCopy.children.unshift(_favorites);
        _rootEntry = rootEntryCopy;
        mainTree.reload(rootEntryCopy);
    }
}

// 清理 递归数据，如果 children 数组中的某个项是 null 或 undefined，将其过滤掉.
const _cleanTree = node => {
    if (node && !node.children) {
        return node;
    }

    // 过滤掉 children 数组中的 null 和 undefined 项
    node.children = node.children.filter(child => child);

    // 递归清理每个子节点的 children
    node.children = node.children.map(_cleanTree);

    return node;
}

export default class Favorite {
    // 初始化
    static init(node, rootEntry) {
        _rootEntry = rootEntry;
        const fav_icon = document.createElement("span");
        fav_icon.setAttribute("id", node.id + "_favicon");
        fav_icon.classList.add("fav-menu");
        fav_icon.setAttribute("entry-key", node.key);
        fav_icon.setAttribute("title", "收藏");

        const mainTree = YIUI.MainTree.mainTree;

        var _favoriteItem = _getFavoritesFromMenu();
        var isFormCollected = _isFormCollected(node.path, _favoriteItem);
        var isFavorite = node.id.endsWith("_fav");
        fav_icon.classList.remove("menu-collected", "menu-notcollected");
        fav_icon.classList.add(
            isFavorite
                ? "menu-modify"
                : isFormCollected
                    ? "menu-collected"
                    : "menu-notcollected"
        );
        // 管理收藏夹
        fav_icon.addEventListener("click", async function (event) {
            event.stopPropagation(); // 防止冒泡 点击收藏夹不打开菜单
            var userID = YIUI.SessionInfo.getUserID() || -1;
            try {
                const data = (await YIUI.MenuFavoriteService.loadMenuFavorites(
                    userID
                )) || { name: "我的收藏夹", children: [] };
                const node = event.target.closest("li.tm-node");
                const path = node.getAttribute("path");
                const favorite_tree_html = `<div class="favorite-tree-plugin">
                        <yigo-favorite-tree
                            class="animation smart-element smart-tree"
                            scroll-mode="scrollbar"
                            show-lines
                            allow-drag
                            allow-drop
                        >
                        </yigo-favorite-tree>
                        <div class="favorite-tree-footer">
                            <button class="cancel">
                                ${YIUI.I18N.getString("DIALOG_CLOSE", "取消")}
                            </button>
                            <button class="confirm">
                              ${YIUI.I18N.getString("CURRENCY_OK", "确定")}
                            </button>
                        </div>
                    </div>`;
                const dialog = new YIUI.BaseDialog({
                    headerTitle: `管理收藏夹`,
                    content: favorite_tree_html,
                    panelSize: "40% 50%",
                });

                dialog.addClassName("panel", "modal");
                dialog.show();

                const treeInstance = document.querySelector("yigo-favorite-tree");
                // 收藏夹数据预处理
                let dataSource = [];
                const curNode = mainTree.getLeafFormNode(path, rootEntry);
                let curNodeExit = false; // 当前节点是否已存在于收藏夹
                const load_construct = (treeData, dataSource) => {
                    treeData.forEach((node, index) => {
                        if (!node) return;
                        if (node.children) {
                            dataSource[index] = {};
                            dataSource[index].disabled = node.enable;
                            dataSource[index].expanded = node.open;
                            dataSource[index].label = node.name;
                            dataSource[index].value = node.path;
                            dataSource[index].zTreeId = node.zTreeId;
                            dataSource[index].items = [];
                            load_construct(node.children, dataSource[index].items);
                        } else {
                            let _obj = {
                                label: node.name,
                                value: node.path,
                                zTreeId: node.zTreeId
                            };
                            if (curNode && (node.path === curNode.path)) {
                                _obj.selected = true;
                                curNodeExit = true
                            } else {
                                _obj.selected = false;
                            }
                            dataSource.push(_obj);
                        }
                    });
                    return dataSource;
                };
                dataSource = load_construct([data], dataSource);
                !curNodeExit && curNode &&
                    dataSource[0].items.push({
                        label: curNode.MenuNamePath.slice(0, 2).reverse().join("-"),
                        value: curNode.path,
                        selected: true,
                    });
                dataSource[0].expanded = true; // 收藏夹第一层默认展开
                treeInstance.dataSource = dataSource;
                treeInstance.addEventListener("expand", function (event) {
                    const labelSpan = event.detail.item.querySelector(
                        ".smart-tree-item-label-element>span"
                    );
                    labelSpan && labelSpan.classList.remove("icon-collapse");
                    labelSpan && labelSpan.classList.add("icon-expanded");
                });
                treeInstance.addEventListener("collapse", function (event) {
                    const labelSpan = event.detail.item.querySelector(
                        ".smart-tree-item-label-element>span"
                    );
                    labelSpan && labelSpan.classList.remove("icon-expanded");
                    labelSpan && labelSpan.classList.add("icon-collapse");
                });
                treeInstance.addEventListener("click", (event) => {
                    const clickedElement = event.target;
                    if (clickedElement.tagName === "I") {
                        if (clickedElement.classList.contains("icon-plus")) {
                            const newItem = document.createElement("smart-tree-items-group");
                            let count = _getNewFolderIndex(
                                treeInstance.dataSource
                            );
                            count++;
                            newItem.label = `${newFolderName}${count}`;
                            newItem.expanded = false;
                            newItem.value = count;
                            newItem.disabled = false;
                            const itemGroup = clickedElement.closest(
                                "smart-tree-items-group"
                            );
                            itemGroup.expanded = true;
                            treeInstance.addTo(newItem, itemGroup);
                        } else if (clickedElement.classList.contains("icon-del")) {
                            const curNode =
                                clickedElement.closest("smart-tree-item") ||
                                clickedElement.closest("smart-tree-items-group");
                            let options = {
                                headerTitle: YIUI.I18N.getString("GRID_PROMPT", "提示"),
                                msgType: 1,
                                msg: `确认删除"节点--${curNode.label}"并在最终确认后保存到菜单收藏夹吗？`,
                                events: {
                                    YES: () => {
                                        treeInstance.removeItem(curNode);
                                    },
                                    NO: () => {
                                        dialog.close();
                                    },
                                },
                            };
                            const dialog = new YIUI.Dialog(options);
                            dialog.show();
                        }
                    }
                });

                var confirm_btn = document.querySelector(
                    ".favorite-tree-footer .confirm"
                );
                confirm_btn.addEventListener("click", async () => {
                    var userID = YIUI.SessionInfo.getUserID() || -1;
                    const menuData = {
                        icon: "",
                        key: "PFC1",
                        zTreeId: 1,
                        pathKey: "PFC1",
                        visible: "",
                        name: treeInstance.dataSource[0].label,
                        open: treeInstance.dataSource[0].expanded,
                        path: treeInstance.dataSource[0].value,
                        enable: treeInstance.dataSource[0].disabled,
                        children: [],
                    };
                    const save_construct = (treeData, menuData, folderPath) => {
                        treeData.forEach((node, index) => {
                            const curNode = mainTree.getLeafFormNode(node.value, rootEntry);
                            var nameValue = curNode ? curNode.MenuNamePath.slice(0, 2).reverse().join("-") : "";
                            nameValue = nameValue == node.label ? "" : node.label;
                            // curNode为空即新建文件夹
                            if (node.items) {
                                if (curNode) {
                                    menuData[index] = {
                                        zTreeId: curNode.zTreeId || index + 1,
                                        key: curNode.key,
                                        pathKey: curNode.pathKey,
                                        visible: curNode.visible,
                                        name: nameValue,
                                        open: node.expanded,
                                        path: node.value,
                                        enable: node.disabled,
                                        children: [],
                                    };
                                } else {
                                    folderPath =
                                        typeof node.value === "number"
                                            ? folderPath + "/" + "PFC" + node.value
                                            : node.value;
                                    menuData[index] = {
                                        icon: "",
                                        zTreeId: index + 1,
                                        key: "PFC" + node.value,
                                        pathKey: folderPath.slice(folderPath.indexOf("/") + 1),
                                        visible: "",
                                        name: nameValue,
                                        open: node.expanded || false,
                                        path: folderPath,
                                        enable: node.disabled,
                                        children: [],
                                    };
                                }
                                save_construct(
                                    node.items,
                                    menuData[index].children,
                                    folderPath
                                );
                            } else {
                                if (curNode) {
                                    menuData[index] = {
                                        name: nameValue,
                                        path: node.value,
                                        icon: curNode.icon,
                                        key: curNode.key,
                                        formKey: curNode.formKey,
                                        appKey: curNode.appKey,
                                        parameters: curNode.parameters,
                                        shortKeys: curNode.shortKeys,
                                        single: curNode.single,
                                        target: curNode.target,
                                        type: curNode.type,
                                        enable: curNode.enable,
                                        visible: curNode.visible,
                                        zTreeId: index + 1,
                                    };
                                }
                            }
                        });
                        return menuData;
                    };
                    save_construct(
                        treeInstance.dataSource[0].items,
                        menuData.children,
                        treeInstance.dataSource[0].value
                    );
                    try {
                        await YIUI.MenuFavoriteService.saveMenuFavorites(userID, _cleanTree(menuData));
                        await _refreshFavorites();
                        dialog.close();
                        confirm_btn = null;
                    } catch (error) {
                        console.error(error);
                    }
                });

                var cancel_btn = document.querySelector(
                    ".favorite-tree-footer .cancel"
                );
                cancel_btn.addEventListener("click", () => {
                    dialog.close();
                    confirm_btn = null;
                });
            } catch (error) {
                console.error(error);
            }
        });

        return fav_icon;
    }
    // 从后台获取并添加菜单收藏夹数据到菜单数据中
    static async addFavorites2MenuData(result) {
        if (result && result.children && Array.isArray(result.children)) {
            try {
                const userID = YIUI.SessionInfo.getUserID() || -1;
                const data = await YIUI.MenuFavoriteService.loadMenuFavorites(userID);
                if (data) {
                    result.children.unshift(data);
                }
            } catch (error) {
                console.error(error);
            }
        }
        return result;
    }
}
