import "./modulepreload-polyfill-7faf532e.js";
import { W as YesUI } from "./yes-ui-29852ed4.js";
import { af as ExceptionStack, cS as YesCore, l as Utils, d1 as afterYIUILoad, aD as AppSetting } from "./yes-core-73b995f9.js";
import { M as MainFrame } from "./index-95bcd4da.js";
import "./erp-yes-core-25f33c37.js";
import "./erp-yes-ui-4313cb43.js";
import "./vendor-dcacb77b.js";
class webFormRender extends HTMLElement {
  constructor() {
    super();
  }
  // static count = 0;
  static get observedAttributes() {
    return ["data-oid", "data-formkey"];
  }
  async connectedCallback() {
  }
  async attributeChangedCallback(name, oldValue, newValue) {
    if (!newValue || newValue === oldValue)
      return;
    await this.render();
  }
  set parameters(val) {
    this._parameters = val;
    this.render();
  }
  get parameters() {
    return this._parameters;
  }
  async render() {
    if (this._form) {
      this._form.close();
    }
    let ct = this.children[0];
    const OID = Number(this.getAttribute("data-oid"));
    const formKey2 = this.getAttribute("data-formkey");
    if (!formKey2) {
      return;
    }
    if (!ct) {
      ct = document.createElement("div");
      ct.id = "formContainer";
      ct.style.height = "100%";
      this.appendChild(ct);
    } else {
      while (ct.firstChild) {
        ct.removeChild(ct.firstChild);
      }
    }
    try {
      let options = { OID, formKey: formKey2 };
      if (this.parameters) {
        options = Object.assign(options, { parameters: this.parameters });
      }
      if (options.formKey === "DictEdit" && !this.parameters) {
        return;
      }
      this._form = await YesUI.Forms.buildForm(options, ct);
    } catch (e) {
      throw new Error(`${formKey2}表单嵌入失败: ${e}`);
    }
  }
}
const form_render = "";
customElements.define("form-render", webFormRender);
window.addEventListener("error", function(e) {
  console.error(e);
  ExceptionStack.push(e.error);
});
window.addEventListener("unhandledrejection", function(e) {
  console.error(e);
  ExceptionStack.push(e.reason);
});
window.YIUI = {
  ...window.YIUI || {},
  YesCore,
  APP: {
    MainFrame
  },
  Utils
};
afterYIUILoad();
AppSetting.updateClientSetting("yescore.component.grid.defaultCustom", false);
AppSetting.updateClientSetting("yescore.component.grid.defaultZoom", true);
AppSetting.updateClientSetting("yescore.component.dict.EditType", 0);
AppSetting.updateClientSetting("yescore.dialog.Placement", "right");
AppSetting.updateClientSetting("yescore.component.base.CompStyle", "innerLabel");
AppSetting.updateClientSetting("yescore.component.grid.restoreInitStatus", true);
const formRenderElm = document.createElement("form-render");
const embedByEntryKey = async (entryKey2) => {
  if (!entryKey2)
    return;
  const entryData = await MainFrame.getEntryData();
  const entryItem = Utils.findMatchingNodes(entryData.entry, (item) => item.key === entryKey2)[0];
  if (entryItem) {
    const _formKey = entryItem.formKey;
    formRenderElm.dataset.formkey = _formKey;
    const parameters = entryItem.parameters;
    if (parameters && typeof parameters === "string" && parameters.includes("=")) {
      const _parameters = {};
      parameters.split(";").forEach((item) => {
        let attr = item.split("=");
        _parameters[attr[0]] = attr[1];
      });
      formRenderElm.parameters = _parameters;
    }
  }
};
const embedByFormKey = (formKey2) => {
  if (!formKey2)
    return;
  formRenderElm.dataset.formkey = formKey2;
  urlSearchParams.oid && (formRenderElm.dataset.oid = urlSearchParams.oid + "");
};
const getUrlSearchParams = () => {
  const urlSearch = new URLSearchParams(window.location.search);
  let result = {};
  for (let key of urlSearch.keys()) {
    result[key] = urlSearch.get(key);
  }
  return result;
};
const urlSearchParams = getUrlSearchParams();
const { formKey, entryKey } = urlSearchParams;
formRenderElm.parameters = Object.assign(formRenderElm.parameters || {}, urlSearchParams, { customOnLoad: true });
if (entryKey) {
  (async () => {
    await embedByEntryKey(entryKey);
  })();
} else if (formKey) {
  embedByFormKey(formKey);
}
document.body.appendChild(formRenderElm);
//# sourceMappingURL=form_render-c6f62986.js.map
