// 从其他报表复制来的取URL参数函数
var getRequestParameters = function(){
  //返回当前 URL 的查询部分（问号 ? 之后的部分）。
  var urlParameters = location.search;
  //声明并初始化接收请求参数的对象
  var requestParameters = new Object();
  //如果该求青中有请求的参数，则获取请求的参数，否则打印提示此请求没有请求的参数
  if (urlParameters.indexOf('?') != -1){
      //获取请求参数的字符串
      var parameters = decodeURI(urlParameters.substr(1));
      //将请求的参数以&分割中字符串数组
      parameterArray = parameters.split('&');
      //循环遍历，将请求的参数封装到请求参数的对象之中
      for (var i = 0; i < parameterArray.length; i++) {
          requestParameters[parameterArray[i].split('=')[0]] = (parameterArray[i].split('=')[1]);
      }
  }
  return requestParameters;
};

//获取供应商数组
function vendorNameArr(vendorData){
  var rst = new Array();
  for (var i = 0 ; i < vendorData.length; i++) {
    rst[i] = vendorData[i].VendorName;
  }
  return rst;
}

//获取时间数组
function dateArr(fromDate, toDate){
  var rst = new Array();
  if (fromDate == 0 || toDate == 0) {
    return rst;
  }
  //Date月份0-11
  var startDate=new Date();
  startDate.setFullYear(fromDate/10000,Math.floor((fromDate%10000)/100)-1,fromDate%100);

  var endDate=new Date();
  endDate.setFullYear(toDate/10000,Math.floor((toDate%10000)/100)-1,toDate%100);
  var i = 0;
  while (startDate <= endDate) {
    rst[i++] = startDate.getFullYear() + "/" + (startDate.getMonth()+1).toString().padStart(2,'0') + "/" + startDate.getDate().toString().padStart(2,'0');
    startDate.setDate(startDate.getDate()+1);
  }
  return rst;
};

//获取时间数组(Long)
function dateLongArr(fromDate, toDate){
  var rst = new Array();
  if (fromDate == 0 || toDate == 0) {
    return rst;
  }
  
  var startDate=new Date();
  startDate.setFullYear(fromDate/10000,Math.floor((fromDate%10000)/100)-1,fromDate%100);

  var endDate=new Date();
  endDate.setFullYear(toDate/10000,Math.floor((toDate%10000)/100)-1,toDate%100);
  var i = 0;
  while (startDate <= endDate) {
    rst[i++] = startDate.getFullYear() + (startDate.getMonth()+1).toString().padStart(2,'0') + startDate.getDate().toString().padStart(2,'0');
    startDate.setDate(startDate.getDate()+1);
  }
  return rst;
};

//折线图
function detePriceArr(vendorData, fromDate, toDate){
  var rst = new Array();
  var dateLongArray = dateLongArr(fromDate,toDate);
  for (var i = 0 ; i < vendorData.length; i++) {
    var seriesJson = {};
    var vendorName = vendorData[i].VendorName;
    seriesJson.name = vendorName;
    seriesJson.type = "line";
    seriesJson.step = "end";
    seriesJson.data = new Array();

    var vendorItem = vendorData[i].VendorItem;
    var vendorItemIndex = 0;
    for (var dateLongArrIndex = 0 ; dateLongArrIndex < dateLongArray.length; dateLongArrIndex++) {
      var curDateLong = dateLongArray[dateLongArrIndex];
      if (vendorItemIndex < vendorItem.length) {
        var itemDateLong = vendorItem[vendorItemIndex].DateLong;
        if (curDateLong == itemDateLong) {
          seriesJson.data[dateLongArrIndex] = vendorItem[vendorItemIndex].Price;
          vendorItemIndex++;
        } else {
          seriesJson.data[dateLongArrIndex] = null;
        }
      } else {
        seriesJson.data[dateLongArrIndex] = null;
      }
    }

    rst[i] = seriesJson;
  }
  return rst;
}

// 取参数 转换
var paras = getRequestParameters();
// 当前Form
var form = parent.YIUI.FormStack.getForm(paras.formID);
var parasData = [];

parasData.push({ 'value': paras.RFQBillID, 'dataType': 2 });
parasData.push({ 'value': paras.MaterialID, 'dataType': 2 });
parasData.push({ 'value': paras.FromDate, 'dataType': 2 });
parasData.push({ 'value': paras.ToDate, 'dataType': 2 });
parasData.push({ 'value': paras.formID, 'dataType': 2 });

// 编辑调用服务参数
var params = {
    service: "InvokeService",
    extSvrName: "LineChartService",
    paras: JSON.stringify(parasData)
};
// 启动调用服务
var url = parent.Svr.SvrMgr.ServletURL;
// 返回值
var retData;
new parent.Svr.Request(form).getSyncData(url, params, function(data){
    if (typeof data == 'undefined') {
      console.info(data);
    }
    // 回调设置返回数据
    retData = data;
});

//获取retData
//时间
var fromDate = retData.FromDate;
var toDate = retData.ToDate;
//供应商数据
var vendorData = retData.VendorData;

//echarts
var chartDom = document.getElementById('container');
var myChart = echarts.init(chartDom);
var option;
option = {
  //标题
  title: {
    text: '历史价格趋势图'
  },
  //指示框
  tooltip: {
    trigger: 'axis'
  },
  //图例组件
  legend: {
    data: vendorNameArr(vendorData)
  },
  //x轴分类
  xAxis: {
    type: 'category',
    boundaryGap: false,
    data: dateArr(fromDate, toDate)
  },
  //y轴分类
  yAxis: {
    type: 'value'
  },
  //折线
  series: detePriceArr(vendorData, fromDate, toDate)
};

option && myChart.setOption(option);
