/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.entity.util;

import com.bokesoft.erp.entity.util.AbstractBillEntity;
import com.bokesoft.erp.entity.util.AbstractTableEntity;
import com.bokesoft.erp.entity.util.EntityContextAction;
import com.bokesoft.erp.entity.util.EntityHelper;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocument;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.util.ERPStringUtil;
import com.bokesoft.yes.util.VarUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.function.FailableConsumer;

public class EntityUtil {
    private static final ArrayList<String> systemFields = new ArrayList<String>(Arrays.asList("OID", "SOID", "POID", "VERID", "DVERID", "Status", "InstanceID", "ClusterID", "BillDate", "CreateTime", "ModifyTime", "TransactTime", "Creator", "Modifier", "Checker", "CheckerTime", "NO", "MapKey", "MapCount", "Layer", "Hidden", "Slock", "ParentID", "TLeft", "TRight", "Enable", "NodeType", "HVER", "HVERM", "SVERID", "Submitter", "Name", "UploadOperator", "Path", "UploadTime"));

    public static <T extends AbstractTableEntity> List<T> filter(List<T> entities, Map<String, Object> filterFieldValues) throws Throwable {
        int entitySize = entities.size();
        if (entitySize == 0) {
            return new ArrayList(0);
        }
        DataTable dataTable = ((AbstractTableEntity)entities.get(0)).getDataTable();
        if (entitySize == dataTable.size()) {
            Set<Map.Entry<String, Object>> entrySet = filterFieldValues.entrySet();
            int fieldCount = entrySet.size();
            String[] filterKeys = new String[fieldCount];
            Object[] filterValues = new Object[fieldCount];
            int i = 0;
            for (Map.Entry<String, Object> entry : filterFieldValues.entrySet()) {
                filterKeys[i] = entry.getKey();
                filterValues[i] = entry.getValue();
                ++i;
            }
            int[] rowIndexes = dataTable.fastFilter(filterKeys, filterValues);
            ArrayList<AbstractTableEntity> result = new ArrayList<AbstractTableEntity>(rowIndexes.length);
            boolean canFastFilter = true;
            int[] nArray = rowIndexes;
            int n = rowIndexes.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractTableEntity tmp;
                int rowIndex = nArray[n2];
                if (rowIndex < entitySize) {
                    tmp = (AbstractTableEntity)entities.get(rowIndex);
                    if (dataTable != tmp.getDataTable() || dataTable.getBookmark(rowIndex) != tmp.getBookMark()) {
                        canFastFilter = false;
                        break;
                    }
                } else {
                    canFastFilter = false;
                    break;
                }
                result.add(tmp);
                ++n2;
            }
            if (canFastFilter) {
                return result;
            }
        }
        Boolean match = false;
        ArrayList<AbstractTableEntity> result = new ArrayList<AbstractTableEntity>(entities.size());
        for (AbstractTableEntity entity : entities) {
            match = true;
            for (Map.Entry<String, Object> entry : filterFieldValues.entrySet()) {
                Object curValue;
                String column = entry.getKey();
                Object value = entry.getValue();
                if (EntityUtil.isEquals(value, curValue = entity.valueByColumnName(column))) continue;
                match = false;
            }
            if (!match.booleanValue()) continue;
            result.add(entity);
        }
        return result;
    }

    public static <T extends AbstractTableEntity> T filterOne(List<T> entities, Map<String, Object> filterFieldValues) throws Throwable {
        List<T> list = EntityUtil.filter(entities, filterFieldValues);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        if (list.size() > 1) {
            throw new Exception("\u627e\u5230\u4e86\u4e00\u4e2a\u4ee5\u4e0a\u7684\u5b9e\u4f53,\u9519\u8bef.");
        }
        return (T)((AbstractTableEntity)list.get(0));
    }

    public static boolean isEquals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o1 instanceof Long) {
            return o1.equals(TypeConvertor.toLong((Object)o2));
        }
        if (o1 instanceof Integer) {
            return o1.equals(TypeConvertor.toInteger((Object)o2));
        }
        if (o1 instanceof String) {
            return o1.equals(TypeConvertor.toString((Object)o2));
        }
        if (o1 instanceof Double) {
            return ((Double)o1).compareTo(TypeConvertor.toDouble((Object)o2)) == 0;
        }
        if (o1 instanceof Date) {
            return o1.equals(TypeConvertor.toDate((Object)o2));
        }
        if (o1 instanceof BigDecimal) {
            return TypeConvertor.toBigDecimal((Object)o1).compareTo(TypeConvertor.toBigDecimal((Object)o2)) == 0;
        }
        throw new RuntimeException("");
    }

    public static <T extends AbstractTableEntity> List<T> filter(List<T> entities, String columnName, Object value) throws Throwable {
        return EntityUtil.filter(entities, EntityUtil.toMap(columnName, value));
    }

    public static <T extends AbstractBillEntity> List<T> filterBill(List<T> entities, Map<String, Object> filterFieldValues) throws Throwable {
        Boolean match = false;
        ArrayList<AbstractBillEntity> result = new ArrayList<AbstractBillEntity>(entities.size());
        for (AbstractBillEntity entity : entities) {
            match = true;
            for (Map.Entry<String, Object> entry : filterFieldValues.entrySet()) {
                Object curValue;
                String fieldKey = entry.getKey();
                Object value = entry.getValue();
                if (EntityUtil.isEquals(value, curValue = entity.getValue(fieldKey))) continue;
                match = false;
            }
            if (!match.booleanValue()) continue;
            result.add(entity);
        }
        return result;
    }

    public static <T extends AbstractBillEntity> List<T> filterBill(List<T> entities, String fieldKey, Object value) throws Throwable {
        return EntityUtil.filterBill(entities, EntityUtil.toMap(fieldKey, value));
    }

    public static <T extends AbstractBillEntity> T findBill(List<T> entities, String fieldKey, Object value) throws Throwable {
        List<T> result = EntityUtil.filterBill(entities, EntityUtil.toMap(fieldKey, value));
        if (result == null) {
            return null;
        }
        if (result.size() > 1) {
            throw new Exception("\u627e\u5230\u4e86\u4e00\u4e2a\u4ee5\u4e0a\u7684\u5b9e\u4f53,\u9519\u8bef.");
        }
        return (T)((AbstractBillEntity)result.get(0));
    }

    public static Map<String, Object> toMap(Object ... fieldValues) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int count = fieldValues.length;
        int i = 0;
        while (i < count) {
            result.put(String.valueOf(fieldValues[i]), fieldValues[i + 1]);
            i += 2;
        }
        return result;
    }

    public static <T extends AbstractTableEntity> void sort(List<T> list, final List<Comparator<T>> comparatorList) {
        if (comparatorList.isEmpty()) {
            throw new IllegalArgumentException("comparatorList is empty.");
        }
        Comparator comparator = new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                for (Comparator c : comparatorList) {
                    if (c.compare(o1, o2) > 0) {
                        return 1;
                    }
                    if (c.compare(o1, o2) >= 0) continue;
                    return -1;
                }
                return 0;
            }
        };
        Collections.sort(list, comparator);
    }

    public static <T extends AbstractTableEntity> void sort(List<T> list, String sortFieldKey) {
        Comparator comparator = (o1, o2) -> {
            try {
                return VarUtil.compare((Object)o1.valueByFieldKey(sortFieldKey), (Object)o2.valueByFieldKey(sortFieldKey));
            }
            catch (Throwable e) {
                LogSvr.getInstance().error(e.getMessage(), e);
                return 0;
            }
        };
        Collections.sort(list, comparator);
    }

    public static <T extends AbstractBillEntity> T cloneNew(EntityContextAction context, T oldBill) throws Throwable {
        return context.cloneBill(oldBill, null);
    }

    public static <T extends AbstractTableEntity> List<T> getTableEntitiesList(RichDocument doc, Class<T> tableEntityClass) throws Throwable {
        String tableName = EntityHelper.getInstance().getEntityClassNameMap().getTableName(tableEntityClass);
        MetaDataObject metaDataObject = doc.getMetaForm().getDataSource().getDataObject();
        MetaTableCollection metaTableCol = metaDataObject.getTableCollection();
        String metaTableKey = "";
        for (MetaTable metaTable : metaTableCol) {
            if (!metaTable.getBindingDBTableName().equalsIgnoreCase(tableName)) continue;
            metaTableKey = metaTable.getKey();
            break;
        }
        if (metaTableKey.length() == 0) {
            throw new Exception(String.valueOf(metaDataObject.getKey()) + "\u8868\u5355\u4e2d\u4e0d\u5b58\u5728 " + tableName);
        }
        DataTable rst = doc.getDataTable(metaTableKey);
        ArrayList<AbstractTableEntity> result = new ArrayList<AbstractTableEntity>(rst.size());
        int length = rst.size();
        int rowIndex = 0;
        while (rowIndex < length) {
            Method method = tableEntityClass.getDeclaredMethod("parseRowset", DataTable.class, Long.class, Integer.TYPE);
            Long oid = rst.getLong(rowIndex, "OID");
            AbstractTableEntity t = (AbstractTableEntity)method.invoke(tableEntityClass, rst, oid, rowIndex);
            result.add(t);
            ++rowIndex;
        }
        return result;
    }

    public static <T extends AbstractTableEntity> T getTableEntity(Class<T> tableEntityClass, DataTable dataTable, Long oid, int rowIndex) throws Throwable {
        Method method = tableEntityClass.getDeclaredMethod("parseRowset", DataTable.class, Long.class, Integer.TYPE);
        AbstractTableEntity t = (AbstractTableEntity)tableEntityClass.cast(method.invoke(tableEntityClass, dataTable, oid, rowIndex));
        return (T)t;
    }

    public static <T extends AbstractBillEntity> T getBillEntity(Class<T> billEntityClass, RichDocument document) throws Throwable {
        Method method = billEntityClass.getDeclaredMethod("parseDocument", RichDocument.class);
        AbstractBillEntity t = (AbstractBillEntity)billEntityClass.cast(method.invoke(billEntityClass, document));
        return (T)t;
    }

    public static <T> ArrayList<T> newSmallArrayList() {
        return new ArrayList(1);
    }

    public static <T> ArrayList<T> newSmallArrayList(int size) {
        if (size <= 0) {
            size = 1;
        }
        return new ArrayList(size);
    }

    public static void cloneTableEntity(RichDocumentContext context, AbstractTableEntity srcTableEntity, AbstractTableEntity tgtTableEntity, boolean isCloneAll) throws Throwable {
        MetaTable metaTable = tgtTableEntity.metaTable();
        DataTableMetaData srcMetaData = srcTableEntity.getMetaData();
        for (MetaColumn col : metaTable) {
            String ColumnKey = col.getKey();
            String dbColumnName = col.getDBColumnName();
            if (EntityUtil.isSystemField(ColumnKey)) continue;
            if (ERPStringUtil.isBlankOrNull((Object)dbColumnName)) {
                dbColumnName = ColumnKey;
            }
            if (!srcMetaData.constains(ColumnKey) || !isCloneAll && !srcTableEntity.isColumnUpdated(dbColumnName)) continue;
            Object newValue = srcTableEntity.valueByColumnName(dbColumnName);
            tgtTableEntity.valueByColumnName(dbColumnName, newValue);
        }
    }

    public static void cloneTableEntity(RichDocumentContext context, DataTable srcDataTable, int srcRowIndex, AbstractTableEntity tgtTableEntity, boolean isCloneAll) throws Throwable {
        MetaTable metaTable = tgtTableEntity.metaTable();
        DataTableMetaData srcMetaData = srcDataTable.getMetaData();
        for (MetaColumn col : metaTable) {
            String ColumnKey = col.getKey();
            String dbColumnName = col.getDBColumnName();
            if (EntityUtil.isSystemField(ColumnKey)) continue;
            if (ERPStringUtil.isBlankOrNull((Object)dbColumnName)) {
                dbColumnName = ColumnKey;
            }
            if (!srcMetaData.constains(ColumnKey) || !isCloneAll && !EntityUtil.isColumnUpdated(srcDataTable, srcRowIndex, dbColumnName)) continue;
            Object newValue = srcDataTable.getObject(srcRowIndex, dbColumnName);
            tgtTableEntity.valueByColumnName(dbColumnName, newValue);
        }
    }

    private static boolean isColumnUpdated(DataTable dt, int rowIndex, String columnName) throws Throwable {
        Object originalValue;
        Object value = dt.getObject(rowIndex, columnName);
        boolean result = VarUtil.compare((Object)value, (Object)(originalValue = dt.getOriginalObject(rowIndex, columnName))) != 0;
        return result;
    }

    private static boolean isSystemField(String columnKey) {
        return systemFields.contains(columnKey);
    }

    public static void batchProcessing(EntityContextAction action, FailableConsumer<ContextLifeCycleManager, Throwable> consumer) throws Throwable {
        ContextLifeCycleManager contextLifeCycleManager = new ContextLifeCycleManager(action);
        contextLifeCycleManager.newContext();
        consumer.accept((Object)contextLifeCycleManager);
        contextLifeCycleManager.commitAndNewContext(false);
        action._context = contextLifeCycleManager.getOriginalMidContext();
    }

    public static class ContextLifeCycleManager {
        EntityContextAction action;
        RichDocumentContext originalMidContext;

        protected RichDocumentContext getOriginalMidContext() {
            return this.originalMidContext;
        }

        private ContextLifeCycleManager(EntityContextAction action) {
            this.action = action;
            this.originalMidContext = action._context;
        }

        public void commitAndNewContext() throws Throwable {
            this.commitAndNewContext(true);
        }

        protected RichDocumentContext newContext() throws Throwable {
            RichDocumentContext midContext = this.action.getMidContext();
            this.action._context = midContext.newMidContext();
            return this.action._context;
        }

        protected void commitAndNewContext(boolean isNewContext) throws Throwable {
            try (RichDocumentContext midContext = this.action.getMidContext();){
                try {
                    midContext.commit();
                    if (isNewContext) {
                        this.newContext();
                    }
                }
                catch (Throwable e) {
                    midContext.rollback();
                    throw e;
                }
            }
        }
    }
}

