/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.entity.util;

import com.bokesoft.erp.entity.util.AbstractTableEntity;
import com.bokesoft.erp.entity.util.IBillEntity;
import com.bokesoft.yes.mid.cmd.richdocument.strut.IDLookup;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocument;
import com.bokesoft.yes.util.VarUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractBillEntity
implements IBillEntity {
    public RichDocument document;
    protected boolean runValueChanged = true;

    public void setNotRunValueChanged() {
        this.runValueChanged = false;
    }

    public void setRunValueChanged() {
        this.runValueChanged = true;
    }

    public boolean isRunValueChanged() {
        return this.runValueChanged;
    }

    @Override
    public DataTable getDataTable(String tableKey) throws Throwable {
        return this.document.getDataTable(tableKey);
    }

    @Override
    public void setDataTable(String tableKey, DataTable dataTable) throws Throwable {
        this.document.setDataTable(tableKey, dataTable);
    }

    @Override
    public Object getValue(String fieldKey) throws Throwable {
        return this.getValue(fieldKey, this.getOID());
    }

    @Override
    public Object getValue(String fieldKey, Long oid) throws Throwable {
        IDLookup idLookup = IDLookup.getIDLookup((MetaForm)this.document.getMetaForm());
        MetaColumn metaColumn = idLookup.getMetaColumnByFieldKey(fieldKey);
        if (metaColumn != null && metaColumn.isSupportI18n().booleanValue()) {
            String tableKey = idLookup.getTableKeyByFieldKey(fieldKey);
            DataTable dataTable = this.document.getDataTable(String.valueOf(tableKey) + "_T");
            if (dataTable == null || dataTable.size() == 0) {
                return this.document.getValue(fieldKey, oid);
            }
            String[] key = new String[]{"SrcLangOID", "Lang"};
            Object[] value = new Object[]{oid, this.document.getContext().getEnv().getLocale()};
            int[] rows = dataTable.fastFilter(key, value);
            if (rows.length > 0) {
                return dataTable.getObject(rows[0], fieldKey);
            }
            return dataTable.getObject(0, fieldKey);
        }
        return this.document.getValue(fieldKey, oid);
    }

    public Object getValueFirst(String fieldKey) throws Throwable {
        MetaForm metaForm = this.document.getMetaForm();
        IDLookup lookup = IDLookup.getIDLookup((MetaForm)metaForm);
        String tableKey = lookup.getTableKeyByFieldKey(fieldKey);
        DataTable rst = this.getDataTable(tableKey);
        Object result = null;
        if (rst != null && rst.size() > 0) {
            IDLookup idLookup = IDLookup.getIDLookup((MetaForm)this.document.getMetaForm());
            MetaColumn metaColumn = idLookup.getMetaColumnByFieldKey(fieldKey);
            if (metaColumn != null && metaColumn.isSupportI18n().booleanValue()) {
                Long oid = rst.getLong(0, "OID");
                result = this.getValue(fieldKey, oid);
            } else {
                int bookMark = rst.getRowByIndex(0).getBookmark();
                result = this.document.getValue(fieldKey, bookMark);
            }
        }
        return result;
    }

    protected int value_Int(String fieldKey, Long oid) throws Throwable {
        return TypeConvertor.toInteger((Object)this.getValue(fieldKey, oid));
    }

    protected int value_Int(String fieldKey) throws Throwable {
        return TypeConvertor.toInteger((Object)this.getValue(fieldKey, this.getOID()));
    }

    protected int valueFirst_Int(String fieldKey) throws Throwable {
        return TypeConvertor.toInteger((Object)this.getValueFirst(fieldKey));
    }

    protected Long value_Long(String fieldKey, Long oid) throws Throwable {
        return TypeConvertor.toLong((Object)this.getValue(fieldKey, oid));
    }

    protected Long value_Long(String fieldKey) throws Throwable {
        return TypeConvertor.toLong((Object)this.getValue(fieldKey, this.getOID()));
    }

    protected Long valueFirst_Long(String fieldKey) throws Throwable {
        return TypeConvertor.toLong((Object)this.getValueFirst(fieldKey));
    }

    protected String value_String(String fieldKey, Long oid) throws Throwable {
        return TypeConvertor.toString((Object)this.getValue(fieldKey, oid));
    }

    protected String value_String(String fieldKey) throws Throwable {
        return TypeConvertor.toString((Object)this.getValue(fieldKey, this.getOID()));
    }

    protected String valueFirst_String(String fieldKey) throws Throwable {
        return TypeConvertor.toString((Object)this.getValueFirst(fieldKey));
    }

    protected BigDecimal value_BigDecimal(String fieldKey, Long oid) throws Throwable {
        return TypeConvertor.toBigDecimal((Object)this.getValue(fieldKey, oid));
    }

    protected BigDecimal value_BigDecimal(String fieldKey) throws Throwable {
        return TypeConvertor.toBigDecimal((Object)this.getValue(fieldKey, this.getOID()));
    }

    protected BigDecimal valueFirst_BigDecimal(String fieldKey) throws Throwable {
        return TypeConvertor.toBigDecimal((Object)this.getValueFirst(fieldKey));
    }

    protected Date value_Date(String fieldKey, Long oid) throws Throwable {
        return new Date(TypeConvertor.toDate((Object)this.getValue(fieldKey, oid)).getTime());
    }

    protected Date value_Date(String fieldKey) throws Throwable {
        Object value = this.getValue(fieldKey, this.getOID());
        if (value == null) {
            return null;
        }
        return new Date(TypeConvertor.toDate((Object)value).getTime());
    }

    protected Timestamp value_Timestamp(String fieldKey, Long oid) throws Throwable {
        return VarUtil.toTimestamp((Object)this.getValue(fieldKey, oid));
    }

    protected Timestamp value_Timestamp(String fieldKey) throws Throwable {
        return VarUtil.toTimestamp((Object)this.getValue(fieldKey));
    }

    protected Timestamp valueFirst_Timestamp(String fieldKey) throws Throwable {
        return VarUtil.toTimestamp((Object)this.getValueFirst(fieldKey));
    }

    public List<Integer> valueListInt(String fieldKey) throws Throwable {
        MetaForm metaForm = this.document.getMetaForm();
        IDLookup lookup = IDLookup.getIDLookup((MetaForm)metaForm);
        String tableKey = lookup.getTableKeyByFieldKey(fieldKey);
        List<Integer> result = this.valueListInt(tableKey, fieldKey);
        return result;
    }

    protected List<Integer> valueListInt(String tableKey, String fieldKey) throws Throwable {
        Long[] oids = this.document.getOIDs(tableKey);
        ArrayList<Integer> result = new ArrayList<Integer>(oids.length);
        Long[] longArray = oids;
        int n = oids.length;
        int n2 = 0;
        while (n2 < n) {
            Long oid = longArray[n2];
            result.add(TypeConvertor.toInteger((Object)this.getValue(fieldKey, oid)));
            ++n2;
        }
        return result;
    }

    public List<Long> valueListLong(String fieldKey) throws Throwable {
        MetaForm metaForm = this.document.getMetaForm();
        IDLookup lookup = IDLookup.getIDLookup((MetaForm)metaForm);
        String tableKey = lookup.getTableKeyByFieldKey(fieldKey);
        List<Long> result = this.valueListLong(tableKey, fieldKey);
        return result;
    }

    protected List<Long> valueListLong(String tableKey, String fieldKey) throws Throwable {
        Long[] oids = this.document.getOIDs(tableKey);
        ArrayList<Long> result = new ArrayList<Long>(oids.length);
        Long[] longArray = oids;
        int n = oids.length;
        int n2 = 0;
        while (n2 < n) {
            Long oid = longArray[n2];
            result.add(TypeConvertor.toLong((Object)this.getValue(fieldKey, oid)));
            ++n2;
        }
        return result;
    }

    public List<String> valueListString(String fieldKey) throws Throwable {
        MetaForm metaForm = this.document.getMetaForm();
        IDLookup lookup = IDLookup.getIDLookup((MetaForm)metaForm);
        String tableKey = lookup.getTableKeyByFieldKey(fieldKey);
        Long[] oids = this.document.getOIDs(tableKey);
        ArrayList<String> result = new ArrayList<String>(oids.length);
        Long[] longArray = oids;
        int n = oids.length;
        int n2 = 0;
        while (n2 < n) {
            Long oid = longArray[n2];
            result.add(TypeConvertor.toString((Object)this.getValue(fieldKey, oid)));
            ++n2;
        }
        return result;
    }

    public List<BigDecimal> valueListBigDecimal(String fieldKey) throws Throwable {
        MetaForm metaForm = this.document.getMetaForm();
        IDLookup lookup = IDLookup.getIDLookup((MetaForm)metaForm);
        String tableKey = lookup.getTableKeyByFieldKey(fieldKey);
        Long[] oids = this.document.getOIDs(tableKey);
        ArrayList<BigDecimal> result = new ArrayList<BigDecimal>(oids.length);
        Long[] longArray = oids;
        int n = oids.length;
        int n2 = 0;
        while (n2 < n) {
            Long oid = longArray[n2];
            result.add(TypeConvertor.toBigDecimal((Object)this.getValue(fieldKey, oid)));
            ++n2;
        }
        return result;
    }

    @Override
    public String getMetaFormKey() throws Throwable {
        return this.document.getMetaForm().getKey();
    }

    public String code() throws Throwable {
        MetaForm metaForm = this.document.getMetaForm();
        if (metaForm.getFormType() == 2) {
            return this.value_String("Code");
        }
        return "";
    }

    public abstract <T extends AbstractTableEntity> List<T> tableEntities(Class<T> var1) throws Throwable;

    public abstract <T extends AbstractTableEntity> T newTableEntity(Class<T> var1) throws Throwable;

    public abstract void deleteTableEntity(AbstractTableEntity var1) throws Throwable;

    public abstract <T extends AbstractTableEntity> Collection<Class<T>> allTableEntitieClasss();

    @Override
    public void setValue(String fieldKey, Long oid, Object value) throws Throwable {
        if (this.runValueChanged) {
            this.document.setValue(fieldKey, oid, value);
        } else {
            this.document.setValueNoChanged(fieldKey, oid, value);
        }
    }

    @Override
    public void setValue(String fieldKey, Object value) throws Throwable {
        if (this.runValueChanged) {
            this.document.setValue(fieldKey, this.getOID(), value);
        } else {
            this.document.setValueNoChanged(fieldKey, this.getOID(), value);
        }
    }

    public void setValueAll(String fieldKey, Object value) throws Throwable {
        Long[] oids;
        MetaForm metaForm = this.document.getMetaForm();
        IDLookup lookup = IDLookup.getIDLookup((MetaForm)metaForm);
        String tableKey = lookup.getTableKeyByFieldKey(fieldKey);
        Long[] longArray = oids = this.document.getOIDs(tableKey);
        int n = oids.length;
        int n2 = 0;
        while (n2 < n) {
            Long oid = longArray[n2];
            if (this.runValueChanged) {
                this.document.setValue(fieldKey, oid, value);
            } else {
                this.document.setValueNoChanged(fieldKey, oid, value);
            }
            ++n2;
        }
    }

    public void value4Dictionary(String fieldKey, Long oid, Long value) throws Throwable {
        if (value < 0L) {
            value = 0L;
        }
        this.setValue(fieldKey, oid, value);
    }

    public void value4Dictionary(String fieldKey, Long value) throws Throwable {
        if (value < 0L) {
            value = 0L;
        }
        this.setValue(fieldKey, this.getOID(), value);
    }

    public Long getOID() throws Throwable {
        return this.document.getOID();
    }
}

